/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.compute.vpc;

import com.eucalyptus.compute.common.CloudMetadata;
import com.eucalyptus.compute.vpc.InternetGatewayTag;
import com.eucalyptus.compute.vpc.Vpc;
import com.eucalyptus.entities.AbstractOwnedPersistent;
import com.eucalyptus.util.OwnerFullName;
import java.util.Collection;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.PersistenceContext;
import javax.persistence.Table;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;

@Entity
@PersistenceContext(name="eucalyptus_cloud")
@Table(name="metadata_internet_gateways")
@Cache(usage=CacheConcurrencyStrategy.TRANSACTIONAL)
public class InternetGateway
extends AbstractOwnedPersistent
implements CloudMetadata.InternetGatewayMetadata {
    private static final long serialVersionUID = 1L;
    @ManyToOne
    @JoinColumn(name="metadata_vpc_id")
    @Cache(usage=CacheConcurrencyStrategy.TRANSACTIONAL)
    private Vpc vpc;
    @OneToMany(fetch=FetchType.LAZY, cascade={CascadeType.REMOVE}, orphanRemoval=true, mappedBy="internetGateway")
    private Collection<InternetGatewayTag> tags;

    protected InternetGateway() {
    }

    protected InternetGateway(OwnerFullName owner, String displayName) {
        super(owner, displayName);
    }

    public static InternetGateway create(OwnerFullName owner, String name) {
        return new InternetGateway(owner, name);
    }

    public static InternetGateway exampleWithOwner(OwnerFullName owner) {
        return new InternetGateway(owner, null);
    }

    public static InternetGateway exampleWithName(OwnerFullName owner, String name) {
        return new InternetGateway(owner, name);
    }

    public Vpc getVpc() {
        return this.vpc;
    }

    public void setVpc(Vpc vpc) {
        this.vpc = vpc;
    }
}

