/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.compute.vpc;

import com.eucalyptus.compute.common.CloudMetadata;
import com.eucalyptus.compute.common.CloudMetadatas;
import com.eucalyptus.compute.common.DhcpConfigurationItemType;
import com.eucalyptus.compute.common.DhcpOptionsType;
import com.eucalyptus.compute.vpc.DhcpOption;
import com.eucalyptus.compute.vpc.DhcpOptionSet;
import com.eucalyptus.compute.vpc.DhcpOptionSetTag;
import com.eucalyptus.compute.vpc.Lister;
import com.eucalyptus.compute.vpc.VpcMetadataException;
import com.eucalyptus.tags.FilterSupport;
import com.eucalyptus.util.OwnerFullName;
import com.eucalyptus.util.TypeMapper;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.hibernate.criterion.Criterion;

public interface DhcpOptionSets
extends Lister<DhcpOptionSet> {
    public static final String DHCP_OPTION_DOMAIN_NAME_SERVERS = "domain-name-servers";
    public static final String DHCP_OPTION_DOMAIN_NAME = "domain-name";
    public static final String DHCP_OPTION_NTP_SERVERS = "ntp-servers";
    public static final String DHCP_OPTION_NETBIOS_NAME_SERVERS = "netbios-name-servers";
    public static final String DHCP_OPTION_NETBIOS_NODE_TYPE = "netbios-node-type";
    public static final Set<String> DHCP_OPTIONS = ImmutableSortedSet.of((Comparable)((Object)"domain-name-servers"), (Comparable)((Object)"domain-name"), (Comparable)((Object)"ntp-servers"), (Comparable)((Object)"netbios-name-servers"), (Comparable)((Object)"netbios-node-type"));

    @Override
    public <T> List<T> list(OwnerFullName var1, Criterion var2, Map<String, String> var3, Predicate<? super DhcpOptionSet> var4, Function<? super DhcpOptionSet, T> var5) throws VpcMetadataException;

    public <T> T lookupByName(@Nullable OwnerFullName var1, String var2, Function<? super DhcpOptionSet, T> var3) throws VpcMetadataException;

    public <T> T lookupByExample(DhcpOptionSet var1, @Nullable OwnerFullName var2, String var3, Predicate<? super DhcpOptionSet> var4, Function<? super DhcpOptionSet, T> var5) throws VpcMetadataException;

    public boolean delete(CloudMetadata.DhcpOptionSetMetadata var1) throws VpcMetadataException;

    public DhcpOptionSet save(DhcpOptionSet var1) throws VpcMetadataException;

    public static enum DhcpOptionStringSetFunctions implements Function<DhcpOption, Set<String>>
    {
        VALUE{

            public Set<String> apply(DhcpOption dhcpOption) {
                return Sets.newHashSet(dhcpOption.getValues());
            }
        };

    }

    public static enum DhcpOptionStringFunctions implements Function<DhcpOption, String>
    {
        KEY{

            public String apply(DhcpOption dhcpOption) {
                return dhcpOption.getKey();
            }
        };

    }

    public static enum FilterStringSetFunctions implements Function<DhcpOptionSet, Set<String>>
    {
        KEY{

            public Set<String> apply(DhcpOptionSet dhcpOptionSet) {
                return Sets.newHashSet((Iterable)Iterables.transform(dhcpOptionSet.getDhcpOptions(), (Function)DhcpOptionStringFunctions.KEY));
            }
        }
        ,
        VALUE{

            public Set<String> apply(DhcpOptionSet dhcpOptionSet) {
                return Sets.newHashSet((Iterable)Iterables.concat((Iterable)Iterables.transform(dhcpOptionSet.getDhcpOptions(), (Function)DhcpOptionStringSetFunctions.VALUE)));
            }
        };

    }

    public static class DhcpOptionSetFilterSupport
    extends FilterSupport<DhcpOptionSet> {
        public DhcpOptionSetFilterSupport() {
            super(DhcpOptionSetFilterSupport.builderFor(DhcpOptionSet.class).withTagFiltering(DhcpOptionSetTag.class, "dhcpOptionSet").withStringProperty("dhcp-options-id", (Function<DhcpOptionSet, String>)CloudMetadatas.toDisplayName()).withStringSetProperty("key", FilterStringSetFunctions.KEY).withStringSetProperty("value", FilterStringSetFunctions.VALUE).withPersistenceAlias("dhcpOptions", "dhcpOptions").withPersistenceFilter("dhcp-options-id", "displayName").withPersistenceFilter("key", "dhcpOptions.key"));
        }
    }

    @TypeMapper
    public static enum DhcpOptionToDhcpConfigurationItemTypeTransform implements Function<DhcpOption, DhcpConfigurationItemType>
    {
        INSTANCE;


        @Nullable
        public DhcpConfigurationItemType apply(@Nullable DhcpOption dhcpOption) {
            return dhcpOption == null ? null : new DhcpConfigurationItemType(dhcpOption.getKey(), dhcpOption.getValues());
        }
    }

    @TypeMapper
    public static enum DhcpOptionSetToDhcpOptionsTypeTransform implements Function<DhcpOptionSet, DhcpOptionsType>
    {
        INSTANCE;


        @Nullable
        public DhcpOptionsType apply(@Nullable DhcpOptionSet dhcpOptionSet) {
            return dhcpOptionSet == null ? null : new DhcpOptionsType(dhcpOptionSet.getDisplayName(), Collections2.transform(dhcpOptionSet.getDhcpOptions(), (Function)DhcpOptionToDhcpConfigurationItemTypeTransform.INSTANCE));
        }
    }
}

