/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.compute.vpc;

import com.eucalyptus.compute.common.CloudMetadata;
import com.eucalyptus.compute.vpc.DhcpOptionSet;
import com.eucalyptus.entities.Entities;
import com.eucalyptus.entities.TransactionException;
import com.eucalyptus.tags.Tag;
import com.eucalyptus.tags.TagSupport;
import com.eucalyptus.tags.Tags;
import com.eucalyptus.util.OwnerFullName;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.PersistenceContext;
import javax.persistence.Table;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;

@Entity
@PersistenceContext(name="eucalyptus_cloud")
@Table(name="metadata_tags_dhcp_option_sets")
@Cache(usage=CacheConcurrencyStrategy.TRANSACTIONAL)
@DiscriminatorValue(value="dhcp-options")
public class DhcpOptionSetTag
extends Tag<DhcpOptionSetTag> {
    private static final long serialVersionUID = 1L;
    @JoinColumn(name="metadata_tag_resource_id", updatable=false, nullable=false)
    @ManyToOne(fetch=FetchType.LAZY)
    private DhcpOptionSet dhcpOptionSet;

    protected DhcpOptionSetTag() {
        super("dhcp-options", ResourceIdFunction.INSTANCE);
    }

    public DhcpOptionSetTag(@Nonnull DhcpOptionSet dhcpOptionSet, @Nonnull OwnerFullName ownerFullName, @Nullable String key, @Nullable String value) {
        super("dhcp-options", ResourceIdFunction.INSTANCE, ownerFullName, key, value);
        this.setDhcpOptionSet(dhcpOptionSet);
        this.init();
    }

    public DhcpOptionSet getDhcpOptionSet() {
        return this.dhcpOptionSet;
    }

    public void setDhcpOptionSet(DhcpOptionSet dhcpOptionSet) {
        this.dhcpOptionSet = dhcpOptionSet;
    }

    @Nonnull
    public static Tag named(@Nonnull DhcpOptionSet dhcpOptionSet, @Nonnull OwnerFullName ownerFullName, @Nullable String key) {
        return DhcpOptionSetTag.namedWithValue(dhcpOptionSet, ownerFullName, key, null);
    }

    @Nonnull
    public static Tag namedWithValue(@Nonnull DhcpOptionSet dhcpOptionSet, @Nonnull OwnerFullName ownerFullName, @Nullable String key, @Nullable String value) {
        Preconditions.checkNotNull((Object)((Object)dhcpOptionSet), (Object)"dhcpOptionSet");
        Preconditions.checkNotNull((Object)ownerFullName, (Object)"ownerFullName");
        return new DhcpOptionSetTag(dhcpOptionSet, ownerFullName, key, value);
    }

    public static final class DhcpOptionSetTagSupport
    extends TagSupport {
        public DhcpOptionSetTagSupport() {
            super(DhcpOptionSet.class, "dopt", "displayName", "dhcpOptionSet", " InvalidDhcpOptionsID.NotFound", "The dhcp option set '%s' does not exist.");
        }

        @Override
        public Tag createOrUpdate(CloudMetadata metadata, OwnerFullName ownerFullName, String key, String value) {
            return Tags.createOrUpdate(new DhcpOptionSetTag((DhcpOptionSet)metadata, ownerFullName, key, value));
        }

        @Override
        public Tag example(@Nonnull CloudMetadata metadata, @Nonnull OwnerFullName ownerFullName, String key, String value) {
            return DhcpOptionSetTag.namedWithValue((DhcpOptionSet)metadata, ownerFullName, key, value);
        }

        @Override
        public Tag example(@Nonnull OwnerFullName ownerFullName) {
            return this.example(new DhcpOptionSetTag(), ownerFullName);
        }

        @Override
        public CloudMetadata lookup(String identifier) throws TransactionException {
            return (CloudMetadata)Entities.uniqueResult((Object)((Object)DhcpOptionSet.exampleWithName(null, identifier)));
        }
    }

    private static enum ResourceIdFunction implements Function<DhcpOptionSetTag, String>
    {
        INSTANCE{

            public String apply(DhcpOptionSetTag dhcpOptionSetTag) {
                return dhcpOptionSetTag.getDhcpOptionSet().getDisplayName();
            }
        };

    }
}

