/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.compute.vpc;

import com.eucalyptus.compute.common.CloudMetadata;
import com.eucalyptus.compute.vpc.DhcpOption;
import com.eucalyptus.compute.vpc.DhcpOptionSetTag;
import com.eucalyptus.entities.AbstractOwnedPersistent;
import com.eucalyptus.util.OwnerFullName;
import com.eucalyptus.util.Strings;
import com.eucalyptus.vm.VmInstances;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.OneToMany;
import javax.persistence.PersistenceContext;
import javax.persistence.Table;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;

@Entity
@PersistenceContext(name="eucalyptus_cloud")
@Table(name="metadata_dhcp_option_sets")
@Cache(usage=CacheConcurrencyStrategy.TRANSACTIONAL)
public class DhcpOptionSet
extends AbstractOwnedPersistent
implements CloudMetadata.DhcpOptionSetMetadata {
    private static final long serialVersionUID = 1L;
    @Column(name="metadata_default", nullable=false, updatable=false)
    private Boolean defaultOptions;
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true, mappedBy="dhcpOptionSet")
    @Cache(usage=CacheConcurrencyStrategy.TRANSACTIONAL)
    private Set<DhcpOption> dhcpOptions = new HashSet<DhcpOption>();
    @OneToMany(fetch=FetchType.LAZY, cascade={CascadeType.REMOVE}, orphanRemoval=true, mappedBy="dhcpOptionSet")
    private Collection<DhcpOptionSetTag> tags;

    protected DhcpOptionSet() {
    }

    protected DhcpOptionSet(OwnerFullName owner, String displayName) {
        super(owner, displayName);
    }

    public static DhcpOptionSet create(OwnerFullName owner, String name) {
        DhcpOptionSet dhcpOptionSet = new DhcpOptionSet(owner, name);
        dhcpOptionSet.setDefaultOptions(false);
        return dhcpOptionSet;
    }

    public static DhcpOptionSet createDefault(OwnerFullName owner, String name) {
        DhcpOptionSet dhcpOptionSet = new DhcpOptionSet(owner, name);
        dhcpOptionSet.setDefaultOptions(true);
        dhcpOptionSet.setDhcpOptions(Sets.newHashSet((Object[])new DhcpOption[]{DhcpOption.create(dhcpOptionSet, "domain-name", Strings.trimPrefix((String)".", (String)(VmInstances.INSTANCE_SUBDOMAIN + ".internal"))), DhcpOption.create(dhcpOptionSet, "domain-name-servers", "AmazonProvidedDNS")}));
        return dhcpOptionSet;
    }

    public static DhcpOptionSet exampleWithOwner(OwnerFullName owner) {
        return new DhcpOptionSet(owner, null);
    }

    public static DhcpOptionSet exampleWithName(OwnerFullName owner, String name) {
        return new DhcpOptionSet(owner, name);
    }

    public static DhcpOptionSet exampleDefault(OwnerFullName owner) {
        DhcpOptionSet dhcpOptionSet = DhcpOptionSet.exampleWithOwner(owner);
        dhcpOptionSet.setDefaultOptions(true);
        return dhcpOptionSet;
    }

    public Boolean getDefaultOptions() {
        return this.defaultOptions;
    }

    public void setDefaultOptions(Boolean defaultOptions) {
        this.defaultOptions = defaultOptions;
    }

    public Set<DhcpOption> getDhcpOptions() {
        return this.dhcpOptions;
    }

    public void setDhcpOptions(Set<DhcpOption> dhcpOptions) {
        this.dhcpOptions = dhcpOptions;
    }
}

