/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.compute.vpc;

import com.eucalyptus.compute.vpc.DhcpOptionSet;
import com.eucalyptus.entities.AbstractPersistent;
import com.google.common.collect.Lists;
import java.util.List;
import javax.persistence.CollectionTable;
import javax.persistence.Column;
import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OrderColumn;
import javax.persistence.PersistenceContext;
import javax.persistence.Table;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;

@Entity
@PersistenceContext(name="eucalyptus_cloud")
@Table(name="metadata_dhcp_options")
@Cache(usage=CacheConcurrencyStrategy.TRANSACTIONAL)
public class DhcpOption
extends AbstractPersistent {
    private static final long serialVersionUID = 1L;
    @ManyToOne(optional=false)
    @JoinColumn(name="metadata_dhcp_option_set_id")
    @Cache(usage=CacheConcurrencyStrategy.TRANSACTIONAL)
    private DhcpOptionSet dhcpOptionSet;
    @Column(name="metadata_key", nullable=false)
    private String key;
    @ElementCollection
    @CollectionTable(name="metadata_dhcp_option_values")
    @Column(name="metadata_value")
    @JoinColumn(name="metadata_dhcp_option_id")
    @OrderColumn(name="metadata_value_index")
    @Cache(usage=CacheConcurrencyStrategy.TRANSACTIONAL)
    private List<String> values;

    protected DhcpOption() {
    }

    protected DhcpOption(DhcpOptionSet dhcpOptionSet, String key, List<String> values) {
        this.dhcpOptionSet = dhcpOptionSet;
        this.key = key;
        this.values = values;
    }

    public static DhcpOption create(DhcpOptionSet dhcpOptionSet, String key, String value) {
        return DhcpOption.create(dhcpOptionSet, key, Lists.newArrayList((Object[])new String[]{value}));
    }

    public static DhcpOption create(DhcpOptionSet dhcpOptionSet, String key, List<String> values) {
        return new DhcpOption(dhcpOptionSet, key, values);
    }

    public DhcpOptionSet getDhcpOptionSet() {
        return this.dhcpOptionSet;
    }

    public void setDhcpOptionSet(DhcpOptionSet dhcpOptionSet) {
        this.dhcpOptionSet = dhcpOptionSet;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public List<String> getValues() {
        return this.values;
    }

    public void setValues(List<String> values) {
        this.values = values;
    }
}

