/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.compute.policy;

import com.eucalyptus.auth.AuthException;
import com.eucalyptus.auth.policy.PolicySpec;
import com.eucalyptus.auth.policy.key.KeyUtils;
import com.eucalyptus.auth.policy.key.PolicyKey;
import com.eucalyptus.auth.policy.key.QuotaKey;
import com.eucalyptus.auth.principal.AccountFullName;
import com.eucalyptus.auth.principal.Authorization;
import com.eucalyptus.auth.principal.UserFullName;
import com.eucalyptus.compute.common.CloudMetadata;
import com.eucalyptus.util.RestrictedTypes;
import net.sf.json.JSONException;

@PolicyKey(value="ec2:quota-volumenumber")
public class VolumeNumberQuotaKey
extends QuotaKey {
    private static final String KEY = "ec2:quota-volumenumber";

    public void validateValueType(String value) throws JSONException {
        KeyUtils.validateIntegerValue((String)value, (String)KEY);
    }

    public boolean canApply(String action, String resourceType) {
        return PolicySpec.qualifiedName((String)"ec2", (String)"createvolume").equals(action);
    }

    public String value(Authorization.Scope scope, String id, String resource, Long quantity) throws AuthException {
        switch (scope) {
            case ACCOUNT: {
                return Long.toString((Long)RestrictedTypes.quantityMetricFunction(CloudMetadata.VolumeMetadata.class).apply((Object)AccountFullName.getInstance((String)id, (String[])new String[0])) + 1L);
            }
            case GROUP: {
                return "Not supported";
            }
            case USER: {
                return Long.toString((Long)RestrictedTypes.quantityMetricFunction(CloudMetadata.VolumeMetadata.class).apply((Object)UserFullName.getInstance((String)id, (String[])new String[0])) + 1L);
            }
        }
        throw new AuthException("Invalid scope");
    }
}

