/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.compute.policy;

import com.eucalyptus.auth.AuthException;
import com.eucalyptus.auth.policy.PolicySpec;
import com.eucalyptus.auth.policy.condition.ArnConditionOp;
import com.eucalyptus.auth.policy.condition.ConditionOp;
import com.eucalyptus.auth.policy.key.PolicyKey;
import com.eucalyptus.compute.common.backend.RunInstancesType;
import com.eucalyptus.compute.policy.ComputeKey;
import com.eucalyptus.context.Contexts;
import com.eucalyptus.context.IllegalContextAccessException;
import com.eucalyptus.images.Images;
import com.eucalyptus.records.Logs;
import com.google.common.collect.ImmutableSet;
import edu.ucsb.eucalyptus.msgs.BaseMessage;
import java.util.NoSuchElementException;
import java.util.Set;
import net.sf.json.JSONException;

@PolicyKey(value="ec2:targetimage")
public class TargetImageKey
implements ComputeKey {
    static final String KEY_NAME = "ec2:targetimage";
    private static final Set<String> actions = ImmutableSet.builder().add((Object)PolicySpec.qualifiedName((String)"ec2", (String)"runinstances")).build();

    public String value() throws AuthException {
        block5: {
            try {
                String imageId = null;
                BaseMessage request = Contexts.lookup().getRequest();
                if (request instanceof RunInstancesType) {
                    imageId = ((RunInstancesType)request).getImageId();
                }
                if (imageId == null) break block5;
                String accountNumber = "";
                try {
                    accountNumber = Images.lookupImage(imageId).getOwnerAccountNumber();
                }
                catch (NoSuchElementException e) {
                    Logs.exhaust().debug((Object)("Image not found when evaluating target image condition key: " + imageId));
                }
                return String.format("arn:aws:ec2:eucalyptus:%s:image/%s", accountNumber, imageId);
            }
            catch (IllegalContextAccessException e) {
                Logs.exhaust().debug((Object)"Contextual request not found when evaluating target image condition key.");
            }
        }
        return null;
    }

    public void validateConditionType(Class<? extends ConditionOp> conditionClass) throws JSONException {
        if (!ArnConditionOp.class.isAssignableFrom(conditionClass)) {
            throw new JSONException("ec2:targetimage is not allowed in condition " + conditionClass.getName() + ". ARN conditions are required.");
        }
    }

    public void validateValueType(String value) throws JSONException {
        ComputeKey.Validation.assertArnValue(value);
    }

    public boolean canApply(String action, String resourceType) {
        return actions.contains(action);
    }
}

