/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.compute.policy;

import com.eucalyptus.auth.AuthException;
import com.eucalyptus.auth.policy.PolicySpec;
import com.eucalyptus.auth.policy.condition.ArnConditionOp;
import com.eucalyptus.auth.policy.condition.ConditionOp;
import com.eucalyptus.auth.policy.key.PolicyKey;
import com.eucalyptus.compute.policy.ComputeKey;
import com.eucalyptus.compute.policy.ComputePolicyContext;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import net.sf.json.JSONException;

@PolicyKey(value="ec2:subnet")
public class SubnetKey
implements ComputeKey {
    static final String KEY_NAME = "ec2:subnet";
    private static final Set<String> actions = ImmutableSet.builder().add((Object)PolicySpec.qualifiedName((String)"ec2", (String)"runinstances")).build();

    public String value() throws AuthException {
        return ComputePolicyContext.getSubnetArn();
    }

    public void validateConditionType(Class<? extends ConditionOp> conditionClass) throws JSONException {
        if (!ArnConditionOp.class.isAssignableFrom(conditionClass)) {
            throw new JSONException("ec2:subnet is not allowed in condition " + conditionClass.getName() + ". ARN conditions are required.");
        }
    }

    public void validateValueType(String value) throws JSONException {
        ComputeKey.Validation.assertArnValue(value);
    }

    public boolean canApply(String action, String resourceType) {
        return actions.contains(action);
    }
}

