/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.compute.policy;

import com.eucalyptus.auth.AuthException;
import com.eucalyptus.auth.policy.condition.ConditionOp;
import com.eucalyptus.auth.policy.condition.DateConditionOp;
import com.eucalyptus.auth.policy.key.Iso8601DateParser;
import com.eucalyptus.auth.policy.key.PolicyKey;
import com.eucalyptus.compute.policy.ComputeKey;
import com.eucalyptus.compute.policy.ComputePolicyContext;
import com.eucalyptus.compute.policy.SnapshotComputeKey;
import java.util.Date;
import net.sf.json.JSONException;

@PolicyKey(value="ec2:snapshottime")
public class SnapshotTimeKey
extends SnapshotComputeKey {
    static final String KEY_NAME = "ec2:snapshottime";

    public String value() throws AuthException {
        Date time = ComputePolicyContext.getSnapshotTime();
        return time == null ? null : Iso8601DateParser.toString((Date)time);
    }

    public void validateConditionType(Class<? extends ConditionOp> conditionClass) throws JSONException {
        if (!DateConditionOp.class.isAssignableFrom(conditionClass)) {
            throw new JSONException("ec2:snapshottime is not allowed in condition " + conditionClass.getName() + ". Date conditions are required.");
        }
    }

    public void validateValueType(String value) throws JSONException {
        ComputeKey.Validation.assertDateValue(value);
    }
}

