/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.compute.policy;

import com.eucalyptus.blockstorage.Snapshot;
import com.eucalyptus.compute.policy.ComputePolicyContext;
import com.eucalyptus.util.TypeMapper;
import com.google.common.base.Function;
import java.util.Date;
import javax.annotation.Nullable;

@TypeMapper
public class SnapshotComputePolicyContextTransform
implements Function<Snapshot, ComputePolicyContext.ComputePolicyContextResource> {
    public ComputePolicyContext.ComputePolicyContextResource apply(final Snapshot snapshot) {
        return new ComputePolicyContext.ComputePolicyContextResourceSupport(){

            @Override
            @Nullable
            public String getOwner() {
                return snapshot.getOwnerAccountNumber();
            }

            @Override
            @Nullable
            public String getParentVolumeArn() {
                return snapshot.getParentVolume() == null ? null : "arn:aws:ec2::" + this.getOwner() + ":volume/" + snapshot.getParentVolume();
            }

            @Override
            @Nullable
            public Date getSnapshotTime() {
                return snapshot.getCreationTimestamp();
            }

            @Override
            @Nullable
            public Integer getVolumeSize() {
                return snapshot.getVolumeSize();
            }
        };
    }
}

