/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.compute.policy;

import com.eucalyptus.compute.policy.ComputePolicyContext;
import com.eucalyptus.compute.vpc.NetworkInterface;
import com.eucalyptus.util.TypeMapper;
import com.google.common.base.Function;
import javax.annotation.Nullable;

@TypeMapper
public class NetworkInterfaceComputePolicyContextTransform
implements Function<NetworkInterface, ComputePolicyContext.ComputePolicyContextResource> {
    public ComputePolicyContext.ComputePolicyContextResource apply(final NetworkInterface networkInterface) {
        return new ComputePolicyContext.ComputePolicyContextResourceSupport(){

            @Override
            @Nullable
            public String getAvailabilityZone() {
                return networkInterface.getAvailabilityZone();
            }

            @Override
            @Nullable
            public String getSubnetArn() {
                return "arn:aws:ec2::" + networkInterface.getOwnerAccountNumber() + ":subnet/" + networkInterface.getSubnet().getDisplayName();
            }

            @Override
            @Nullable
            public String getVpcArn() {
                return "arn:aws:ec2::" + networkInterface.getOwnerAccountNumber() + ":vpc/" + networkInterface.getVpc().getDisplayName();
            }
        };
    }
}

