/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.compute.policy;

import com.eucalyptus.auth.PolicyResourceContext;
import com.eucalyptus.compute.common.CloudMetadata;
import com.eucalyptus.compute.policy.ComputePolicyContext;
import com.eucalyptus.records.Logs;
import com.eucalyptus.util.RestrictedType;
import com.eucalyptus.util.TypeMappers;
import com.google.common.collect.Sets;
import java.util.Set;

public class ComputePolicyResourceInterceptor
implements PolicyResourceContext.PolicyResourceInterceptor {
    private static final Set<Class<? extends RestrictedType>> accepted = Sets.newCopyOnWriteArraySet();
    private static final Set<Class<? extends RestrictedType>> rejected = Sets.newCopyOnWriteArraySet();

    public void onResource(PolicyResourceContext.PolicyResourceInfo resource, String action) {
        ComputePolicyContext.clearContext();
        if (resource != null && RestrictedType.class.isAssignableFrom(resource.getResourceClass()) && (accepted.contains(resource.getResourceClass()) || !rejected.contains(resource.getResourceClass()) && CloudMetadata.class.isAssignableFrom(resource.getResourceClass()))) {
            try {
                ComputePolicyContext.setComputePolicyContextResource((ComputePolicyContext.ComputePolicyContextResource)TypeMappers.transform((Object)resource.getResourceObject(), ComputePolicyContext.ComputePolicyContextResource.class));
                accepted.add(resource.getResourceClass());
            }
            catch (IllegalArgumentException e) {
                rejected.add(resource.getResourceClass());
                Logs.exhaust().info((Object)("Policy context not set for resource type: " + resource.getResourceClass().getSimpleName()));
            }
        }
    }
}

