/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.compute.policy;

import com.eucalyptus.blockstorage.Snapshots;
import com.eucalyptus.records.Logs;
import java.util.Date;
import javax.annotation.Nullable;

public class ComputePolicyContext {
    private static final ThreadLocal<ComputePolicyContextResource> resourceLocal = new ThreadLocal();

    static void clearContext() {
        resourceLocal.set(null);
    }

    static void setComputePolicyContextResource(@Nullable ComputePolicyContextResource resource) {
        resourceLocal.set(resource);
    }

    @Nullable
    static String getAvailabilityZone() {
        ComputePolicyContextResource resource = resourceLocal.get();
        return resource == null ? null : resource.getAvailabilityZone();
    }

    @Nullable
    static Boolean isEbsOptimized() {
        ComputePolicyContextResource resource = resourceLocal.get();
        return resource == null ? null : resource.isEbsOptimized();
    }

    @Nullable
    static Boolean isPublic() {
        ComputePolicyContextResource resource = resourceLocal.get();
        return resource == null ? null : resource.isPublic();
    }

    @Nullable
    static String getInstanceProfileArn() {
        ComputePolicyContextResource resource = resourceLocal.get();
        return resource == null ? null : resource.getInstanceProfileArn();
    }

    @Nullable
    static String getImageType() {
        ComputePolicyContextResource resource = resourceLocal.get();
        return resource == null ? null : resource.getImageType();
    }

    @Nullable
    static String getInstanceType() {
        ComputePolicyContextResource resource = resourceLocal.get();
        return resource == null ? null : resource.getInstanceType();
    }

    @Nullable
    static String getOwner() {
        ComputePolicyContextResource resource = resourceLocal.get();
        return resource == null ? null : resource.getOwner();
    }

    @Nullable
    static String getParentSnapshotArn() {
        ComputePolicyContextResource resource = resourceLocal.get();
        return resource == null ? null : resource.getParentSnapshotArn();
    }

    @Nullable
    static String getParentVolumeArn() {
        ComputePolicyContextResource resource = resourceLocal.get();
        return resource == null ? null : resource.getParentVolumeArn();
    }

    @Nullable
    static String getPlacementGroupArn() {
        ComputePolicyContextResource resource = resourceLocal.get();
        return resource == null ? null : resource.getPlacementGroupArn();
    }

    @Nullable
    static String getRegion() {
        return "eucalyptus";
    }

    @Nullable
    static String getRootDeviceType() {
        ComputePolicyContextResource resource = resourceLocal.get();
        return resource == null ? null : resource.getRootDeviceType();
    }

    @Nullable
    static Date getSnapshotTime() {
        ComputePolicyContextResource resource = resourceLocal.get();
        return resource == null ? null : resource.getSnapshotTime();
    }

    @Nullable
    static String getSubnetArn() {
        ComputePolicyContextResource resource = resourceLocal.get();
        return resource == null ? null : resource.getSubnetArn();
    }

    @Nullable
    static String getTenancy() {
        ComputePolicyContextResource resource = resourceLocal.get();
        return resource == null ? null : resource.getTenancy();
    }

    @Nullable
    static Integer getVolumeIops() {
        ComputePolicyContextResource resource = resourceLocal.get();
        return resource == null ? null : resource.getVolumeIops();
    }

    @Nullable
    static Integer getVolumeSize() {
        ComputePolicyContextResource resource = resourceLocal.get();
        return resource == null ? null : resource.getVolumeSize();
    }

    @Nullable
    static String getVolumeType() {
        ComputePolicyContextResource resource = resourceLocal.get();
        return resource == null ? null : resource.getVolumeType();
    }

    @Nullable
    static String getVpcArn() {
        ComputePolicyContextResource resource = resourceLocal.get();
        return resource == null ? null : resource.getVpcArn();
    }

    public static class ComputePolicyContextResourceSupport
    implements ComputePolicyContextResource {
        @Override
        @Nullable
        public String getAvailabilityZone() {
            return null;
        }

        @Override
        @Nullable
        public Boolean isEbsOptimized() {
            return null;
        }

        @Override
        @Nullable
        public Boolean isPublic() {
            return null;
        }

        @Override
        @Nullable
        public String getInstanceProfileArn() {
            return null;
        }

        @Override
        @Nullable
        public String getImageType() {
            return null;
        }

        @Override
        @Nullable
        public String getInstanceType() {
            return null;
        }

        @Override
        @Nullable
        public String getOwner() {
            return null;
        }

        @Override
        @Nullable
        public String getParentSnapshotArn() {
            return null;
        }

        @Override
        @Nullable
        public String getParentVolumeArn() {
            return null;
        }

        @Override
        @Nullable
        public String getPlacementGroupArn() {
            return null;
        }

        @Override
        @Nullable
        public String getRootDeviceType() {
            return null;
        }

        @Override
        @Nullable
        public Date getSnapshotTime() {
            return null;
        }

        @Override
        @Nullable
        public String getSubnetArn() {
            return null;
        }

        @Override
        @Nullable
        public String getTenancy() {
            return null;
        }

        @Override
        @Nullable
        public Integer getVolumeIops() {
            return null;
        }

        @Override
        @Nullable
        public Integer getVolumeSize() {
            return null;
        }

        @Override
        @Nullable
        public String getVolumeType() {
            return null;
        }

        @Override
        @Nullable
        public String getVpcArn() {
            return null;
        }

        @Nullable
        protected final String snapshotIdToArn(@Nullable String snapshotId) {
            String arn = null;
            if (snapshotId != null) {
                String accountNumber = "";
                try {
                    accountNumber = Snapshots.lookup(null, snapshotId).getOwnerAccountNumber();
                }
                catch (Exception e) {
                    Logs.exhaust().debug((Object)("Snapshot not found for ARN: " + snapshotId));
                }
                arn = String.format("arn:aws:ec2:eucalyptus:%s:snapshot/%s", accountNumber, snapshotId);
            }
            return arn;
        }
    }

    public static interface ComputePolicyContextResource {
        @Nullable
        public String getAvailabilityZone();

        @Nullable
        public Boolean isEbsOptimized();

        @Nullable
        public Boolean isPublic();

        @Nullable
        public String getInstanceProfileArn();

        @Nullable
        public String getImageType();

        @Nullable
        public String getInstanceType();

        @Nullable
        public String getOwner();

        @Nullable
        public String getParentSnapshotArn();

        @Nullable
        public String getParentVolumeArn();

        @Nullable
        public String getPlacementGroupArn();

        @Nullable
        public String getRootDeviceType();

        @Nullable
        public Date getSnapshotTime();

        @Nullable
        public String getSubnetArn();

        @Nullable
        public String getTenancy();

        @Nullable
        public Integer getVolumeIops();

        @Nullable
        public Integer getVolumeSize();

        @Nullable
        public String getVolumeType();

        @Nullable
        public String getVpcArn();
    }
}

