/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.compute.policy;

import com.eucalyptus.auth.policy.key.Iso8601DateParser;
import com.eucalyptus.auth.policy.key.Key;
import java.text.ParseException;
import java.util.regex.Pattern;
import net.sf.json.JSONException;

public interface ComputeKey
extends Key {

    public static class Validation {
        private static final Pattern arnPattern = Pattern.compile("[arn*?]{1,64}:[aws*?]{1,64}:[a-zA-Z0-9*?-]{1,64}(:[a-zA-Z0-9*?-]{0,64}(:(|amazon|[0-9*?]{1,12})(:.{1,2048})?)?)?");

        static void assertArnValue(String value) throws JSONException {
            if (!arnPattern.matcher(value).matches()) {
                throw new JSONException("Invalid ARN: " + value);
            }
        }

        static void assertDateValue(String value) throws JSONException {
            try {
                Iso8601DateParser.parse((String)value);
            }
            catch (ParseException e) {
                throw new JSONException("Invalid date: " + value);
            }
        }
    }
}

