/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.compute.metadata;

import com.eucalyptus.bootstrap.Databases;
import com.eucalyptus.compute.common.CloudMetadatas;
import com.eucalyptus.compute.common.network.Networking;
import com.eucalyptus.compute.common.network.NetworkingFeature;
import com.eucalyptus.compute.identifier.ResourceIdentifiers;
import com.eucalyptus.entities.Entities;
import com.eucalyptus.entities.TransactionResource;
import com.eucalyptus.records.Logs;
import com.eucalyptus.util.ByteArray;
import com.eucalyptus.util.Exceptions;
import com.eucalyptus.vm.MetadataRequest;
import com.eucalyptus.vm.NetworkGroupsMetadata;
import com.eucalyptus.vm.SensorsConfigMetadata;
import com.eucalyptus.vm.VmInstance;
import com.eucalyptus.vm.VmInstances;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheBuilderSpec;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.apache.log4j.Logger;

public class VmMetadata {
    private static Logger LOG = Logger.getLogger(VmMetadata.class);
    private static Function<MetadataRequest, ByteArray> dynamicFunc = new Function<MetadataRequest, ByteArray>(){

        public ByteArray apply(MetadataRequest arg0) {
            return ByteArray.newInstance((String)"");
        }
    };
    private static Function<MetadataRequest, ByteArray> userDataFunc = new Function<MetadataRequest, ByteArray>(){

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public ByteArray apply(MetadataRequest arg0) {
            try (TransactionResource db = Entities.transactionFor(VmInstance.class);){
                VmInstance instance = VmInstances.lookup(arg0.getVmInstanceId());
                ByteArray byteArray = ByteArray.newInstance((byte[])instance.getUserData());
                return byteArray;
            }
            catch (NoSuchElementException e) {
                throw new NoSuchElementException("Failed to lookup path: " + arg0.getLocalPath());
            }
        }
    };
    private static Function<MetadataRequest, ByteArray> metaDataFunc = new Function<MetadataRequest, ByteArray>(){

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public ByteArray apply(MetadataRequest arg0) {
            try (TransactionResource db = Entities.transactionFor(VmInstance.class);){
                VmInstance instance = VmInstances.lookup(arg0.getVmInstanceId());
                String res = instance.getByKey(arg0.getLocalPath());
                if (res == null) throw new NoSuchElementException("Failed to lookup path: " + arg0.getLocalPath());
                ByteArray byteArray = ByteArray.newInstance((String)res);
                return byteArray;
            }
            catch (NoSuchElementException noSuchElementException) {
                // empty catch block
            }
            throw new NoSuchElementException("Failed to lookup path: " + arg0.getLocalPath());
        }
    };
    private static ConcurrentMap<String, Function<MetadataRequest, ByteArray>> publicMetadataEndpoints = new ConcurrentSkipListMap<String, Function<MetadataRequest, ByteArray>>(){
        {
            this.put("", new Function<MetadataRequest, ByteArray>(){

                public ByteArray apply(MetadataRequest arg0) {
                    return ByteArray.newInstance((String)Joiner.on((String)"\n").join((Iterable)this.keySet()));
                }
            });
        }
    };
    private static ConcurrentMap<String, Function<MetadataRequest, ByteArray>> instanceMetadataEndpoints = new ConcurrentSkipListMap<String, Function<MetadataRequest, ByteArray>>(){
        {
            this.put("", new Function<MetadataRequest, ByteArray>(){

                public ByteArray apply(MetadataRequest arg0) {
                    String listing = "";
                    for (String key : this.keySet()) {
                        if ("".equals(key) || ((Function)this.get(key)).apply((Object)arg0) == null) continue;
                        listing = listing + key + "\n";
                    }
                    listing = listing.replaceAll("\n$", "");
                    return ByteArray.newInstance((String)listing);
                }
            });
            this.put("dynamic", dynamicFunc);
            this.put("user-data", VmMetadata.cache(userDataFunc, VmInstances.VM_METADATA_USER_DATA_CACHE));
            this.put("meta-data", VmMetadata.cache(metaDataFunc, VmInstances.VM_METADATA_INSTANCE_CACHE));
        }
    };
    private static ConcurrentMap<String, Function<MetadataRequest, ByteArray>> systemMetadataEndpoints = new ConcurrentSkipListMap<String, Function<MetadataRequest, ByteArray>>(){
        {
            this.put("", new Function<MetadataRequest, ByteArray>(){

                public ByteArray apply(MetadataRequest arg0) {
                    return ByteArray.newInstance((String)Joiner.on((String)"\n").join((Iterable)this.keySet()));
                }
            });
            this.put("network-topology", new NetworkGroupsMetadata());
            this.put("sensors-conf", new SensorsConfigMetadata());
        }
    };
    private static final Supplier<Set<NetworkingFeature>> networkingFeatureSupplier = Suppliers.memoizeWithExpiration((Supplier)new Supplier<Set<NetworkingFeature>>(){

        public Set<NetworkingFeature> get() {
            return Networking.getInstance().describeFeatures();
        }
    }, (long)30L, (TimeUnit)TimeUnit.SECONDS);
    private static final LoadingCache<String, Optional<String>> ipToVmIdCache = VmMetadata.cache(VmMetadata.resolveVm(), VmInstances.VM_METADATA_REQUEST_CACHE);

    private static <K, V> LoadingCache<K, V> cache(Function<K, V> loader, String cacheSpec) {
        return CacheBuilder.from((CacheBuilderSpec)CacheBuilderSpec.parse((String)cacheSpec)).build(CacheLoader.from(loader));
    }

    private static Function<String, Optional<String>> resolveVm() {
        return new Function<String, Optional<String>>(){

            @Nullable
            public Optional<String> apply(String requestIp) {
                VmInstance findVm = null;
                if (!Databases.isVolatile().booleanValue()) {
                    try {
                        findVm = VmInstances.lookupByPublicIp(requestIp);
                    }
                    catch (Exception ex2) {
                        try {
                            findVm = VmInstances.lookupByPrivateIp(requestIp);
                        }
                        catch (Exception ex) {
                            Logs.exhaust().error((Object)ex);
                        }
                    }
                }
                return Optional.fromNullable(findVm).transform(CloudMetadatas.toDisplayName());
            }
        };
    }

    public byte[] handle(String path) {
        String[] parts = path.split(":");
        try {
            String requestIpOrInstanceId = (String)ResourceIdentifiers.tryNormalize().apply((Object)parts[0]);
            boolean isInstanceId = requestIpOrInstanceId.startsWith("i-");
            MetadataRequest request = new MetadataRequest(isInstanceId ? "127.0.0.1" : requestIpOrInstanceId, parts.length == 2 ? parts[1] : "/", (Optional<String>)(isInstanceId ? Optional.of((Object)requestIpOrInstanceId) : (Optional)ipToVmIdCache.get((Object)requestIpOrInstanceId)));
            if (instanceMetadataEndpoints.containsKey(request.getMetadataName()) && request.isInstance()) {
                if (isInstanceId && !((Set)networkingFeatureSupplier.get()).contains(NetworkingFeature.Vpc) || !isInstanceId && !((Set)networkingFeatureSupplier.get()).contains(NetworkingFeature.Classic)) {
                    throw new NoSuchElementException("Metadata request failed (invalid for platform): " + path);
                }
                return ((ByteArray)((Function)instanceMetadataEndpoints.get(request.getMetadataName())).apply((Object)request)).getBytes();
            }
            if (systemMetadataEndpoints.containsKey(request.getMetadataName()) && request.isSystem()) {
                return ((ByteArray)((Function)systemMetadataEndpoints.get(request.getMetadataName())).apply((Object)request)).getBytes();
            }
            if (publicMetadataEndpoints.containsKey(request.getMetadataName())) {
                return ((ByteArray)((Function)publicMetadataEndpoints.get(request.getMetadataName())).apply((Object)request)).getBytes();
            }
            throw new NoSuchElementException("Metadata request failed: " + path);
        }
        catch (NoSuchElementException ex) {
            throw ex;
        }
        catch (Exception ex) {
            NoSuchElementException noSuchElementException = (NoSuchElementException)Exceptions.findCause((Throwable)ex, NoSuchElementException.class);
            if (noSuchElementException != null) {
                throw noSuchElementException;
            }
            String errorMsg = "Metadata request failed: " + path + (Logs.isExtrrreeeme() ? " cause: " + ex.getMessage() : "");
            LOG.error((Object)errorMsg, (Throwable)ex);
            throw Exceptions.toUndeclared((Throwable)ex);
        }
    }
}

