/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.compute.metadata;

import com.eucalyptus.bootstrap.Bootstrap;
import com.eucalyptus.component.annotation.ComponentPart;
import com.eucalyptus.component.id.Eucalyptus;
import com.eucalyptus.context.Contexts;
import com.eucalyptus.context.ServiceContext;
import com.eucalyptus.http.MappingHttpRequest;
import com.eucalyptus.records.Logs;
import com.eucalyptus.ws.server.FilteredPipeline;
import com.google.common.base.Charsets;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableSet;
import java.net.InetSocketAddress;
import java.util.Set;
import org.apache.log4j.Logger;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.ChannelEvent;
import org.jboss.netty.channel.ChannelFutureListener;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelUpstreamHandler;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.handler.codec.http.DefaultHttpResponse;
import org.jboss.netty.handler.codec.http.HttpRequest;
import org.jboss.netty.handler.codec.http.HttpResponseStatus;
import org.mule.transport.NullPayload;

@ComponentPart(value=Eucalyptus.class)
public class MetadataPipeline
extends FilteredPipeline
implements ChannelUpstreamHandler {
    private static final String ERROR_STRING = "<?xml version=\"1.0\" encoding=\"iso-8859-1\"?>\n<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\"\n         \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\">\n<html xmlns=\"http://www.w3.org/1999/xhtml\" xml:lang=\"en\" lang=\"en\">\n <head>\n  <title>404 - Not Found</title>\n </head>\n <body>\n  <h1>404 - Not Found</h1>\n </body>\n</html>\n";
    private static final Set<String> VERSION = ImmutableSet.of((Object)"1.0", (Object)"2007-01-19", (Object)"2007-03-01", (Object)"2007-08-29", (Object)"2007-10-10", (Object)"2007-12-15", (Object[])new String[]{"2008-02-01", "2008-09-01", "2009-04-04", "2011-01-01", "2011-05-01", "2012-01-12", "2014-02-25", "latest"});
    private static final String INSTANCE_ID_HEADER = "Euca-Instance-Id";
    private static Logger LOG = Logger.getLogger(MetadataPipeline.class);

    public boolean checkAccepts(HttpRequest message) {
        return message.getUri().matches("/latest(/.*)*|/\\d\\d\\d\\d-\\d\\d-\\d\\d/.*|/1.0/.*") || "/".equals(message.getUri()) && "169.254.169.254".equals(message.getHeader("Host"));
    }

    public String getName() {
        return "metadata-pipeline";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleUpstream(ChannelHandlerContext ctx, ChannelEvent e) throws Exception {
        if (e instanceof MessageEvent && ((MessageEvent)e).getMessage() instanceof MappingHttpRequest) {
            MappingHttpRequest request = (MappingHttpRequest)((MessageEvent)e).getMessage();
            String uri = request.getUri();
            InetSocketAddress remoteAddr = (InetSocketAddress)ctx.getChannel().getRemoteAddress();
            String remoteHostOrInstanceId = remoteAddr.getAddress().getHostAddress();
            if ("127.0.0.1".equals(remoteHostOrInstanceId) && request.containsHeader(INSTANCE_ID_HEADER) && request.getHeader(INSTANCE_ID_HEADER).matches("i-[0-9a-fA-F]{8}")) {
                remoteHostOrInstanceId = request.getHeader(INSTANCE_ID_HEADER);
            }
            String newUri = uri.startsWith("/latest/") ? uri.replaceAll("/latest[/]+", remoteHostOrInstanceId + ":") : (uri.startsWith("/1.0/") ? uri.replaceAll("/1.0[/]+", remoteHostOrInstanceId + ":") : uri.replaceAll("/\\d\\d\\d\\d-\\d\\d-\\d\\d[/]+", remoteHostOrInstanceId + ":"));
            LOG.trace((Object)("Trying to get metadata: " + newUri));
            Object reply = "".getBytes();
            Exception replyEx = null;
            if (uri.equals("/") || uri.isEmpty()) {
                reply = Joiner.on((char)'\n').join(VERSION).getBytes(Charsets.UTF_8);
            } else {
                try {
                    reply = Bootstrap.isShuttingDown().booleanValue() ? "System shutting down".getBytes() : (!Bootstrap.isFinished().booleanValue() ? "System is still starting up".getBytes() : (Object)ServiceContext.send((String)"VmMetadata", (Object)newUri));
                }
                catch (Exception e1) {
                    Logs.extreme().debug((Object)e1, (Throwable)e1);
                    replyEx = e1;
                }
                finally {
                    Contexts.clear((String)request.getCorrelationId());
                }
            }
            Logs.extreme().debug((Object)("VmMetadata reply info: " + reply + " " + replyEx));
            DefaultHttpResponse response = null;
            if (replyEx != null || reply == null || reply instanceof NullPayload) {
                response = new DefaultHttpResponse(request.getProtocolVersion(), HttpResponseStatus.NOT_FOUND);
                response.setHeader("Content-Type", (Object)"text/plain");
                ChannelBuffer buffer = ChannelBuffers.wrappedBuffer((byte[])ERROR_STRING.getBytes());
                response.setContent(buffer);
                response.addHeader("Content-Length", (Object)Integer.toString(buffer.readableBytes()));
            } else {
                response = new DefaultHttpResponse(request.getProtocolVersion(), HttpResponseStatus.OK);
                response.setHeader("Content-Type", (Object)"text/plain");
                ChannelBuffer buffer = ChannelBuffers.wrappedBuffer((byte[])reply);
                response.setContent(buffer);
                response.addHeader("Content-Length", (Object)Integer.toString(buffer.readableBytes()));
            }
            response.addHeader("Connection", (Object)"close");
            ctx.getChannel().write((Object)response).addListener(ChannelFutureListener.CLOSE);
        } else {
            ctx.sendUpstream(e);
        }
    }

    public ChannelPipeline addHandlers(ChannelPipeline pipeline) {
        pipeline.addLast("instance-metadata", (ChannelHandler)this);
        return pipeline;
    }
}

