/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.compute.metadata;

import com.eucalyptus.bootstrap.Bootstrap;
import com.eucalyptus.component.id.Eucalyptus;
import com.eucalyptus.configurable.ConfigurableClass;
import com.eucalyptus.configurable.ConfigurableField;
import com.eucalyptus.util.Subnets;
import com.eucalyptus.util.dns.DnsResolvers;
import com.eucalyptus.util.dns.DomainNameRecords;
import com.eucalyptus.util.dns.DomainNames;
import com.eucalyptus.vm.dns.InstanceDomainNames;
import java.net.InetAddress;
import org.xbill.DNS.Name;
import org.xbill.DNS.Record;

@ConfigurableClass(root="dns.instancedata", description="Options controlling DNS name resolution for the instance metadata service.")
public class InstanceDataDnsResolver
implements DnsResolvers.DnsResolver {
    @ConfigurableField(description="Enable the instance-data resolver.  Note: dns.enable must also be 'true'")
    public static Boolean enabled = Boolean.TRUE;
    private static final Name INSTANCE_DATA = Name.fromConstantString((String)"instance-data.");
    private static final Name RELATIVE_INSTANCE_DATA = INSTANCE_DATA.relativize(Name.fromConstantString((String)"."));
    private static final Name INSTANCE_PTR = Name.fromConstantString((String)"254.169.254.169.in-addr.arpa.");
    private static final InetAddress METADATA_ADDR = DomainNameRecords.inAddrArpaToInetAddress((Name)INSTANCE_PTR);
    private static final Record PTR_RECORD = DomainNameRecords.ptrRecord((Name)INSTANCE_DATA, (InetAddress)METADATA_ADDR);
    private static final Record ADDRESS_RECORD = DomainNameRecords.addressRecord((Name)INSTANCE_DATA, (InetAddress)METADATA_ADDR);

    public boolean checkAccepts(DnsResolvers.DnsRequest request) {
        Record query = request.getQuery();
        InetAddress source = request.getRemoteAddress();
        Name name = query.getName();
        if (!(Bootstrap.isOperational().booleanValue() && enabled.booleanValue() && Subnets.isSystemManagedAddress((InetAddress)source))) {
            return false;
        }
        if (DnsResolvers.RequestType.A.apply(query)) {
            if (INSTANCE_DATA.equals((Object)name)) {
                return true;
            }
            if (name.subdomain(DomainNames.internalSubdomain()) && RELATIVE_INSTANCE_DATA.equals((Object)DomainNames.relativize((Name)name, (Name)DomainNames.internalSubdomain()))) {
                return true;
            }
            if (name.subdomain(DomainNames.internalSubdomain(Eucalyptus.class)) && RELATIVE_INSTANCE_DATA.equals((Object)DomainNames.relativize((Name)name, (Name)DomainNames.internalSubdomain(Eucalyptus.class)))) {
                return true;
            }
            if (InstanceDomainNames.isInstanceSubdomain(name) && RELATIVE_INSTANCE_DATA.equals((Object)DomainNames.relativize((Name)name, (Name)InstanceDomainNames.lookupInstanceDomain(name)))) {
                return true;
            }
        } else if (DnsResolvers.RequestType.PTR.apply(query)) {
            return name.equals((Object)INSTANCE_PTR);
        }
        return false;
    }

    public DnsResolvers.DnsResponse lookupRecords(DnsResolvers.DnsRequest request) {
        Record query = request.getQuery();
        Name name = query.getName();
        if (DnsResolvers.RequestType.A.apply(query)) {
            String label0 = name.getLabelString(0);
            if (INSTANCE_DATA.getLabelString(0).equals(label0)) {
                return DnsResolvers.DnsResponse.forName((Name)name).answer(new Record[]{ADDRESS_RECORD});
            }
        } else if (DnsResolvers.RequestType.PTR.apply(query) && INSTANCE_PTR.equals((Object)query.getName())) {
            return DnsResolvers.DnsResponse.forName((Name)name).answer(new Record[]{PTR_RECORD});
        }
        return null;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

