/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.compute.identifier;

import com.eucalyptus.compute.identifier.DispatchingResourceIdentifierCanonicalizer;
import com.eucalyptus.compute.identifier.InvalidResourceIdentifier;
import com.eucalyptus.compute.identifier.LowerResourceIdentifierCanonicalizer;
import com.eucalyptus.compute.identifier.ResourceIdentifier;
import com.eucalyptus.compute.identifier.ResourceIdentifierCanonicalizer;
import com.eucalyptus.configurable.ConfigurableClass;
import com.eucalyptus.configurable.ConfigurableField;
import com.eucalyptus.configurable.ConfigurableProperty;
import com.eucalyptus.configurable.ConfigurablePropertyException;
import com.eucalyptus.configurable.PropertyChangeListener;
import com.eucalyptus.crypto.Crypto;
import com.google.common.base.CharMatcher;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Optional;
import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@ConfigurableClass(root="cloud", description="Properties for compute.")
public class ResourceIdentifiers {
    private static final ConcurrentMap<String, ResourceIdentifierCanonicalizer> canonicalizers = Maps.newConcurrentMap();
    private static final Pattern resourcePattern = Pattern.compile("[0-9a-fA-F]{8}");
    private static final AtomicReference<ResourceIdentifierCanonicalizer> defaultCanonicalizer = new AtomicReference<LowerResourceIdentifierCanonicalizer>(new LowerResourceIdentifierCanonicalizer());
    @ConfigurableField(description="Name of the canonicalizer for resource identifiers.", initial="lower", displayName="identifier_canonicalizer", changeListener=ResourceIdentifierCanonicalizerChangeListener.class)
    public static volatile String IDENTIFIER_CANONICALIZER = "lower";

    static void register(ResourceIdentifierCanonicalizer canonicalizer) {
        canonicalizers.put(canonicalizer.getName().toLowerCase(), canonicalizer);
    }

    public static Optional<ResourceIdentifierCanonicalizer> getCanonicalizer(String name) {
        return Optional.fromNullable(canonicalizers.get(name.toLowerCase()));
    }

    public static ResourceIdentifier generate(String prefix) {
        return ResourceIdentifiers.parse(Crypto.generateId((String)prefix));
    }

    public static String generateString(String prefix) {
        return ResourceIdentifiers.generate(prefix).getIdentifier();
    }

    public static ResourceIdentifier parse(String expectedPrefix, String identifierText) throws InvalidResourceIdentifier {
        return ResourceIdentifiers.doParse(expectedPrefix, identifierText);
    }

    public static ResourceIdentifier parse(String identifierText) throws InvalidResourceIdentifier {
        return ResourceIdentifiers.doParse(null, identifierText);
    }

    public static List<String> normalize(String expectedPrefix, Iterable<String> identifiers) throws InvalidResourceIdentifier {
        return Lists.newArrayList((Iterable)Iterables.transform(identifiers, ResourceIdentifiers.normalize(expectedPrefix)));
    }

    public static List<String> normalize(Iterable<String> identifiers) throws InvalidResourceIdentifier {
        return Lists.newArrayList((Iterable)Iterables.transform(identifiers, ResourceIdentifiers.normalize()));
    }

    public static Function<String, String> normalize() throws InvalidResourceIdentifier {
        return ResourceIdentifierNormalizeTransform.ENFORCE;
    }

    public static Function<String, String> tryNormalize() throws InvalidResourceIdentifier {
        return ResourceIdentifierNormalizeTransform.ATTEMPT;
    }

    public static Function<String, String> normalize(final String expectedPrefix) {
        return new Function<String, String>(){

            public String apply(String identifier) {
                return ResourceIdentifiers.parse(expectedPrefix, identifier).getIdentifier();
            }
        };
    }

    private static ResourceIdentifier doParse(@Nullable String expectedPrefix, @Nonnull String identifierText) throws InvalidResourceIdentifier {
        if (identifierText == null) {
            throw new InvalidResourceIdentifier(identifierText);
        }
        if (expectedPrefix != null && !identifierText.startsWith(expectedPrefix + '-')) {
            throw new InvalidResourceIdentifier(identifierText);
        }
        int hexOffset = identifierText.lastIndexOf(45) + 1;
        if (hexOffset < 2) {
            throw new InvalidResourceIdentifier(identifierText);
        }
        if (!resourcePattern.matcher(identifierText.substring(hexOffset)).matches()) {
            throw new InvalidResourceIdentifier(identifierText);
        }
        ResourceIdentifierCanonicalizer canonicalizer = defaultCanonicalizer.get();
        return new ResourceIdentifier(canonicalizer.canonicalizePrefix(identifierText.substring(0, hexOffset - 1)) + "-" + canonicalizer.canonicalizeHex(identifierText.substring(hexOffset)));
    }

    static enum ResourceIdentifierCanonicalizerToName implements Function<ResourceIdentifierCanonicalizer, String>
    {
        INSTANCE;


        @Nullable
        public String apply(@Nullable ResourceIdentifierCanonicalizer canonicalizer) {
            return canonicalizer == null ? null : canonicalizer.getName();
        }
    }

    public static final class ResourceIdentifierCanonicalizerChangeListener
    implements PropertyChangeListener<String> {
        public void fireChange(ConfigurableProperty t, String newValue) throws ConfigurablePropertyException {
            Splitter propertySplitter = Splitter.on((CharMatcher)CharMatcher.anyOf((CharSequence)" ,|;")).omitEmptyStrings().trimResults();
            Iterable canonicalizerValues = propertySplitter.split((CharSequence)newValue);
            for (String canonicalizer : canonicalizerValues) {
                if (canonicalizers.containsKey(canonicalizer)) continue;
                throw new ConfigurablePropertyException("Unknown resource identifier canonicalizer: " + canonicalizer + " in " + newValue);
            }
            defaultCanonicalizer.set(new DispatchingResourceIdentifierCanonicalizer(Iterables.transform((Iterable)canonicalizerValues, (Function)Functions.forMap((Map)canonicalizers))));
        }
    }

    private static enum ResourceIdentifierNormalizeTransform implements Function<String, String>
    {
        ATTEMPT{

            @Override
            @Nonnull
            public String apply(String identifier) {
                try {
                    return ENFORCE.apply(identifier);
                }
                catch (InvalidResourceIdentifier e) {
                    return identifier;
                }
            }
        }
        ,
        ENFORCE{

            @Override
            @Nonnull
            public String apply(String identifier) {
                return ResourceIdentifiers.parse(identifier).getIdentifier();
            }
        };


        @Nonnull
        public abstract String apply(String var1);
    }
}

