/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.compute.identifier;

import com.eucalyptus.compute.identifier.ResourceIdentifierCanonicalizer;
import com.eucalyptus.compute.identifier.ResourceIdentifiers;
import com.eucalyptus.util.CollectionUtils;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.Iterables;
import javax.annotation.Nullable;

class DispatchingResourceIdentifierCanonicalizer
implements ResourceIdentifierCanonicalizer {
    private final Iterable<ResourceIdentifierCanonicalizer> canonicalizers;

    DispatchingResourceIdentifierCanonicalizer(Iterable<ResourceIdentifierCanonicalizer> canonicalizers) {
        this.canonicalizers = canonicalizers;
    }

    @Override
    public String getName() {
        return Joiner.on((String)",").join(Iterables.transform(this.canonicalizers, (Function)ResourceIdentifiers.ResourceIdentifierCanonicalizerToName.INSTANCE));
    }

    @Override
    public String canonicalizePrefix(String prefix) {
        return (String)CollectionUtils.reduce(this.canonicalizers, (Object)prefix, (Function)new Function<String, Function<ResourceIdentifierCanonicalizer, String>>(){

            @Nullable
            public Function<ResourceIdentifierCanonicalizer, String> apply(final String value) {
                return new Function<ResourceIdentifierCanonicalizer, String>(){

                    @Nullable
                    public String apply(ResourceIdentifierCanonicalizer canonicalizer) {
                        return canonicalizer.canonicalizePrefix(value);
                    }
                };
            }
        });
    }

    @Override
    public String canonicalizeHex(String hex) {
        return (String)CollectionUtils.reduce(this.canonicalizers, (Object)hex, (Function)new Function<String, Function<ResourceIdentifierCanonicalizer, String>>(){

            @Nullable
            public Function<ResourceIdentifierCanonicalizer, String> apply(final String value) {
                return new Function<ResourceIdentifierCanonicalizer, String>(){

                    @Nullable
                    public String apply(ResourceIdentifierCanonicalizer canonicalizer) {
                        return canonicalizer.canonicalizeHex(value);
                    }
                };
            }
        });
    }
}

