/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.cluster.callback;

import com.eucalyptus.entities.Entities;
import com.eucalyptus.util.Exceptions;
import com.eucalyptus.util.async.ConnectionException;
import com.eucalyptus.util.async.FailedRequestException;
import com.eucalyptus.util.async.MessageCallback;
import com.eucalyptus.vm.VmInstance;
import com.eucalyptus.vm.VmInstances;
import com.eucalyptus.vm.VmVolumeAttachment;
import com.google.common.base.Function;
import edu.ucsb.eucalyptus.msgs.BaseMessage;
import edu.ucsb.eucalyptus.msgs.ClusterDetachVolumeResponseType;
import edu.ucsb.eucalyptus.msgs.ClusterDetachVolumeType;
import org.apache.log4j.Logger;

public class VolumeDetachCallback
extends MessageCallback<ClusterDetachVolumeType, ClusterDetachVolumeResponseType> {
    private static Logger LOG = Logger.getLogger(VolumeDetachCallback.class);

    public VolumeDetachCallback(ClusterDetachVolumeType request) {
        super((BaseMessage)request);
        Function<String, VmInstance> removeVolAttachment = new Function<String, VmInstance>(){

            public VmInstance apply(String input) {
                String volumeId = ((ClusterDetachVolumeType)VolumeDetachCallback.this.getRequest()).getVolumeId();
                VmInstance vm = VmInstances.lookup(input);
                VmVolumeAttachment volumeAttachment = vm.lookupVolumeAttachment(volumeId);
                if (!VmVolumeAttachment.AttachmentState.attached.equals((Object)volumeAttachment.getAttachmentState())) {
                    if (VmVolumeAttachment.AttachmentState.detaching.equals((Object)volumeAttachment.getAttachmentState())) {
                        throw Exceptions.toUndeclared((String)("Failed to detach volume which is already detaching: " + volumeId), (Throwable[])new Throwable[0]);
                    }
                    if (VmVolumeAttachment.AttachmentState.attaching.equals((Object)volumeAttachment.getAttachmentState())) {
                        throw Exceptions.toUndeclared((String)("Failed to detach volume which is currently attaching: " + volumeId), (Throwable[])new Throwable[0]);
                    }
                    throw Exceptions.toUndeclared((String)("Failed to detach volume which is not currently attached: " + volumeId), (Throwable[])new Throwable[0]);
                }
                vm.updateVolumeAttachment(volumeId, VmVolumeAttachment.AttachmentState.detaching);
                return vm;
            }
        };
        Entities.asTransaction(VmInstance.class, (Function)removeVolAttachment).apply((Object)((ClusterDetachVolumeType)this.getRequest()).getInstanceId());
    }

    public void fire(ClusterDetachVolumeResponseType reply) {
    }

    public void fireException(Throwable e) {
        if (e instanceof FailedRequestException) {
            LOG.debug((Object)("Request failed: " + ((ClusterDetachVolumeType)this.getRequest()).toSimpleString() + " because of: " + e.getMessage()));
        } else if (e instanceof ConnectionException) {
            LOG.error((Object)e, e);
        }
        LOG.trace((Object)((ClusterDetachVolumeType)this.getRequest()).toString("eucalyptus_ucsb_edu"));
        Function<String, VmInstance> failedVolDetach = new Function<String, VmInstance>(){

            public VmInstance apply(String input) {
                VmInstance vm = VmInstances.lookup(input);
                vm.updateVolumeAttachment(((ClusterDetachVolumeType)VolumeDetachCallback.this.getRequest()).getVolumeId(), VmVolumeAttachment.AttachmentState.attached);
                return vm;
            }
        };
        Entities.asTransaction(VmInstance.class, (Function)failedVolDetach).apply((Object)((ClusterDetachVolumeType)this.getRequest()).getInstanceId());
    }
}

