/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.cluster.callback;

import com.eucalyptus.blockstorage.Storage;
import com.eucalyptus.blockstorage.msgs.DetachStorageVolumeType;
import com.eucalyptus.component.Partition;
import com.eucalyptus.component.ServiceConfiguration;
import com.eucalyptus.component.Topology;
import com.eucalyptus.entities.Entities;
import com.eucalyptus.records.Logs;
import com.eucalyptus.util.async.AsyncRequests;
import com.eucalyptus.util.async.MessageCallback;
import com.eucalyptus.vm.VmInstance;
import com.eucalyptus.vm.VmInstances;
import com.eucalyptus.vm.VmVolumeAttachment;
import com.google.common.base.Function;
import edu.ucsb.eucalyptus.msgs.BaseMessage;
import edu.ucsb.eucalyptus.msgs.ClusterAttachVolumeResponseType;
import edu.ucsb.eucalyptus.msgs.ClusterAttachVolumeType;
import java.util.NoSuchElementException;
import org.apache.log4j.Logger;

public class VolumeAttachCallback
extends MessageCallback<ClusterAttachVolumeType, ClusterAttachVolumeResponseType> {
    private static Logger LOG = Logger.getLogger(VolumeAttachCallback.class);

    public VolumeAttachCallback(ClusterAttachVolumeType request) {
        super((BaseMessage)request);
    }

    public void initialize(ClusterAttachVolumeType msg) {
        final String instanceId = ((ClusterAttachVolumeType)this.getRequest()).getInstanceId();
        final String volumeId = ((ClusterAttachVolumeType)this.getRequest()).getVolumeId();
        Function<String, VmInstance> funcName = new Function<String, VmInstance>(){

            public VmInstance apply(String input) {
                VmInstance vm = VmInstances.lookup(instanceId);
                try {
                    if (!VmVolumeAttachment.AttachmentState.attached.equals((Object)vm.lookupVolumeAttachment(volumeId).getAttachmentState())) {
                        vm.updateVolumeAttachment(volumeId, VmVolumeAttachment.AttachmentState.attaching);
                    }
                }
                catch (Exception ex) {
                    vm.updateVolumeAttachment(volumeId, VmVolumeAttachment.AttachmentState.attaching);
                }
                return vm;
            }
        };
        try {
            Entities.asTransaction(VmInstance.class, (Function)funcName).apply((Object)((ClusterAttachVolumeType)this.getRequest()).getInstanceId());
        }
        catch (NoSuchElementException e1) {
            LOG.error((Object)("Failed to lookup volume attachment state in order to update: " + ((ClusterAttachVolumeType)this.getRequest()).getVolumeId() + " due to " + e1.getMessage()), (Throwable)e1);
        }
    }

    public void fire(ClusterAttachVolumeResponseType reply) {
    }

    public void fireException(Throwable e) {
        LOG.debug((Object)e);
        Logs.extreme().error((Object)e, e);
        LOG.debug((Object)("Trying to remove invalid volume attachment " + ((ClusterAttachVolumeType)this.getRequest()).getVolumeId() + " from instance " + ((ClusterAttachVolumeType)this.getRequest()).getInstanceId()));
        try {
            VmInstance vm = VmInstances.lookup(((ClusterAttachVolumeType)this.getRequest()).getInstanceId());
            Partition partition = vm.lookupPartition();
            ServiceConfiguration sc = Topology.lookup(Storage.class, (Partition[])new Partition[]{partition});
            try {
                LOG.debug((Object)("Sending detach after async failure in attach volume: " + ((ClusterAttachVolumeType)this.getRequest()).getVolumeId() + " sc=" + sc));
                AsyncRequests.sendSync((ServiceConfiguration)sc, (BaseMessage)new DetachStorageVolumeType(((ClusterAttachVolumeType)this.getRequest()).getVolumeId()));
            }
            catch (Exception ex) {
                LOG.error((Object)ex);
                Logs.extreme().error((Object)ex, (Throwable)ex);
            }
            Function<String, VmInstance> removeVolAttachment = new Function<String, VmInstance>(){

                public VmInstance apply(String input) {
                    VmInstance vm = VmInstances.lookup(input);
                    vm.removeVolumeAttachment(((ClusterAttachVolumeType)VolumeAttachCallback.this.getRequest()).getVolumeId());
                    return vm;
                }
            };
            Entities.asTransaction(VmInstance.class, (Function)removeVolAttachment).apply((Object)((ClusterAttachVolumeType)this.getRequest()).getInstanceId());
            LOG.debug((Object)("Removed failed attachment: " + ((ClusterAttachVolumeType)this.getRequest()).getVolumeId() + " -> " + vm.getInstanceId()));
        }
        catch (Exception e1) {
            LOG.error((Object)e1);
            Logs.extreme().error((Object)e1, (Throwable)e1);
        }
    }
}

