/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.cluster.callback;

import com.eucalyptus.bootstrap.Databases;
import com.eucalyptus.cluster.Cluster;
import com.eucalyptus.cluster.callback.StateUpdateMessageCallback;
import com.eucalyptus.compute.common.CloudMetadatas;
import com.eucalyptus.compute.common.network.InstanceResourceReportType;
import com.eucalyptus.compute.common.network.Networking;
import com.eucalyptus.compute.common.network.UpdateInstanceResourcesType;
import com.eucalyptus.entities.Entities;
import com.eucalyptus.entities.TransactionException;
import com.eucalyptus.records.Logs;
import com.eucalyptus.util.TypeMapper;
import com.eucalyptus.util.TypeMappers;
import com.eucalyptus.util.async.FailedRequestException;
import com.eucalyptus.util.async.SubjectMessageCallback;
import com.eucalyptus.vm.VmBundleTask;
import com.eucalyptus.vm.VmInstance;
import com.eucalyptus.vm.VmInstances;
import com.eucalyptus.vm.VmRuntimeState;
import com.eucalyptus.vmtypes.VmType;
import com.eucalyptus.vmtypes.VmTypes;
import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.Collections2;
import com.google.common.collect.Sets;
import edu.ucsb.eucalyptus.cloud.VmDescribeResponseType;
import edu.ucsb.eucalyptus.cloud.VmDescribeType;
import edu.ucsb.eucalyptus.cloud.VmInfo;
import edu.ucsb.eucalyptus.msgs.BaseMessage;
import edu.ucsb.eucalyptus.msgs.VmTypeInfo;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.CancellationException;
import javax.annotation.Nullable;
import javax.persistence.EntityTransaction;
import org.apache.log4j.Logger;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;

public class VmStateCallback
extends StateUpdateMessageCallback<Cluster, VmDescribeType, VmDescribeResponseType> {
    private static Logger LOG = Logger.getLogger(VmStateCallback.class);
    private final Supplier<Set<String>> initialInstances = VmStateCallback.createInstanceSupplier(this, (Predicate<VmInstance>)Predicates.and(VmInstance.VmState.STOPPED.not(), VmStateCallback.partitionFilter(this)));

    public VmStateCallback() {
        super(new VmDescribeType(){
            {
                this.regarding();
            }
        });
    }

    private static Supplier<Set<String>> createInstanceSupplier(StateUpdateMessageCallback<Cluster, ?, ?> cb, final Predicate<VmInstance> filter) {
        return Suppliers.memoize((Supplier)new Supplier<Set<String>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Set<String> get() {
                EntityTransaction db = Entities.get(VmInstance.class);
                try {
                    List<VmInstance> clusterInstances = VmInstances.list(null, (Criterion)Restrictions.conjunction(), Collections.emptyMap(), (Predicate<? super VmInstance>)filter);
                    Collection instanceNames = Collections2.transform(clusterInstances, (Function)CloudMetadatas.toDisplayName());
                    HashSet hashSet = Sets.newHashSet((Iterable)instanceNames);
                    return hashSet;
                }
                catch (Exception ex) {
                    Logs.extreme().error((Object)ex, (Throwable)ex);
                    HashSet hashSet = Sets.newHashSet();
                    return hashSet;
                }
                finally {
                    db.rollback();
                }
            }
        });
    }

    @Override
    public void fireException(FailedRequestException t) {
        LOG.debug((Object)("Request to " + ((Cluster)this.getSubject()).getName() + " failed: " + t.getMessage()));
    }

    public void fire(VmDescribeResponseType reply) {
        UpdateInstanceResourcesType update = new UpdateInstanceResourcesType();
        update.setPartition(((Cluster)this.getSubject()).getPartition());
        update.setResources((InstanceResourceReportType)TypeMappers.transform((Object)reply, InstanceResourceReportType.class));
        Networking.getInstance().update(update);
        if (Databases.isVolatile().booleanValue()) {
            return;
        }
        reply.setOriginCluster(((Cluster)this.getSubject()).getConfiguration().getName());
        HashSet reportedInstances = Sets.newHashSet();
        for (VmInfo vmInfo : reply.getVms()) {
            reportedInstances.add(vmInfo.getInstanceId());
            vmInfo.setPlacement(((Cluster)this.getSubject()).getConfiguration().getName());
            VmTypeInfo typeInfo = vmInfo.getInstanceType();
            if (typeInfo.getName() != null && !"".equals(typeInfo.getName())) continue;
            for (VmType t : VmTypes.list()) {
                if (!t.getCpu().equals(typeInfo.getCores()) || !t.getDisk().equals(typeInfo.getDisk()) || !t.getMemory().equals(typeInfo.getMemory())) continue;
                typeInfo.setName(t.getName());
            }
        }
        HashSet unreportedInstances = Sets.newHashSet((Iterable)Sets.difference((Set)((Set)this.initialInstances.get()), (Set)reportedInstances));
        HashSet unknownInstances = Sets.newHashSet((Iterable)Sets.difference((Set)reportedInstances, (Set)((Set)this.initialInstances.get())));
        for (VmInfo runVm : reply.getVms()) {
            if (Databases.isVolatile().booleanValue()) {
                return;
            }
            if (((Set)this.initialInstances.get()).contains(runVm.getInstanceId())) {
                VmStateCallback.handleReportedState(runVm);
                continue;
            }
            if (!unknownInstances.contains(runVm.getInstanceId())) continue;
            VmStateCallback.handleUnknown(runVm);
        }
        for (String vmId : unreportedInstances) {
            if (Databases.isVolatile().booleanValue()) {
                return;
            }
            VmStateCallback.handleUnreported(vmId);
        }
    }

    private static void handleUnreported(String vmId) {
        try {
            VmInstance vm = VmInstances.lookupAny(vmId);
            if (VmInstance.VmState.PENDING.apply(vm) && vm.lastUpdateMillis() < (long)(VmInstances.VM_INITIAL_REPORT_TIMEOUT * 1000)) {
                return;
            }
            if (vm.isBlockStorage() && VmInstances.Timeout.UNREPORTED.apply(vm)) {
                VmInstances.stopped(vm);
            } else if (VmInstance.VmState.STOPPING.apply(vm)) {
                VmInstances.stopped(vm);
            } else if (VmInstance.VmState.SHUTTING_DOWN.apply(vm)) {
                VmInstances.terminated(vm);
            } else if (VmInstances.Timeout.TERMINATED.apply(vm)) {
                VmInstances.buried(vm);
            } else if (VmInstances.Timeout.BURIED.apply(vm)) {
                VmInstances.delete(vm);
            } else if (VmInstances.Timeout.SHUTTING_DOWN.apply(vm)) {
                VmInstances.terminated(vm);
            } else if (VmInstances.Timeout.STOPPING.apply(vm)) {
                VmInstances.stopped(vm);
            } else if (VmInstances.Timeout.UNREPORTED.apply(vm)) {
                VmInstances.terminated(vm);
            } else if (VmInstance.VmStateSet.RUN.apply(vm) && VmRuntimeState.InstanceStatus.Ok.apply(vm)) {
                VmInstances.unreachable(vm);
            }
        }
        catch (Exception ex) {
            LOG.error((Object)ex);
            Logs.extreme().error((Object)ex, (Throwable)ex);
        }
    }

    private static void handleReportedState(VmInfo runVm) {
        VmInstance.VmState runVmState = VmInstance.VmState.Mapper.get(runVm.getStateName());
        try {
            EntityTransaction db = Entities.get(VmInstance.class);
            try {
                VmInstance vm = VmInstances.lookupAny(runVm.getInstanceId());
                if (VmInstance.VmStateSet.DONE.apply(vm)) {
                    db.rollback();
                    if (VmInstance.Reason.EXPIRED.apply(vm)) {
                        VmStateCallback.handleUnknown(runVm);
                    } else {
                        LOG.trace((Object)("Ignore state update to terminated instance: " + runVm.getInstanceId()));
                    }
                    return;
                }
                if (VmInstances.Timeout.EXPIRED.apply(vm)) {
                    if (vm.isBlockStorage()) {
                        VmInstances.stopped(vm);
                    } else {
                        VmInstances.shutDown(vm);
                    }
                } else {
                    if (VmInstance.VmState.SHUTTING_DOWN.equals((Object)runVmState)) {
                        db.rollback();
                        VmStateCallback.handleReportedTeardown(vm, runVm);
                        return;
                    }
                    if (VmInstance.VmStateSet.RUN.apply(vm)) {
                        vm.doUpdate().apply((Object)runVm);
                    } else if (!VmInstance.VmStateSet.RUN.apply(vm) && VmInstance.VmStateSet.RUN.contains(runVmState) && vm.lastUpdateMillis() > VmInstances.VOLATILE_STATE_TIMEOUT_SEC * 1000L) {
                        vm.doUpdate().apply((Object)runVm);
                    } else {
                        return;
                    }
                }
                Entities.commit((EntityTransaction)db);
            }
            catch (Exception ex) {
                LOG.error((Object)ex);
                Logs.extreme().error((Object)ex, (Throwable)ex);
                throw ex;
            }
            finally {
                if (db.isActive()) {
                    db.rollback();
                }
            }
        }
        catch (VmInstances.TerminatedInstanceException ex1) {
            LOG.trace((Object)("Ignore state update to terminated instance: " + runVm.getInstanceId()));
        }
        catch (NoSuchElementException ex1) {
        }
        catch (Exception ex1) {
            LOG.error((Object)ex1);
            Logs.extreme().error((Object)ex1, (Throwable)ex1);
        }
    }

    private static void handleUnknown(VmInfo runVm) {
        Optional<VmInstance.RestoreHandler> restoreHandler;
        Iterator<Optional<VmInstance.RestoreHandler>> i$ = VmInstance.RestoreHandler.parseList(VmInstances.UNKNOWN_INSTANCE_HANDLERS).iterator();
        while (!(!i$.hasNext() || (restoreHandler = i$.next()).isPresent() && VmStateCallback.handleRestore(runVm, (Predicate<VmInfo>)((Predicate)restoreHandler.get())))) {
        }
    }

    private static boolean handleRestore(VmInfo runVm, Predicate<VmInfo> restorer) {
        VmInstance.VmState runVmState = VmInstance.VmState.Mapper.get(runVm.getStateName());
        if (VmInstance.VmStateSet.RUN.contains(runVmState)) {
            try {
                VmInstance vm = VmInstances.lookupAny(runVm.getInstanceId());
                if (!VmInstance.VmStateSet.DONE.apply(vm) || !VmInstance.Reason.EXPIRED.apply(vm)) {
                    return false;
                }
            }
            catch (NoSuchElementException ex) {
                LOG.debug((Object)("Instance record not found for restore: " + runVm.getInstanceId()));
                Logs.extreme().error((Object)ex, (Throwable)ex);
            }
            catch (Exception ex) {
                LOG.error((Object)ex);
                Logs.extreme().error((Object)ex, (Throwable)ex);
            }
            try {
                LOG.debug((Object)("Instance " + runVm.getInstanceId() + " " + runVm));
                return restorer.apply((Object)runVm);
            }
            catch (Throwable ex) {
                LOG.error((Object)ex);
                Logs.extreme().error((Object)ex, ex);
            }
        }
        return false;
    }

    private static void handleReportedTeardown(VmInstance vm, VmInfo runVm) throws TransactionException {
        VmBundleTask.BundleState bundleState = (VmBundleTask.BundleState)((Object)VmBundleTask.BundleState.mapper.apply((Object)runVm.getBundleTaskStateName()));
        if (!VmBundleTask.BundleState.none.equals((Object)bundleState)) {
            vm.getRuntimeState().updateBundleTaskState(bundleState, 0.0);
            VmInstances.terminated(vm);
        } else if (VmInstance.VmState.SHUTTING_DOWN.apply(vm)) {
            VmInstances.terminated(vm);
        } else if (VmInstance.VmState.STOPPING.apply(vm)) {
            VmInstances.stopped(vm);
        } else if (VmInstance.VmStateSet.RUN.apply(vm) && vm.getSplitTime() > (long)(VmInstances.VM_STATE_SETTLE_TIME * 1000)) {
            if (vm.isBlockStorage()) {
                VmInstances.stopped(vm);
            } else {
                VmInstances.shutDown(vm);
            }
        }
    }

    private static Predicate<VmInstance> stateSettleFilter() {
        return new Predicate<VmInstance>(){

            public boolean apply(VmInstance input) {
                return input.getCreationSplitTime() > (long)(VmInstances.VM_STATE_SETTLE_TIME * 1000);
            }
        };
    }

    private static Predicate<VmInstance> partitionFilter(final SubjectMessageCallback<Cluster, ?, ?> cb) {
        return new Predicate<VmInstance>(){

            public boolean apply(VmInstance arg0) {
                return arg0.getPartition().equals(((Cluster)cb.getSubject()).getConfiguration().getPartition());
            }
        };
    }

    public void setSubject(Cluster subject) {
        super.setSubject((Object)subject);
        this.initialInstances.get();
    }

    static /* synthetic */ Predicate access$000() {
        return VmStateCallback.stateSettleFilter();
    }

    static /* synthetic */ Predicate access$100(SubjectMessageCallback x0) {
        return VmStateCallback.partitionFilter(x0);
    }

    static /* synthetic */ Supplier access$200(StateUpdateMessageCallback x0, Predicate x1) {
        return VmStateCallback.createInstanceSupplier(x0, (Predicate<VmInstance>)x1);
    }

    @TypeMapper
    public static enum VmDescribeResponseTypeToInstanceResourceReport implements Function<VmDescribeResponseType, InstanceResourceReportType>
    {
        INSTANCE;


        @Nullable
        public InstanceResourceReportType apply(VmDescribeResponseType response) {
            InstanceResourceReportType report = new InstanceResourceReportType();
            for (VmInfo vmInfo : response.getVms()) {
                if ("Teardown".equals(vmInfo.getStateName()) || vmInfo.getNetParams() == null) continue;
                report.getPublicIps().add(vmInfo.getNetParams().getIgnoredPublicIp());
                report.getPrivateIps().add(vmInfo.getNetParams().getIpAddress());
                report.getMacs().add(vmInfo.getNetParams().getMacAddress());
            }
            return report;
        }
    }

    public static class VmPendingCallback
    extends StateUpdateMessageCallback<Cluster, VmDescribeType, VmDescribeResponseType> {
        private final Predicate<VmInstance> filter = Predicates.and((Predicate[])new Predicate[]{VmInstance.VmStateSet.TORNDOWN.not(), VmStateCallback.access$000(), VmStateCallback.access$100(this)});
        private final Supplier<Set<String>> initialInstances = VmStateCallback.access$200(this, this.filter);

        public VmPendingCallback(Cluster cluster) {
            super(cluster);
            this.setRequest((BaseMessage)new VmDescribeType(){
                {
                    this.regarding();
                    this.getInstancesSet().addAll((Collection)VmPendingCallback.this.initialInstances.get());
                }
            });
            if (((VmDescribeType)this.getRequest()).getInstancesSet().isEmpty()) {
                throw new CancellationException();
            }
        }

        public void fire(VmDescribeResponseType reply) {
            for (VmInfo runVm : reply.getVms()) {
                if (Databases.isVolatile().booleanValue()) {
                    return;
                }
                if (!((Set)this.initialInstances.get()).contains(runVm.getInstanceId())) continue;
                VmStateCallback.handleReportedState(runVm);
            }
        }

        @Override
        public void fireException(FailedRequestException t) {
            LOG.debug((Object)("Request to " + ((Cluster)this.getSubject()).getName() + " failed: " + t.getMessage()));
        }
    }
}

