/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.cluster.callback;

import com.eucalyptus.address.Address;
import com.eucalyptus.address.Addresses;
import com.eucalyptus.address.AddressingDispatcher;
import com.eucalyptus.cloud.ResourceToken;
import com.eucalyptus.cloud.VmInstanceLifecycleHelpers;
import com.eucalyptus.cloud.VmRunType;
import com.eucalyptus.cluster.ResourceState;
import com.eucalyptus.compute.common.backend.RunInstancesType;
import com.eucalyptus.compute.common.network.PublicIPResource;
import com.eucalyptus.entities.Entities;
import com.eucalyptus.network.EdgeNetworking;
import com.eucalyptus.records.Logs;
import com.eucalyptus.system.tracking.MessageContexts;
import com.eucalyptus.util.Callback;
import com.eucalyptus.util.EucalyptusClusterException;
import com.eucalyptus.util.Exceptions;
import com.eucalyptus.util.LogUtil;
import com.eucalyptus.util.async.AsyncRequests;
import com.eucalyptus.util.async.MessageCallback;
import com.eucalyptus.vm.VmInstance;
import com.eucalyptus.vm.VmInstances;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import edu.ucsb.eucalyptus.cloud.VmInfo;
import edu.ucsb.eucalyptus.cloud.VmRunResponseType;
import edu.ucsb.eucalyptus.msgs.BaseMessage;
import java.util.Iterator;
import javax.persistence.EntityTransaction;
import org.apache.log4j.Logger;

public class VmRunCallback
extends MessageCallback<VmRunType, VmRunResponseType> {
    private static Logger LOG = Logger.getLogger(VmRunCallback.class);
    private final ResourceToken token;

    public VmRunCallback(VmRunType msg, ResourceToken token) {
        super((BaseMessage)msg);
        this.token = token;
        LOG.debug((Object)this.token);
    }

    public void initialize(VmRunType msg) {
        LOG.debug((Object)(this.token + ":" + (Object)((Object)msg)));
        EntityTransaction db = Entities.get(VmInstance.class);
        try {
            VmInstance vm = VmInstances.lookupAny(msg.getInstanceId());
            msg.setUserId(vm.getOwnerUserId());
            msg.setOwnerId(vm.getOwnerUserId());
            msg.setAccountId(vm.getOwnerAccountNumber());
            if (!VmInstance.VmState.PENDING.apply(vm)) {
                throw new EucalyptusClusterException("Intercepted a RunInstances request for an instance with unexpected state: " + vm.getState());
            }
            db.rollback();
        }
        catch (Exception e) {
            if (!Exceptions.isCausedBy((Throwable)e, EucalyptusClusterException.class)) {
                LOG.error((Object)e);
            }
            Logs.extreme().error((Object)e, (Throwable)e);
            db.rollback();
            try {
                this.token.abort();
            }
            catch (Exception ex) {
                LOG.error((Object)ex);
                Logs.extreme().error((Object)ex, (Throwable)ex);
            }
            throw new EucalyptusClusterException("Error while initializing request state: " + this.getRequest(), (Throwable)e);
        }
        finally {
            if (db.isActive()) {
                db.rollback();
            }
        }
        try {
            this.token.submit();
        }
        catch (ResourceState.NoSuchTokenException e2) {
            LOG.error((Object)e2);
            Logs.extreme().error((Object)e2, (Throwable)e2);
        }
    }

    public void fire(VmRunResponseType reply) {
        Logs.extreme().error((Object)reply);
        try {
            this.token.redeem();
        }
        catch (Exception ex) {
            LOG.error((Object)(this.token + ": " + ex));
            Logs.extreme().error((Object)(this.token + ": " + ex), (Throwable)ex);
        }
        Function<VmInfo, Boolean> updateInstance = new Function<VmInfo, Boolean>(){

            public Boolean apply(VmInfo input) {
                final VmInstance vm = VmInstances.lookup(input.getInstanceId());
                if (!EdgeNetworking.isEnabled()) {
                    vm.updateAddresses(input.getNetParams().getIpAddress(), input.getNetParams().getIgnoredPublicIp());
                }
                try {
                    vm.updateMacAddress(input.getNetParams().getMacAddress());
                    vm.setServiceTag(input.getServiceTag());
                }
                catch (Exception ex) {
                    LOG.error((Object)(VmRunCallback.this.token + ": " + ex));
                    Logs.extreme().error((Object)(VmRunCallback.this.token + ": " + ex), (Throwable)ex);
                }
                final Address addr = VmRunCallback.this.getAddress();
                if (addr != null && !addr.isReallyAssigned()) {
                    BaseMessage runInstanceReq = MessageContexts.lookup((String)input.getInstanceId(), RunInstancesType.class);
                    AddressingDispatcher.dispatch(AsyncRequests.newRequest(addr.assign(vm).getCallback(runInstanceReq)).then((Callback.Success)new Callback.Success<BaseMessage>(){

                        public void fire(BaseMessage response) {
                            Addresses.updatePublicIpByInstanceId(vm.getInstanceId(), addr.getName());
                        }
                    }), vm.getPartition());
                }
                return true;
            }
        };
        Iterator i$ = reply.getVms().iterator();
        if (i$.hasNext()) {
            VmInfo vmInfo = (VmInfo)i$.next();
            if (this.token.getInstanceId().equals(vmInfo.getInstanceId())) {
                try {
                    Entities.asTransaction(VmInstance.class, (Function)updateInstance, (int)10).apply((Object)vmInfo);
                }
                catch (RuntimeException ex) {
                    LOG.error((Object)("Failed: " + this.token + " because of " + ex.getMessage()), (Throwable)ex);
                    throw ex;
                }
            } else {
                throw new EucalyptusClusterException("ccRunInstancesResponse: does not contain requested instance information for: " + this.token.getInstanceId() + " but return status is " + reply.get_return() + "\nccRunInstancesResponse:vms=" + reply.getVms());
            }
        }
    }

    public void fireException(Throwable e) {
        LOG.debug((Object)LogUtil.header((String)("Failing run instances because of: " + e.getMessage())), e);
        LOG.debug((Object)LogUtil.subheader((String)((VmRunType)this.getRequest()).toString()));
        Predicate<Throwable> rollbackToken = new Predicate<Throwable>(){

            public boolean apply(Throwable input) {
                LOG.debug((Object)"-> Release resource tokens for unused resources.");
                try {
                    VmRunCallback.this.token.abort();
                }
                catch (Exception ex) {
                    LOG.error((Object)ex.getMessage());
                    Logs.extreme().error((Object)ex, (Throwable)ex);
                }
                return true;
            }
        };
        try {
            Entities.asTransaction(VmInstance.class, (Function)Functions.forPredicate((Predicate)rollbackToken)).apply((Object)e);
        }
        catch (Exception ex) {
            Logs.extreme().error((Object)ex, (Throwable)ex);
        }
    }

    private Address getAddress() {
        PublicIPResource publicIPResource = (PublicIPResource)Iterables.find((Iterable)this.token.getAttribute(VmInstanceLifecycleHelpers.NetworkResourceVmInstanceLifecycleHelper.NetworkResourcesKey), (Predicate)Predicates.instanceOf(PublicIPResource.class), null);
        return publicIPResource != null && publicIPResource.getValue() != null ? (Address)Addresses.getInstance().lookup(publicIPResource.getValue()) : null;
    }

    public String toString() {
        return "VmRunCallback " + this.token;
    }
}

