/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.cluster.callback;

import com.eucalyptus.address.Address;
import com.eucalyptus.address.Addresses;
import com.eucalyptus.records.EventRecord;
import com.eucalyptus.records.EventType;
import com.eucalyptus.records.Logs;
import com.eucalyptus.util.Expendable;
import com.eucalyptus.util.LogUtil;
import com.eucalyptus.util.async.MessageCallback;
import com.eucalyptus.vm.VmInstances;
import com.eucalyptus.vm.VmNetworkConfig;
import edu.ucsb.eucalyptus.msgs.BaseMessage;
import edu.ucsb.eucalyptus.msgs.ClusterAddressInfo;
import edu.ucsb.eucalyptus.msgs.UnassignAddressResponseType;
import edu.ucsb.eucalyptus.msgs.UnassignAddressType;
import java.util.NoSuchElementException;
import java.util.concurrent.CancellationException;
import org.apache.log4j.Logger;

public class UnassignAddressCallback
extends MessageCallback<UnassignAddressType, UnassignAddressResponseType>
implements Expendable<UnassignAddressCallback> {
    private static Logger LOG = Logger.getLogger(UnassignAddressCallback.class);
    private Address address;
    private final boolean system;

    public UnassignAddressCallback(String addr, String vmIp) {
        super((BaseMessage)new UnassignAddressType((Object)addr, (Object)vmIp));
        try {
            this.address = (Address)Addresses.getInstance().lookup(addr);
        }
        catch (Exception e) {
            try {
                this.address = (Address)Addresses.getInstance().lookupDisabled(addr);
            }
            catch (Exception ex) {
                LOG.error((Object)("Failed to prepare unassign for: " + addr + "=>" + vmIp));
                Logs.extreme().error((Object)("Failed to prepare unassign for: " + addr + "=>" + vmIp), (Throwable)e);
                Logs.extreme().error((Object)("Failed to prepare unassign for: " + addr + "=>" + vmIp), (Throwable)ex);
                throw new CancellationException(ex.getMessage());
            }
        }
        this.system = this.address.isSystemOwned();
    }

    public UnassignAddressCallback(String addr) {
        this(addr, ((Address)Addresses.getInstance().lookup(addr)).getInstanceAddress());
    }

    public UnassignAddressCallback(ClusterAddressInfo addrInfo) {
        this(addrInfo.getAddress(), addrInfo.getInstanceIp());
    }

    public UnassignAddressCallback(Address address) {
        this(address.getName(), address.getInstanceAddress());
    }

    public void initialize(UnassignAddressType msg) throws Exception {
        try {
            EventRecord.here(UnassignAddressCallback.class, (EventType)EventType.ADDRESS_UNASSIGNING, (String[])new String[]{Address.Transition.unassigning.toString(), this.address.toString()}).info();
        }
        catch (Exception ex) {
            LOG.error((Object)ex, (Throwable)ex);
        }
    }

    public void clearVmAddress() {
        String privateIp = ((UnassignAddressType)super.getRequest()).getDestination();
        String publicIp = ((UnassignAddressType)super.getRequest()).getSource();
        Addresses.updatePublicIPOnMatch(privateIp, publicIp, VmNetworkConfig.DEFAULT_IP);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fire(UnassignAddressResponseType reply) {
        try {
            this.address.clearPending();
            this.clearVmAddress();
        }
        catch (IllegalStateException t) {
            LOG.debug((Object)t);
        }
        catch (Exception t) {
            LOG.warn((Object)t.getMessage());
            EventRecord.here(UnassignAddressCallback.class, (EventType)EventType.ADDRESS_STATE, (String[])new String[]{"broken", this.address.toString()}).warn();
            LOG.trace((Object)t, (Throwable)t);
        }
        finally {
            if (this.system) {
                try {
                    if (!this.address.isPending() && this.address.isAssigned()) {
                        this.address.unassign().clearPending().release();
                    } else {
                        this.address.release();
                    }
                }
                catch (Exception t) {
                    LOG.warn((Object)("Failed to release orphan address: " + (Object)((Object)this.address)), (Throwable)t);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireException(Throwable e) {
        try {
            Addresses.updatePublicIP(((UnassignAddressType)super.getRequest()).getDestination(), VmNetworkConfig.DEFAULT_IP);
        }
        catch (Exception t) {
            LOG.debug((Object)t, (Throwable)t);
        }
        finally {
            if (this.address.isPending()) {
                try {
                    this.address.clearPending();
                }
                catch (Exception t) {}
            }
            if (this.system) {
                try {
                    VmInstances.lookupByPublicIp(this.address.getDisplayName());
                }
                catch (NoSuchElementException ex) {
                    this.address.release();
                }
            }
        }
        LOG.error((Object)e, e);
        LOG.warn((Object)("Address potentially in an inconsistent state: " + LogUtil.dumpObject((Object)((Object)this.address))));
    }

    public boolean duplicateOf(UnassignAddressCallback that) {
        return ((UnassignAddressType)this.getRequest()).getSource().equals(((UnassignAddressType)that.getRequest()).getSource()) && ((UnassignAddressType)this.getRequest()).getDestination().equals(((UnassignAddressType)that.getRequest()).getDestination());
    }
}

