/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.cluster.callback;

import com.eucalyptus.records.EventRecord;
import com.eucalyptus.records.EventType;
import com.eucalyptus.util.Expendable;
import com.eucalyptus.util.LogUtil;
import com.eucalyptus.util.async.MessageCallback;
import edu.ucsb.eucalyptus.msgs.BaseMessage;
import edu.ucsb.eucalyptus.msgs.ClusterTerminateInstancesResponseType;
import edu.ucsb.eucalyptus.msgs.ClusterTerminateInstancesType;
import org.apache.log4j.Logger;

public class TerminateCallback
extends MessageCallback<ClusterTerminateInstancesType, ClusterTerminateInstancesResponseType>
implements Expendable<TerminateCallback> {
    private static Logger LOG = Logger.getLogger(TerminateCallback.class);
    private String instanceId;

    public TerminateCallback(String instanceId) {
        super((BaseMessage)new ClusterTerminateInstancesType(instanceId));
        this.instanceId = instanceId;
    }

    public void initialize(ClusterTerminateInstancesType msg) {
        EventRecord.here(ClusterTerminateInstancesType.class, (EventType)EventType.VM_TERMINATING, (String[])new String[]{LogUtil.dumpObject((Object)msg)}).info();
    }

    public void fire(ClusterTerminateInstancesResponseType reply) {
        EventRecord.here(ClusterTerminateInstancesType.class, (EventType)EventType.VM_TERMINATED, (String[])new String[]{LogUtil.dumpObject((Object)reply)}).info();
    }

    public void fireException(Throwable e) {
        LOG.debug((Object)LogUtil.subheader((String)((ClusterTerminateInstancesType)this.getRequest()).toString("eucalyptus_ucsb_edu")));
        LOG.debug((Object)e, e);
    }

    public boolean duplicateOf(TerminateCallback that) {
        return ((ClusterTerminateInstancesType)this.getRequest()).getInstancesSet().containsAll(((ClusterTerminateInstancesType)that.getRequest()).getInstancesSet());
    }
}

