/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.cluster.callback;

import com.eucalyptus.entities.Entities;
import com.eucalyptus.network.NetworkGroup;
import com.eucalyptus.records.Logs;
import com.eucalyptus.util.Expendable;
import com.eucalyptus.util.LogUtil;
import com.eucalyptus.util.async.BroadcastCallback;
import edu.ucsb.eucalyptus.msgs.BaseMessage;
import edu.ucsb.eucalyptus.msgs.StopNetworkResponseType;
import edu.ucsb.eucalyptus.msgs.StopNetworkType;
import javax.persistence.EntityTransaction;
import org.apache.log4j.Logger;

public class StopNetworkCallback
extends BroadcastCallback<StopNetworkType, StopNetworkResponseType>
implements Expendable<StopNetworkCallback> {
    private static Logger LOG = Logger.getLogger(StopNetworkCallback.class);
    private final NetworkGroup networkGroup;
    private Integer tag;

    public StopNetworkCallback(NetworkGroup networkGroup) {
        this.networkGroup = networkGroup;
        EntityTransaction db = Entities.get(NetworkGroup.class);
        try {
            NetworkGroup entity = (NetworkGroup)((Object)Entities.merge((Object)((Object)this.networkGroup)));
            this.tag = this.networkGroup.extantNetwork().getTag();
            db.commit();
        }
        catch (Exception ex) {
            Logs.exhaust().error((Object)ex, (Throwable)ex);
            db.rollback();
            this.tag = -1;
        }
        StopNetworkType msg = (StopNetworkType)new StopNetworkType(this.networkGroup.getOwnerAccountNumber(), this.networkGroup.getOwnerUserId(), this.networkGroup.getNaturalId(), this.tag).regarding();
        msg.setUserId(this.networkGroup.getOwnerUserId());
        msg.setAccountId(this.networkGroup.getOwnerAccountNumber());
        this.setRequest((BaseMessage)msg);
    }

    public void fire(StopNetworkResponseType msg) {
    }

    public void initialize(StopNetworkType msg) throws Exception {
    }

    public BroadcastCallback<StopNetworkType, StopNetworkResponseType> newInstance() {
        return new StopNetworkCallback(this.networkGroup);
    }

    public void fireException(Throwable e) {
        LOG.debug((Object)("Request failed: " + LogUtil.subheader((String)((StopNetworkType)this.getRequest()).toString("eucalyptus_ucsb_edu"))));
        Logs.extreme().error((Object)e, e);
    }

    public boolean duplicateOf(StopNetworkCallback that) {
        return ((StopNetworkType)this.getRequest()).getNetName().equals(((StopNetworkType)that.getRequest()).getNetName());
    }
}

