/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.cluster.callback;

import com.eucalyptus.cluster.Cluster;
import com.eucalyptus.event.ClockTick;
import com.eucalyptus.event.Event;
import com.eucalyptus.event.EventListener;
import com.eucalyptus.records.EventRecord;
import com.eucalyptus.records.EventType;
import com.eucalyptus.util.async.MessageCallback;
import com.eucalyptus.util.async.RemoteCallback;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.log4j.Logger;

public class StateUpdateHandler
implements EventListener {
    private static Logger LOG = Logger.getLogger(StateUpdateHandler.class);
    private static final ConcurrentMap<String, StateUpdateHandler> clusterMap = Maps.newConcurrentMap();
    private final ConcurrentMap<Class, AtomicBoolean> inflightMap = Maps.newConcurrentMap();
    private final ConcurrentMap<Class, MessageCallback> callbackMap = Maps.newConcurrentMap();
    private final Cluster cluster;

    public static void create(Cluster cluster, RemoteCallback callback) {
        StateUpdateHandler handler = new StateUpdateHandler(cluster);
        clusterMap.putIfAbsent(cluster.getName(), handler);
        handler = (StateUpdateHandler)clusterMap.get(cluster.getName());
        EventRecord.here(StateUpdateHandler.class, (EventType)EventType.CLUSTER_STATE_HANDLER_REGISTERED, (String[])new String[]{cluster.getName(), callback.getClass().getCanonicalName()});
    }

    private StateUpdateHandler(Cluster cluster) {
        this.cluster = cluster;
    }

    public boolean timedTrigger(Event c) {
        if (c instanceof ClockTick) {
            return ((ClockTick)c).isBackEdge();
        }
        return false;
    }

    public void addCallback(MessageCallback cb) {
        if (this.callbackMap.putIfAbsent(cb.getClass(), cb) == null) {
            this.inflightMap.put(cb.getClass(), new AtomicBoolean(false));
        } else {
            LOG.debug((Object)("Ignoring addition of timed callback for cluster " + this.cluster.getName() + " which is already configured: " + cb.getClass()));
        }
    }

    public void fireEvent(Event event) {
        if (this.timedTrigger(event)) {
            Iterables.all(this.callbackMap.keySet(), (Predicate)new Predicate<Class>(){

                public boolean apply(Class arg0) {
                    if (((AtomicBoolean)StateUpdateHandler.this.inflightMap.get(arg0)).compareAndSet(false, true)) {
                        // empty if block
                    }
                    return false;
                }
            });
        }
    }
}

