/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.cluster.callback;

import com.eucalyptus.cluster.Clusters;
import com.eucalyptus.entities.Entities;
import com.eucalyptus.network.ExtantNetwork;
import com.eucalyptus.network.NetworkGroup;
import com.eucalyptus.util.LogUtil;
import com.eucalyptus.util.async.BroadcastCallback;
import com.eucalyptus.vm.VmInstances;
import com.google.common.collect.Lists;
import edu.ucsb.eucalyptus.cloud.entities.SystemConfiguration;
import edu.ucsb.eucalyptus.msgs.BaseMessage;
import edu.ucsb.eucalyptus.msgs.StartNetworkResponseType;
import edu.ucsb.eucalyptus.msgs.StartNetworkType;
import javax.persistence.EntityTransaction;
import org.apache.log4j.Logger;

public class StartNetworkCallback
extends BroadcastCallback<StartNetworkType, StartNetworkResponseType> {
    private static Logger LOG = Logger.getLogger(StartNetworkCallback.class);
    private ExtantNetwork extantNet;

    public StartNetworkCallback(ExtantNetwork extantNet) {
        this.extantNet = extantNet;
        StartNetworkType msg = new StartNetworkType(extantNet.getOwnerAccountNumber(), extantNet.getOwnerUserId(), extantNet.getTag(), extantNet.getNetworkGroup().getNaturalId(), extantNet.getNetworkGroup().getNaturalId());
        msg.setUserId(this.extantNet.getOwnerUserId());
        msg.setAccountId(this.extantNet.getOwnerAccountNumber());
        this.setRequest((BaseMessage)msg);
    }

    public void fire(StartNetworkResponseType msg) {
        EntityTransaction db = Entities.get(ExtantNetwork.class);
        try {
            this.extantNet = (ExtantNetwork)((Object)Entities.merge((Object)((Object)this.extantNet)));
            NetworkGroup net = this.extantNet.getNetworkGroup();
            net.setState(NetworkGroup.State.ACTIVE);
            Entities.merge((Object)((Object)net));
            db.commit();
        }
        catch (Exception ex) {
            LOG.error((Object)ex, (Throwable)ex);
            db.rollback();
        }
    }

    public void initialize(StartNetworkType msg) {
        try {
            msg.setVmsubdomain(VmInstances.INSTANCE_SUBDOMAIN.substring(1));
            msg.setNameserver(SystemConfiguration.getSystemConfiguration().getNameserverAddress());
            msg.setClusterControllers(Lists.newArrayList(Clusters.getInstance().getClusterAddresses()));
        }
        catch (Exception e) {
            LOG.debug((Object)e, (Throwable)e);
        }
    }

    public void fireException(Throwable e) {
        LOG.debug((Object)LogUtil.subheader((String)((StartNetworkType)this.getRequest()).toString("eucalyptus_ucsb_edu")));
        LOG.debug((Object)e, e);
    }

    public BroadcastCallback<StartNetworkType, StartNetworkResponseType> newInstance() {
        return new StartNetworkCallback(this.extantNet);
    }

    public String toString() {
        return "StartNetworkCallback " + (Object)((Object)this.extantNet);
    }
}

