/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.cluster.callback;

import com.eucalyptus.cluster.Cluster;
import com.eucalyptus.cluster.callback.StateUpdateMessageCallback;
import com.eucalyptus.component.ServiceConfiguration;
import com.eucalyptus.node.NodeController;
import com.eucalyptus.node.Nodes;
import com.eucalyptus.system.Threads;
import com.eucalyptus.util.async.FailedRequestException;
import com.eucalyptus.vmtypes.VmType;
import com.eucalyptus.vmtypes.VmTypes;
import com.google.common.base.Joiner;
import edu.ucsb.eucalyptus.msgs.DescribeResourcesResponseType;
import edu.ucsb.eucalyptus.msgs.DescribeResourcesType;
import edu.ucsb.eucalyptus.msgs.VmTypeInfo;
import java.util.concurrent.Callable;
import org.apache.log4j.Logger;

public class ResourceStateCallback
extends StateUpdateMessageCallback<Cluster, DescribeResourcesType, DescribeResourcesResponseType> {
    private static Logger LOG = Logger.getLogger(ResourceStateCallback.class);

    public ResourceStateCallback() {
        super(new DescribeResourcesType(){
            {
                this.regarding();
                for (VmType arg0 : VmTypes.list()) {
                    this.getInstanceTypes().add(new VmTypeInfo(arg0.getName(), arg0.getMemory(), arg0.getDisk(), arg0.getCpu(), "sda1"){
                        {
                            this.setSwap("sda2", 0x20000000L);
                        }
                    });
                }
            }
        });
    }

    public void fire(final DescribeResourcesResponseType reply) {
        final Cluster cluster = (Cluster)this.getSubject();
        cluster.getNodeState().update(reply.getResources());
        LOG.debug((Object)("Adding node service tags: " + Joiner.on((String)", ").join((Iterable)reply.getNodes())));
        Callable<Boolean> updateNodes = new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                try {
                    Nodes.updateNodeInfo((ServiceConfiguration)cluster.getConfiguration(), reply.getNodes());
                    return true;
                }
                catch (Exception e) {
                    LOG.error((Object)e, (Throwable)e);
                    LOG.trace((Object)e, (Throwable)e);
                    return false;
                }
            }
        };
        Threads.enqueue(NodeController.class, ResourceStateCallback.class, (Callable)updateNodes);
    }

    @Override
    public void fireException(FailedRequestException t) {
        LOG.debug((Object)("Request to " + ((Cluster)this.getSubject()).getName() + " failed: " + t.getMessage()));
    }
}

