/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.cluster.callback;

import com.eucalyptus.address.Addresses;
import com.eucalyptus.cluster.Cluster;
import com.eucalyptus.util.async.FailedRequestException;
import com.eucalyptus.util.async.SubjectMessageCallback;
import edu.ucsb.eucalyptus.msgs.BaseMessage;
import edu.ucsb.eucalyptus.msgs.DescribePublicAddressesResponseType;
import edu.ucsb.eucalyptus.msgs.DescribePublicAddressesType;
import org.apache.log4j.Logger;

public class PublicAddressStateCallback
extends SubjectMessageCallback<Cluster, DescribePublicAddressesType, DescribePublicAddressesResponseType> {
    private static Logger LOG = Logger.getLogger(PublicAddressStateCallback.class);

    public PublicAddressStateCallback() {
        super((BaseMessage)((DescribePublicAddressesType)new DescribePublicAddressesType().regarding()));
    }

    public void fire(DescribePublicAddressesResponseType reply) {
        ((Cluster)this.getSubject()).getState().setPublicAddressing(true);
        try {
            Addresses.getAddressManager().update((Cluster)this.getSubject(), reply.getAddresses());
        }
        catch (Exception ex) {
            LOG.error((Object)ex);
        }
    }

    public void fireException(Throwable t) {
        if (t instanceof FailedRequestException) {
            LOG.warn((Object)("Response from cluster [" + ((Cluster)this.getSubject()).getName() + "]: " + t.getMessage()));
        } else {
            LOG.warn((Object)("[" + ((Cluster)this.getSubject()).getName() + "]: " + t.getMessage()));
        }
        if (t instanceof FailedRequestException) {
            ((Cluster)this.getSubject()).getState().setPublicAddressing(false);
        } else {
            LOG.error((Object)t, t);
        }
    }
}

