/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.cluster.callback;

import com.eucalyptus.cluster.Cluster;
import com.eucalyptus.cluster.Clusters;
import com.eucalyptus.cluster.callback.StateUpdateMessageCallback;
import com.eucalyptus.compute.common.network.NetworkReportType;
import com.eucalyptus.compute.common.network.NetworkResourceReportType;
import com.eucalyptus.compute.common.network.Networking;
import com.eucalyptus.compute.common.network.UpdateNetworkResourcesType;
import com.eucalyptus.network.EdgeNetworking;
import com.eucalyptus.util.TypeMapper;
import com.eucalyptus.util.TypeMappers;
import com.eucalyptus.util.async.FailedRequestException;
import com.eucalyptus.vm.VmInstances;
import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import edu.ucsb.eucalyptus.cloud.entities.SystemConfiguration;
import edu.ucsb.eucalyptus.msgs.DescribeNetworksResponseType;
import edu.ucsb.eucalyptus.msgs.DescribeNetworksType;
import edu.ucsb.eucalyptus.msgs.NetworkInfoType;
import javax.annotation.Nullable;
import org.apache.log4j.Logger;

public class NetworkStateCallback
extends StateUpdateMessageCallback<Cluster, DescribeNetworksType, DescribeNetworksResponseType> {
    private static Logger LOG = Logger.getLogger(NetworkStateCallback.class);

    public NetworkStateCallback() {
        super(new DescribeNetworksType(){
            {
                this.regarding();
                this.setClusterControllers(Lists.newArrayList(Clusters.getInstance().getClusterAddresses()));
                this.setVmsubdomain(VmInstances.INSTANCE_SUBDOMAIN.substring(1));
                this.setNameserver(SystemConfiguration.getSystemConfiguration().getNameserverAddress());
                this.setDnsDomainName(SystemConfiguration.getSystemConfiguration().getDnsDomain().replaceAll("^\\.", ""));
            }
        });
    }

    public void fire(DescribeNetworksResponseType reply) {
        EdgeNetworking.setReported("EDGE".equals(reply.getMode()));
        UpdateNetworkResourcesType update = new UpdateNetworkResourcesType();
        update.setCluster(((Cluster)this.getSubject()).getName());
        update.setResources((NetworkResourceReportType)TypeMappers.transform((Object)reply, NetworkResourceReportType.class));
        Networking.getInstance().update(update);
    }

    @Override
    public void fireException(FailedRequestException t) {
        LOG.debug((Object)("Request to " + ((Cluster)this.getSubject()).getName() + " failed: " + t.getMessage()));
    }

    @TypeMapper
    public static enum NetworkInfoTypeToNetworkReportType implements Function<NetworkInfoType, NetworkReportType>
    {
        INSTANCE;


        @Nullable
        public NetworkReportType apply(NetworkInfoType networkInfo) {
            NetworkReportType report = new NetworkReportType();
            report.setUuid(networkInfo.getUuid());
            report.setTag(networkInfo.getTag());
            report.setNetworkName(networkInfo.getNetworkName());
            report.setAccountNumber(networkInfo.getAccountNumber());
            report.setAllocatedIndexes(networkInfo.getAllocatedIndexes());
            return report;
        }
    }

    @TypeMapper
    public static enum DescribeNetworksResponseTypeToNetworkResourceReport implements Function<DescribeNetworksResponseType, NetworkResourceReportType>
    {
        INSTANCE;


        @Nullable
        public NetworkResourceReportType apply(DescribeNetworksResponseType response) {
            NetworkResourceReportType report = new NetworkResourceReportType();
            report.setUseVlans(response.getUseVlans());
            report.setMode(response.getMode());
            report.setAddrsPerNet(response.getAddrsPerNet());
            report.setAddrIndexMin(response.getAddrIndexMin());
            report.setAddrIndexMax(response.getAddrIndexMax());
            report.setVlanMin(response.getVlanMin());
            report.setVlanMax(response.getVlanMax());
            report.setVnetSubnet(response.getVnetSubnet());
            report.setVnetNetmask(response.getVnetNetmask());
            report.setPrivateIps(response.getPrivateIps());
            report.setActiveNetworks(Lists.newArrayList((Iterable)Iterables.transform((Iterable)response.getActiveNetworks(), (Function)TypeMappers.lookup(NetworkInfoType.class, NetworkReportType.class))));
            return report;
        }
    }
}

