/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.cluster.callback;

import com.eucalyptus.cluster.Cluster;
import com.eucalyptus.util.EucalyptusClusterException;
import com.eucalyptus.util.async.SubjectMessageCallback;
import edu.ucsb.eucalyptus.cloud.NodeInfo;
import edu.ucsb.eucalyptus.msgs.BaseMessage;
import edu.ucsb.eucalyptus.msgs.GetLogsResponseType;
import edu.ucsb.eucalyptus.msgs.GetLogsType;
import org.apache.log4j.Logger;
import org.bouncycastle.util.encoders.Base64;

public class LogDataCallback
extends SubjectMessageCallback<Cluster, GetLogsType, GetLogsResponseType> {
    private static Logger LOG = Logger.getLogger(LogDataCallback.class);
    private final NodeInfo node;
    private boolean self = false;

    public LogDataCallback(Cluster cluster) {
        super((Object)cluster, (BaseMessage)new GetLogsType((Object)"self"));
        this.node = null;
    }

    public LogDataCallback(Cluster cluster, NodeInfo node) {
        super((Object)cluster, (BaseMessage)new GetLogsType((Object)node.getServiceTag()));
        this.node = node;
    }

    public void initialize(GetLogsType msg) {
    }

    public void fireException(Throwable t) {
        LOG.error((Object)t, t);
    }

    public void fire(GetLogsResponseType msg) {
        if (msg == null || msg.getLogs() == null) {
            EucalyptusClusterException error = new EucalyptusClusterException("Failed to get log data from cluster.");
            LOG.error((Object)error, (Throwable)error);
        } else {
            String log = "";
            if (this.self) {
                ((Cluster)this.getSubject()).setLastLog(msg.getLogs());
                try {
                    log = new String(Base64.decode((String)msg.getLogs().getCcLog())).replaceFirst(".*\b", "").substring(0, 1000);
                }
                catch (Exception e) {
                    LOG.debug((Object)e, (Throwable)e);
                }
            } else {
                this.node.setLogs(msg.getLogs());
                try {
                    log = new String(Base64.decode((String)msg.getLogs().getNcLog())).replaceFirst(".*\b", "").substring(0, 1000);
                }
                catch (Exception e) {
                    LOG.debug((Object)e, (Throwable)e);
                }
            }
            LOG.debug((Object)("LOG: " + log));
        }
    }
}

