/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.cluster.callback;

import com.eucalyptus.auth.Accounts;
import com.eucalyptus.auth.AuthException;
import com.eucalyptus.cloudwatch.common.msgs.PutMetricDataType;
import com.eucalyptus.cluster.callback.CloudWatchHelper;
import com.eucalyptus.component.ServiceConfiguration;
import com.eucalyptus.event.Event;
import com.eucalyptus.event.EventFailedException;
import com.eucalyptus.event.ListenerRegistry;
import com.eucalyptus.records.Logs;
import com.eucalyptus.reporting.event.InstanceUsageEvent;
import com.eucalyptus.util.LogUtil;
import com.eucalyptus.util.async.BroadcastCallback;
import com.eucalyptus.vm.VmInstance;
import com.eucalyptus.vm.VmInstances;
import com.google.common.base.Function;
import com.google.common.base.Supplier;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import edu.ucsb.eucalyptus.msgs.BaseMessage;
import edu.ucsb.eucalyptus.msgs.DescribeSensorsResponse;
import edu.ucsb.eucalyptus.msgs.DescribeSensorsType;
import edu.ucsb.eucalyptus.msgs.MetricCounterType;
import edu.ucsb.eucalyptus.msgs.MetricDimensionsType;
import edu.ucsb.eucalyptus.msgs.MetricDimensionsValuesType;
import edu.ucsb.eucalyptus.msgs.MetricsResourceType;
import edu.ucsb.eucalyptus.msgs.SensorsResourceType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.apache.log4j.Logger;

public class DescribeSensorCallback
extends BroadcastCallback<DescribeSensorsType, DescribeSensorsResponse> {
    private static final Logger LOG = Logger.getLogger(DescribeSensorCallback.class);
    private static final String RESOURCE_TYPE_INSTANCE = "instance";
    private final int historySize;
    private final int collectionIntervalTimeMs;
    private final ArrayList<String> instanceIds;
    private final ListenerRegistry listener = ListenerRegistry.getInstance();

    public DescribeSensorCallback(int historySize, int collectionIntervalTimeMS, ArrayList<String> instanceIds) {
        this.historySize = historySize;
        this.collectionIntervalTimeMs = collectionIntervalTimeMS;
        this.instanceIds = instanceIds;
        DescribeSensorsType msg = new DescribeSensorsType(Integer.valueOf(this.historySize), Integer.valueOf(this.collectionIntervalTimeMs), this.instanceIds);
        try {
            msg.setUser(Accounts.lookupSystemAdmin());
        }
        catch (AuthException e) {
            LOG.error((Object)"Unable to find the system user", (Throwable)e);
        }
        this.setRequest((BaseMessage)msg);
    }

    public void initialize(DescribeSensorsType msg) {
    }

    public BroadcastCallback<DescribeSensorsType, DescribeSensorsResponse> newInstance() {
        return new DescribeSensorCallback(this.historySize, this.collectionIntervalTimeMs, this.instanceIds);
    }

    public void fireException(Throwable e) {
        LOG.debug((Object)("Request failed: " + LogUtil.subheader((String)((DescribeSensorsType)this.getRequest()).toString("eucalyptus_ucsb_edu"))));
        Logs.extreme().error((Object)e, e);
    }

    public void fire(DescribeSensorsResponse msg) {
        LOG.trace((Object)("DescribeSensorCallback (fire) called at " + new Date()));
        try {
            this.processCloudWatchStats(msg);
        }
        catch (Exception ex) {
            LOG.debug((Object)"Unable to fire describe sensors call back (cloudwatch)", (Throwable)ex);
        }
        try {
            this.processReportingStats(msg);
        }
        catch (Exception ex) {
            LOG.debug((Object)"Unable to fire describe sensors call back (reporting)", (Throwable)ex);
        }
    }

    private void processCloudWatchStats(DescribeSensorsResponse msg) throws Exception {
        CloudWatchHelper cloudWatchHelper = new CloudWatchHelper(new CloudWatchHelper.DefaultInstanceInfoProvider());
        List<PutMetricDataType> putMetricDataList = cloudWatchHelper.collectMetricData(msg);
        ServiceConfiguration serviceConfiguration = CloudWatchHelper.createServiceConfiguration();
        for (PutMetricDataType putMetricData : putMetricDataList) {
            cloudWatchHelper.sendSystemMetric(serviceConfiguration, putMetricData);
        }
    }

    private void processReportingStats(DescribeSensorsResponse msg) throws Exception {
        Iterable uuidList = Iterables.transform(VmInstances.list(VmInstance.VmState.RUNNING), VmInstances.toInstanceUuid());
        for (final SensorsResourceType sensorData : msg.getSensorsResources()) {
            if (!RESOURCE_TYPE_INSTANCE.equals(sensorData.getResourceType()) || !Iterables.contains((Iterable)uuidList, (Object)sensorData.getResourceUuid())) continue;
            for (final MetricsResourceType metricType : sensorData.getMetrics()) {
                for (MetricCounterType counterType : metricType.getCounters()) {
                    for (final MetricDimensionsType dimensionType : counterType.getDimensions()) {
                        ArrayList values = Lists.newArrayList((Iterable)dimensionType.getValues());
                        Collections.sort(values, Ordering.natural().onResultOf((Function)GetTimestamp.INSTANCE));
                        if (values.isEmpty()) continue;
                        MetricDimensionsValuesType latestValue = (MetricDimensionsValuesType)Iterables.getLast((Iterable)values);
                        final Double usageValue = latestValue.getValue();
                        if (usageValue == null) {
                            LOG.debug((Object)"Event received with null 'value', skipping for reporting");
                            continue;
                        }
                        final Long usageTimestamp = latestValue.getTimestamp().getTime();
                        final long sequenceNumber = dimensionType.getSequenceNum() + (long)(values.size() - 1);
                        this.fireUsageEvent(new Supplier<InstanceUsageEvent>(){

                            public InstanceUsageEvent get() {
                                return new InstanceUsageEvent(sensorData.getResourceUuid(), sensorData.getResourceName(), metricType.getMetricName(), Long.valueOf(sequenceNumber), dimensionType.getDimensionName(), usageValue, usageTimestamp);
                            }
                        });
                    }
                }
            }
        }
    }

    private void fireUsageEvent(Supplier<InstanceUsageEvent> instanceUsageEventSupplier) {
        InstanceUsageEvent event = null;
        event = (InstanceUsageEvent)instanceUsageEventSupplier.get();
        try {
            this.listener.fireEvent((Event)event);
        }
        catch (EventFailedException e) {
            LOG.debug((Object)("Failed to fire instance usage event" + (event != null ? event : "")), (Throwable)e);
        }
    }

    static enum GetTimestamp implements Function<MetricDimensionsValuesType, Date>
    {
        INSTANCE;


        public Date apply(MetricDimensionsValuesType metricDimensionsValuesType) {
            return metricDimensionsValuesType.getTimestamp();
        }
    }
}

