/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.cluster.callback;

import com.eucalyptus.auth.Accounts;
import com.eucalyptus.auth.principal.Account;
import com.eucalyptus.auth.principal.User;
import com.eucalyptus.cloudwatch.common.CloudWatch;
import com.eucalyptus.cloudwatch.common.msgs.Dimension;
import com.eucalyptus.cloudwatch.common.msgs.Dimensions;
import com.eucalyptus.cloudwatch.common.msgs.MetricData;
import com.eucalyptus.cloudwatch.common.msgs.MetricDatum;
import com.eucalyptus.cloudwatch.common.msgs.PutMetricDataResponseType;
import com.eucalyptus.cloudwatch.common.msgs.PutMetricDataType;
import com.eucalyptus.cluster.callback.DescribeSensorCallback;
import com.eucalyptus.component.Partition;
import com.eucalyptus.component.ServiceConfiguration;
import com.eucalyptus.component.Topology;
import com.eucalyptus.entities.Transactions;
import com.eucalyptus.reporting.event.InstanceUsageEvent;
import com.eucalyptus.tags.Tag;
import com.eucalyptus.util.CollectionUtils;
import com.eucalyptus.util.EucalyptusCloudException;
import com.eucalyptus.util.Pair;
import com.eucalyptus.util.async.AsyncRequests;
import com.eucalyptus.vm.VmInstance;
import com.eucalyptus.vm.VmInstanceTag;
import com.eucalyptus.vm.VmInstances;
import com.eucalyptus.vm.VmRuntimeState;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Supplier;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Ordering;
import edu.ucsb.eucalyptus.msgs.BaseMessage;
import edu.ucsb.eucalyptus.msgs.DescribeSensorsResponse;
import edu.ucsb.eucalyptus.msgs.MetricCounterType;
import edu.ucsb.eucalyptus.msgs.MetricDimensionsType;
import edu.ucsb.eucalyptus.msgs.MetricDimensionsValuesType;
import edu.ucsb.eucalyptus.msgs.MetricsResourceType;
import edu.ucsb.eucalyptus.msgs.SensorsResourceType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.log4j.Logger;

public class CloudWatchHelper {
    private InstanceInfoProvider instanceInfoProvider;
    private static final Logger LOG = Logger.getLogger(CloudWatchHelper.class);
    private static final String RESOURCE_TYPE_INSTANCE = "instance";
    private static final Set<String> EC2_DISK_METRICS = ImmutableSet.of((Object)"DiskReadOps", (Object)"DiskWriteOps", (Object)"DiskReadBytes", (Object)"DiskWriteBytes");
    private static final Set<String> UNSUPPORTED_EC2_METRICS = ImmutableSet.of((Object)"NetworkInExternal", (Object)"NetworkOutExternal", (Object)"VolumeQueueLength", (Object)"VolumeTotalReadTime", (Object)"VolumeTotalWriteTime", (Object)"VolumeTotalReadWriteTime", (Object[])new String[]{"VolumeConsumedReadWriteOps", "DiskTotalReadTime", "DiskTotalWriteTime", "DiskConsumedReadWriteOps"});
    private static final Map<String, String> ABSOLUTE_METRICS = new ImmutableMap.Builder().put((Object)"CPUUtilization", (Object)"CPUUtilizationMSAbsolute").put((Object)"VolumeReadOps", (Object)"VolumeReadOpsAbsolute").put((Object)"VolumeWriteOps", (Object)"VolumeWriteOpsAbsolute").put((Object)"VolumeConsumedReadWriteOps", (Object)"VolumeConsumedReadWriteOpsAbsolute").put((Object)"VolumeReadBytes", (Object)"VolumeReadBytesAbsolute").put((Object)"VolumeWriteBytes", (Object)"VolumeWriteBytesAbsolute").put((Object)"VolumeTotalReadTime", (Object)"VolumeTotalReadTimeAbsolute").put((Object)"VolumeTotalWriteTime", (Object)"VolumeTotalWriteTimeAbsolute").put((Object)"VolumeTotalReadWriteTime", (Object)"VolumeTotalReadWriteTimeAbsolute").put((Object)"DiskReadOps", (Object)"DiskReadOpsAbsolute").put((Object)"DiskWriteOps", (Object)"DiskWriteOpsAbsolute").put((Object)"DiskReadBytes", (Object)"DiskReadBytesAbsolute").put((Object)"DiskWriteBytes", (Object)"DiskWriteBytesAbsolute").put((Object)"NetworkIn", (Object)"NetworkInAbsolute").put((Object)"NetworkOut", (Object)"NetworkOutAbsolute").build();
    private static final Map<String, String> metricsToUnitTypes = new ImmutableMap.Builder().putAll(CloudWatchHelper.metricsToUnitType(Bytes.class)).putAll(CloudWatchHelper.metricsToUnitType(Count.class)).putAll(CloudWatchHelper.metricsToUnitType(Seconds.class)).putAll(CloudWatchHelper.metricsToUnitType(Percent.class)).build();

    public CloudWatchHelper(InstanceInfoProvider instanceInfoProvider) {
        this.instanceInfoProvider = instanceInfoProvider;
    }

    private Supplier<InstanceUsageEvent> combineReadWriteDiskMetric(String readMetricName, String writeMetricName, ConcurrentMap<String, DiskReadWriteMetricTypeCache> metricCacheMap, String combinedMetricName, MetricsResourceType metricType, SensorsResourceType sensorData, MetricDimensionsType dimensionType, MetricDimensionsValuesType thisValueType) throws Exception {
        metricCacheMap.putIfAbsent(readMetricName, new DiskReadWriteMetricTypeCache());
        metricCacheMap.putIfAbsent(writeMetricName, new DiskReadWriteMetricTypeCache());
        String matchingMetricName = null;
        String otherMetricName = null;
        if (metricType.getMetricName().equals(readMetricName)) {
            matchingMetricName = readMetricName;
            otherMetricName = writeMetricName;
        } else if (metricType.getMetricName().equals(writeMetricName)) {
            matchingMetricName = writeMetricName;
            otherMetricName = readMetricName;
        }
        if (matchingMetricName != null && otherMetricName != null) {
            ((DiskReadWriteMetricTypeCache)metricCacheMap.get(matchingMetricName)).putEventInCache(sensorData, dimensionType, thisValueType);
            MetricDimensionsValuesType otherValueType = ((DiskReadWriteMetricTypeCache)metricCacheMap.get(otherMetricName)).getEventFromCache(sensorData, dimensionType, thisValueType);
            if (otherValueType != null) {
                return this.createDiskOpsCacheSupplier(sensorData, combinedMetricName, dimensionType, thisValueType.getValue() + otherValueType.getValue(), thisValueType.getTimestamp().getTime());
            }
        }
        return null;
    }

    private Supplier<InstanceUsageEvent> createDiskOpsCacheSupplier(final SensorsResourceType sensorData, final String combinedMetricName, final MetricDimensionsType dimensionType, final Double value, final Long usageTimeStamp) {
        return new Supplier<InstanceUsageEvent>(){

            public InstanceUsageEvent get() {
                return new InstanceUsageEvent(sensorData.getResourceUuid(), sensorData.getResourceName(), combinedMetricName, dimensionType.getSequenceNum(), dimensionType.getDimensionName(), value, usageTimeStamp);
            }
        };
    }

    private static <E extends Enum<E>> Map<String, String> metricsToUnitType(Class<E> unitEnum) {
        return CollectionUtils.putAll(EnumSet.allOf(unitEnum), (Map)Maps.newHashMap(), (Function)Functions.toStringFunction(), (Function)Functions.constant((Object)unitEnum.getSimpleName()));
    }

    private String containsUnitType(String metricType) {
        String unitType = metricsToUnitTypes.get(metricType);
        if (unitType == null) {
            throw new NoSuchElementException("Unknown system unit type : " + metricType);
        }
        return unitType;
    }

    public static ServiceConfiguration createServiceConfiguration() {
        return Topology.lookup(CloudWatch.class, (Partition[])new Partition[0]);
    }

    public void sendSystemMetric(ServiceConfiguration serviceConfiguration, PutMetricDataType putMetricData) throws Exception {
        BaseMessage reply = (BaseMessage)AsyncRequests.dispatch((ServiceConfiguration)serviceConfiguration, (BaseMessage)putMetricData).get();
        if (!(reply instanceof PutMetricDataResponseType)) {
            throw new EucalyptusCloudException("Unable to send put metric data to cloud watch");
        }
    }

    public List<PutMetricDataType> collectMetricData(DescribeSensorsResponse msg) throws Exception {
        ArrayList<PutMetricDataType> putMetricDataList = new ArrayList<PutMetricDataType>();
        Iterable<String> uuidList = this.instanceInfoProvider.getRunningInstanceUUIDList();
        ConcurrentMap metricCacheMap = Maps.newConcurrentMap();
        EC2DiskMetricCache ec2DiskMetricCache = new EC2DiskMetricCache();
        for (final SensorsResourceType sensorData : msg.getSensorsResources()) {
            if (!RESOURCE_TYPE_INSTANCE.equals(sensorData.getResourceType()) || !Iterables.contains(uuidList, (Object)sensorData.getResourceUuid())) continue;
            for (final MetricsResourceType metricType : sensorData.getMetrics()) {
                for (MetricCounterType counterType : metricType.getCounters()) {
                    for (final MetricDimensionsType dimensionType : counterType.getDimensions()) {
                        ArrayList values = Lists.newArrayList(this.stripMilliseconds(dimensionType.getValues()));
                        Collections.sort(values, Ordering.natural().onResultOf((Function)DescribeSensorCallback.GetTimestamp.INSTANCE));
                        for (MetricDimensionsValuesType value : values) {
                            boolean isEbsMetric;
                            boolean isEc2DiskMetric;
                            if (LOG.isTraceEnabled()) {
                                LOG.trace((Object)("ResourceUUID: " + sensorData.getResourceUuid()));
                                LOG.trace((Object)("ResourceName: " + sensorData.getResourceName()));
                                LOG.trace((Object)("Metric: " + metricType.getMetricName()));
                                LOG.trace((Object)("Dimension: " + dimensionType.getDimensionName()));
                                LOG.trace((Object)("Timestamp: " + value.getTimestamp()));
                                LOG.trace((Object)("Value: " + value.getValue()));
                            }
                            final Long currentTimeStamp = value.getTimestamp().getTime();
                            final Double currentValue = value.getValue();
                            if (currentValue == null) {
                                LOG.debug((Object)"Event received with null 'value', skipping for cloudwatch");
                                continue;
                            }
                            boolean hasEc2DiskMetricName = EC2_DISK_METRICS.contains(metricType.getMetricName().replace("Volume", "Disk"));
                            if (hasEc2DiskMetricName) {
                                ec2DiskMetricCache.initializeMetrics(sensorData.getResourceUuid(), sensorData.getResourceName(), currentTimeStamp);
                            }
                            boolean bl = isEc2DiskMetric = !(isEbsMetric = dimensionType.getDimensionName().startsWith("vol-")) && hasEc2DiskMetricName;
                            if (isEbsMetric || !isEc2DiskMetric) {
                                this.addToPutMetricDataList(putMetricDataList, new Supplier<InstanceUsageEvent>(){

                                    public InstanceUsageEvent get() {
                                        return new InstanceUsageEvent(sensorData.getResourceUuid(), sensorData.getResourceName(), metricType.getMetricName(), dimensionType.getSequenceNum(), dimensionType.getDimensionName(), currentValue, currentTimeStamp);
                                    }
                                });
                                if (!isEbsMetric) continue;
                                this.addToPutMetricDataList(putMetricDataList, this.combineReadWriteDiskMetric("DiskReadOps", "DiskWriteOps", metricCacheMap, "DiskConsumedReadWriteOps", metricType, sensorData, dimensionType, value));
                                this.addToPutMetricDataList(putMetricDataList, this.combineReadWriteDiskMetric("VolumeReadOps", "VolumeWriteOps", metricCacheMap, "VolumeConsumedReadWriteOps", metricType, sensorData, dimensionType, value));
                                this.addToPutMetricDataList(putMetricDataList, this.combineReadWriteDiskMetric("VolumeTotalReadTime", "VolumeTotalWriteTime", metricCacheMap, "VolumeTotalReadWriteTime", metricType, sensorData, dimensionType, value));
                                continue;
                            }
                            String metricName = metricType.getMetricName().replace("Volume", "Disk");
                            ec2DiskMetricCache.addToMetric(sensorData.getResourceUuid(), sensorData.getResourceName(), metricName, currentValue, currentTimeStamp);
                        }
                    }
                }
            }
            if (!Iterables.tryFind(putMetricDataList, CloudWatchHelper.withMetric("AWS/EC2", null, "InstanceId", sensorData.getResourceName())).isPresent() || Iterables.tryFind(putMetricDataList, CloudWatchHelper.withMetric("AWS/EC2", Count.StatusCheckFailed.name(), "InstanceId", sensorData.getResourceName())).isPresent()) continue;
            putMetricDataList.add(this.buildInstanceStatusPut(sensorData.getResourceName()));
        }
        Collection<Supplier<InstanceUsageEvent>> ec2DiskMetrics = ec2DiskMetricCache.getMetrics();
        ArrayList ec2DiskMetricsSorted = Lists.newArrayList(ec2DiskMetrics);
        Collections.sort(ec2DiskMetricsSorted, Ordering.natural().onResultOf((Function)new Function<Supplier<InstanceUsageEvent>, Long>(){

            @Nullable
            public Long apply(@Nullable Supplier<InstanceUsageEvent> supplier) {
                return ((InstanceUsageEvent)supplier.get()).getValueTimestamp();
            }
        }));
        for (Supplier ec2DiskMetric : ec2DiskMetricsSorted) {
            try {
                this.addToPutMetricDataList(putMetricDataList, (Supplier<InstanceUsageEvent>)ec2DiskMetric);
            }
            catch (Exception ex) {
                LOG.debug((Object)("Unable to add system metric " + ec2DiskMetric), (Throwable)ex);
            }
        }
        return CloudWatchHelper.consolidatePutMetricDataList(putMetricDataList);
    }

    private List<MetricDimensionsValuesType> stripMilliseconds(ArrayList<MetricDimensionsValuesType> values) {
        ArrayList<MetricDimensionsValuesType> newValues = new ArrayList<MetricDimensionsValuesType>();
        for (MetricDimensionsValuesType value : values) {
            MetricDimensionsValuesType newValue = new MetricDimensionsValuesType();
            newValue.setTimestamp(value.getTimestamp() != null ? new Date(value.getTimestamp().getTime() / 1000L * 1000L) : null);
            newValue.setValue(value.getValue());
            newValues.add(newValue);
        }
        return newValues;
    }

    public static List<PutMetricDataType> consolidatePutMetricDataList(List<PutMetricDataType> putMetricDataList) {
        int MAX_PUT_METRIC_DATA_ITEMS = 20;
        LinkedHashMap metricDataMap = new LinkedHashMap();
        for (PutMetricDataType putMetricData : putMetricDataList) {
            Pair userIdAndNamespacePair = Pair.pair((Object)putMetricData.getUserId(), (Object)putMetricData.getNamespace());
            if (!metricDataMap.containsKey(userIdAndNamespacePair)) {
                metricDataMap.put(userIdAndNamespacePair, new ArrayList());
            }
            ((List)metricDataMap.get(userIdAndNamespacePair)).addAll(putMetricData.getMetricData().getMember());
        }
        ArrayList<PutMetricDataType> retVal = new ArrayList<PutMetricDataType>();
        for (Map.Entry metricDataEntry : metricDataMap.entrySet()) {
            for (List datums : Iterables.partition((Iterable)((Iterable)metricDataEntry.getValue()), (int)20)) {
                MetricData metricData = new MetricData();
                metricData.setMember(Lists.newArrayList((Iterable)datums));
                PutMetricDataType putMetricData = new PutMetricDataType();
                putMetricData.setUserId((String)((Pair)metricDataEntry.getKey()).getLeft());
                putMetricData.markPrivileged();
                putMetricData.setNamespace((String)((Pair)metricDataEntry.getKey()).getRight());
                putMetricData.setMetricData(metricData);
                retVal.add(putMetricData);
            }
        }
        return retVal;
    }

    private void addToPutMetricDataList(List<PutMetricDataType> putMetricDataList, Supplier<InstanceUsageEvent> cloudWatchSupplier) throws Exception {
        if (cloudWatchSupplier == null) {
            return;
        }
        InstanceUsageEvent event = (InstanceUsageEvent)cloudWatchSupplier.get();
        LOG.trace((Object)event);
        if (!this.instanceInfoProvider.getInstanceId(event.getInstanceId()).equals(event.getInstanceId()) || !this.instanceInfoProvider.getMonitoring(event.getInstanceId())) {
            LOG.trace((Object)("Instance : " + event.getInstanceId() + " monitoring is not enabled"));
            return;
        }
        if (this.instanceInfoProvider.getInstanceId(event.getInstanceId()).equals(event.getInstanceId()) && this.instanceInfoProvider.getMonitoring(event.getInstanceId())) {
            PutMetricDataType putMetricData = new PutMetricDataType();
            MetricDatum metricDatum = new MetricDatum();
            ArrayList dimArray = Lists.newArrayList();
            if (event.getDimension() != null && event.getValue() != null) {
                if (event.getDimension().startsWith("vol-")) {
                    putMetricData.setNamespace("AWS/EBS");
                    Dimension volDim = new Dimension();
                    volDim.setName("VolumeId");
                    volDim.setValue(event.getDimension());
                    dimArray.add(volDim);
                    if (event.getMetric().startsWith("Disk")) {
                        String convertedEBSMetricName = event.getMetric().replace("Disk", "Volume");
                        metricDatum.setMetricName(convertedEBSMetricName);
                    } else {
                        metricDatum.setMetricName(event.getMetric());
                    }
                } else {
                    putMetricData.setNamespace("AWS/EC2");
                    this.populateInstanceDimensions(event.getInstanceId(), dimArray);
                    if (UNSUPPORTED_EC2_METRICS.contains(event.getMetric())) {
                        return;
                    }
                    metricDatum.setMetricName(event.getMetric());
                }
            } else {
                LOG.debug((Object)"Event does not contain a dimension");
                return;
            }
            Dimensions dims = new Dimensions();
            dims.setMember(dimArray);
            MetricData metricData = new MetricData();
            metricDatum.setTimestamp(new Date(event.getValueTimestamp()));
            metricDatum.setDimensions(dims);
            metricDatum.setValue(event.getValue());
            String unitType = this.containsUnitType(metricDatum.getMetricName());
            metricDatum.setUnit(unitType);
            if (ABSOLUTE_METRICS.containsKey(metricDatum.getMetricName())) {
                metricDatum.setMetricName(ABSOLUTE_METRICS.get(metricDatum.getMetricName()));
            }
            metricData.setMember(Lists.newArrayList((Object[])new MetricDatum[]{metricDatum}));
            putMetricData.setMetricData(metricData);
            putMetricData.setUserId(this.instanceInfoProvider.getEffectiveUserId(event.getInstanceId()));
            putMetricData.markPrivileged();
            putMetricDataList.add(putMetricData);
        }
    }

    private void populateInstanceDimensions(String instanceId, ArrayList<Dimension> dimArray) {
        try {
            String autoscalingGroupName = this.instanceInfoProvider.getAutoscalingGroupName(instanceId);
            if (autoscalingGroupName != null) {
                Dimension autoscalingGroupNameDim = new Dimension();
                autoscalingGroupNameDim.setName("AutoScalingGroupName");
                autoscalingGroupNameDim.setValue(autoscalingGroupName);
                dimArray.add(autoscalingGroupNameDim);
            }
        }
        catch (Exception autoscalingGroupName) {
            // empty catch block
        }
        Dimension instanceIdDim = new Dimension();
        instanceIdDim.setName("InstanceId");
        instanceIdDim.setValue(this.instanceInfoProvider.getInstanceId(instanceId));
        dimArray.add(instanceIdDim);
        Dimension imageIdDim = new Dimension();
        imageIdDim.setName("ImageId");
        imageIdDim.setValue(this.instanceInfoProvider.getImageId(instanceId));
        dimArray.add(imageIdDim);
        Dimension instanceTypeDim = new Dimension();
        instanceTypeDim.setName("InstanceType");
        instanceTypeDim.setValue(this.instanceInfoProvider.getVmTypeDisplayName(instanceId));
        dimArray.add(instanceTypeDim);
    }

    private PutMetricDataType buildInstanceStatusPut(String instanceId) throws Exception {
        ImmutableList instanceStatusDatums = ImmutableList.builder().add((Object)Pair.pair((Object)Count.StatusCheckFailed.name(), (Object)this.instanceInfoProvider.getStatusCheckFailed(instanceId).doubleValue())).add((Object)Pair.pair((Object)Count.StatusCheckFailed_Instance.name(), (Object)this.instanceInfoProvider.getInstanceStatusCheckFailed(instanceId).doubleValue())).add((Object)Pair.pair((Object)Count.StatusCheckFailed_System.name(), (Object)this.instanceInfoProvider.getSystemStatusCheckFailed(instanceId).doubleValue())).build();
        ArrayList dimArray = Lists.newArrayList();
        this.populateInstanceDimensions(instanceId, dimArray);
        Dimensions dimensions = new Dimensions();
        dimensions.setMember(dimArray);
        ArrayList metricDatums = Lists.newArrayList();
        for (Pair datum : instanceStatusDatums) {
            MetricDatum metricDatum = new MetricDatum();
            metricDatum.setMetricName((String)datum.getLeft());
            metricDatum.setDimensions(dimensions);
            metricDatum.setTimestamp(new Date());
            metricDatum.setValue((Double)datum.getRight());
            metricDatum.setUnit(Count.class.getSimpleName());
            metricDatums.add(metricDatum);
        }
        MetricData metricData = new MetricData();
        metricData.setMember(metricDatums);
        PutMetricDataType putMetricData = new PutMetricDataType();
        putMetricData.setNamespace("AWS/EC2");
        putMetricData.setMetricData(metricData);
        putMetricData.setUserId(this.instanceInfoProvider.getEffectiveUserId(instanceId));
        putMetricData.markPrivileged();
        return putMetricData;
    }

    private static Predicate<PutMetricDataType> withMetric(final String namespace, final String name, final String dimensionName, final String dimensionValue) {
        return new Predicate<PutMetricDataType>(){
            private final Predicate<MetricDatum> metricDatumPredicate;
            {
                this.metricDatumPredicate = Predicates.and((Predicate)(name == null ? Predicates.alwaysTrue() : CloudWatchHelper.withMetric(name)), (Predicate)CloudWatchHelper.withMetricDimension(dimensionName, dimensionValue));
            }

            public boolean apply(@Nullable PutMetricDataType putMetricDataType) {
                return putMetricDataType != null && namespace.equals(putMetricDataType.getNamespace()) && putMetricDataType.getMetricData() != null && putMetricDataType.getMetricData().getMember() != null && Iterables.tryFind((Iterable)putMetricDataType.getMetricData().getMember(), this.metricDatumPredicate).isPresent();
            }
        };
    }

    private static Predicate<MetricDatum> withMetric(final String name) {
        return new Predicate<MetricDatum>(){

            public boolean apply(@Nullable MetricDatum metricDatum) {
                return metricDatum != null && name.equals(metricDatum.getMetricName());
            }
        };
    }

    private static Predicate<MetricDatum> withMetricDimension(final String dimensionName, final String dimensionValue) {
        return new Predicate<MetricDatum>(){
            private final Predicate<Dimension> dimensionPredicate;
            {
                this.dimensionPredicate = CloudWatchHelper.withDimension(dimensionName, dimensionValue);
            }

            public boolean apply(@Nullable MetricDatum metricDatum) {
                return metricDatum != null && metricDatum.getDimensions() != null && metricDatum.getDimensions().getMember() != null && Iterables.tryFind((Iterable)metricDatum.getDimensions().getMember(), this.dimensionPredicate).isPresent();
            }
        };
    }

    private static Predicate<Dimension> withDimension(final String dimensionName, final String dimensionValue) {
        return new Predicate<Dimension>(){

            public boolean apply(@Nullable Dimension dimension) {
                return dimension != null && dimensionName.equals(dimension.getName()) && dimensionValue.equals(dimension.getValue());
            }
        };
    }

    public static class DefaultInstanceInfoProvider
    implements InstanceInfoProvider {
        Map<String, VmInstance> cachedInstances = new HashMap<String, VmInstance>();
        LoadingCache<String, String> instanceIdToAutoscalingGroupNameCache = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<String, String>(){

            public String load(@Nonnull String instanceId) {
                VmInstance instance = DefaultInstanceInfoProvider.this.lookupInstance(instanceId);
                try {
                    return ((Tag)((Object)Transactions.find((Object)((Object)VmInstanceTag.named(instance, instance.getOwner(), "aws:autoscaling:groupName"))))).getValue();
                }
                catch (Exception ex) {
                    return null;
                }
            }
        });

        @Override
        public Iterable<String> getRunningInstanceUUIDList() {
            return Iterables.transform(VmInstances.list(VmInstance.VmState.RUNNING), VmInstances.toInstanceUuid());
        }

        private VmInstance lookupInstance(String instanceId) {
            if (this.cachedInstances.containsKey(instanceId)) {
                return this.cachedInstances.get(instanceId);
            }
            VmInstance instance = VmInstances.lookup(instanceId);
            this.cachedInstances.put(instanceId, instance);
            return instance;
        }

        @Override
        public String getAutoscalingGroupName(String instanceId) {
            return (String)this.instanceIdToAutoscalingGroupNameCache.getUnchecked((Object)instanceId);
        }

        @Override
        public String getInstanceId(String instanceId) {
            VmInstance instance = this.lookupInstance(instanceId);
            return instance.getInstanceId();
        }

        @Override
        public String getImageId(String instanceId) {
            VmInstance instance = this.lookupInstance(instanceId);
            return instance.getImageId();
        }

        @Override
        public String getVmTypeDisplayName(String instanceId) {
            VmInstance instance = this.lookupInstance(instanceId);
            return instance.getVmType().getDisplayName();
        }

        @Override
        public String getEffectiveUserId(String instanceId) throws Exception {
            VmInstance instance = this.lookupInstance(instanceId);
            Account account = Accounts.getAccountProvider().lookupAccountById(instance.getOwnerAccountNumber());
            User user = account.lookupUserByName("admin");
            return user.getUserId();
        }

        @Override
        public Integer getStatusCheckFailed(String instanceId) {
            return this.getSystemStatusCheckFailed(instanceId);
        }

        @Override
        public Integer getInstanceStatusCheckFailed(String instanceId) {
            return 0;
        }

        @Override
        public Integer getSystemStatusCheckFailed(String instanceId) {
            VmInstance instance = this.lookupInstance(instanceId);
            return instance.getRuntimeState().getInstanceStatus() == VmRuntimeState.InstanceStatus.Ok ? 0 : 1;
        }

        @Override
        public boolean getMonitoring(String instanceId) {
            VmInstance instance = this.lookupInstance(instanceId);
            return instance.getMonitoring();
        }
    }

    public static interface InstanceInfoProvider {
        public Iterable<String> getRunningInstanceUUIDList();

        public String getAutoscalingGroupName(String var1);

        public String getInstanceId(String var1);

        public String getImageId(String var1);

        public String getVmTypeDisplayName(String var1);

        public String getEffectiveUserId(String var1) throws Exception;

        public Integer getStatusCheckFailed(String var1);

        public Integer getInstanceStatusCheckFailed(String var1);

        public Integer getSystemStatusCheckFailed(String var1);

        public boolean getMonitoring(String var1);
    }

    private static enum Percent {
        VolumeThroughputPercentage,
        CPUUtilization;

    }

    private static enum Seconds {
        VolumeTotalReadTime,
        VolumeTotalWriteTime,
        VolumeTotalReadWriteTime,
        VolumeIdleTime;

    }

    private static enum Count {
        VolumeWriteOps,
        VolumeQueueLength,
        VolumeConsumedReadWriteOps,
        DiskReadOps,
        DiskWriteOps,
        StatusCheckFailed,
        StatusCheckFailed_Instance,
        StatusCheckFailed_System,
        VolumeReadOps;

    }

    private static enum Bytes {
        VolumeReadBytes,
        VolumeWriteBytes,
        DiskReadBytes,
        DiskWriteBytes,
        NetworkIn,
        NetworkOut;

    }

    private static class EC2DiskMetricCache {
        private ConcurrentMap<EC2DiskMetricCacheKey, EC2DiskMetricCacheValue> cacheMap = Maps.newConcurrentMap();

        private EC2DiskMetricCache() {
        }

        public void addToMetric(String resourceUuid, String resourceName, String metricName, Double currentValue, Long currentTimeStamp) {
            EC2DiskMetricCacheKey key = new EC2DiskMetricCacheKey(resourceUuid, resourceName, currentTimeStamp, metricName);
            EC2DiskMetricCacheValue value = (EC2DiskMetricCacheValue)this.cacheMap.get(key);
            if (value == null) {
                this.cacheMap.put(key, new EC2DiskMetricCacheValue(key, currentValue));
            } else {
                value.addValue(currentValue);
            }
        }

        public void initializeMetrics(String resourceUuid, String resourceName, Long currentTimeStamp) {
            for (String metricName : EC2_DISK_METRICS) {
                this.addToMetric(resourceUuid, resourceName, metricName, 0.0, currentTimeStamp);
            }
        }

        public Collection<Supplier<InstanceUsageEvent>> getMetrics() {
            ArrayList suppliers = Lists.newArrayList();
            for (final EC2DiskMetricCacheValue value : this.cacheMap.values()) {
                suppliers.add(new Supplier<InstanceUsageEvent>(){

                    public InstanceUsageEvent get() {
                        return new InstanceUsageEvent(value.getResourceUuid(), value.getResourceName(), value.getMetricName(), Long.valueOf(0L), "Ephemeral", value.getValue(), value.getTimeStamp());
                    }
                });
            }
            return suppliers;
        }
    }

    private static class EC2DiskMetricCacheValue {
        private EC2DiskMetricCacheKey key;
        private Double value;

        public EC2DiskMetricCacheValue(EC2DiskMetricCacheKey key, Double value) {
            this.key = key;
            this.value = value;
        }

        public void addValue(Double currentValue) {
            EC2DiskMetricCacheValue eC2DiskMetricCacheValue = this;
            eC2DiskMetricCacheValue.value = eC2DiskMetricCacheValue.value + currentValue;
        }

        public String getMetricName() {
            return this.key.getMetricName();
        }

        public Double getValue() {
            return this.value;
        }

        public Long getTimeStamp() {
            return this.key.getCurrentTimeStamp();
        }

        public String getResourceName() {
            return this.key.getResourceName();
        }

        public String getResourceUuid() {
            return this.key.getResourceUuid();
        }
    }

    private static class EC2DiskMetricCacheKey {
        private String resourceUuid;
        private String resourceName;
        private Long currentTimeStamp;
        private String metricName;

        private EC2DiskMetricCacheKey(String resourceUuid, String resourceName, Long currentTimeStamp, String metricName) {
            this.resourceUuid = resourceUuid;
            this.resourceName = resourceName;
            this.currentTimeStamp = currentTimeStamp;
            this.metricName = metricName;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.currentTimeStamp == null ? 0 : this.currentTimeStamp.hashCode());
            result = 31 * result + (this.metricName == null ? 0 : this.metricName.hashCode());
            result = 31 * result + (this.resourceName == null ? 0 : this.resourceName.hashCode());
            result = 31 * result + (this.resourceUuid == null ? 0 : this.resourceUuid.hashCode());
            return result;
        }

        public String getResourceUuid() {
            return this.resourceUuid;
        }

        public String getResourceName() {
            return this.resourceName;
        }

        public Long getCurrentTimeStamp() {
            return this.currentTimeStamp;
        }

        public String getMetricName() {
            return this.metricName;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            EC2DiskMetricCacheKey other = (EC2DiskMetricCacheKey)obj;
            if (this.currentTimeStamp == null ? other.currentTimeStamp != null : !this.currentTimeStamp.equals(other.currentTimeStamp)) {
                return false;
            }
            if (this.metricName == null ? other.metricName != null : !this.metricName.equals(other.metricName)) {
                return false;
            }
            if (this.resourceName == null ? other.resourceName != null : !this.resourceName.equals(other.resourceName)) {
                return false;
            }
            return !(this.resourceUuid == null ? other.resourceUuid != null : !this.resourceUuid.equals(other.resourceUuid));
        }
    }

    private static class DiskReadWriteMetricTypeCache {
        private Map<String, MetricDimensionsValuesType> eventMap = Maps.newConcurrentMap();

        private DiskReadWriteMetricTypeCache() {
        }

        private String mapKey(SensorsResourceType sensorData, MetricDimensionsType dimensionType, MetricDimensionsValuesType value) {
            String SEPARATOR = "|";
            String resourceUUID = sensorData != null ? sensorData.getResourceUuid() : null;
            String resourceName = sensorData != null ? sensorData.getResourceName() : null;
            String dimensionName = dimensionType != null ? dimensionType.getDimensionName() : null;
            String valueTimestampStr = value != null && value.getTimestamp() != null ? value.getTimestamp().toString() : null;
            return resourceUUID + SEPARATOR + resourceName + SEPARATOR + dimensionName + SEPARATOR + valueTimestampStr;
        }

        public void putEventInCache(SensorsResourceType sensorData, MetricDimensionsType dimensionType, MetricDimensionsValuesType value) {
            this.eventMap.put(this.mapKey(sensorData, dimensionType, value), value);
        }

        public MetricDimensionsValuesType getEventFromCache(SensorsResourceType sensorData, MetricDimensionsType dimensionType, MetricDimensionsValuesType value) {
            return this.eventMap.get(this.mapKey(sensorData, dimensionType, value));
        }
    }
}

