/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.cluster.callback;

import com.eucalyptus.address.Address;
import com.eucalyptus.address.Addresses;
import com.eucalyptus.address.AddressingDispatcher;
import com.eucalyptus.records.EventRecord;
import com.eucalyptus.records.EventType;
import com.eucalyptus.records.Logs;
import com.eucalyptus.util.async.AsyncRequests;
import com.eucalyptus.util.async.MessageCallback;
import com.eucalyptus.vm.VmInstance;
import com.eucalyptus.vm.VmInstances;
import edu.ucsb.eucalyptus.msgs.AssignAddressResponseType;
import edu.ucsb.eucalyptus.msgs.AssignAddressType;
import edu.ucsb.eucalyptus.msgs.BaseMessage;
import java.util.NoSuchElementException;
import org.apache.log4j.Logger;

public class AssignAddressCallback
extends MessageCallback<AssignAddressType, AssignAddressResponseType> {
    private static Logger LOG = Logger.getLogger(AssignAddressCallback.class);
    private final Address address;
    private final VmInstance vm;

    public AssignAddressCallback(Address address) {
        super((BaseMessage)new AssignAddressType(address.getStateUuid(), address.getName(), address.getInstanceAddress(), address.getInstanceId()));
        this.address = address;
        this.vm = this.lookupVm();
    }

    private VmInstance lookupVm() {
        try {
            VmInstance foundVm = VmInstances.lookup(((AssignAddressType)super.getRequest()).getInstanceId());
            if (VmInstance.VmStateSet.RUN.apply(foundVm)) {
                return foundVm;
            }
            return null;
        }
        catch (VmInstances.TerminatedInstanceException ex) {
            return null;
        }
        catch (NoSuchElementException ex) {
            return null;
        }
    }

    public void initialize(AssignAddressType msg) {
        LOG.debug((Object)this.address.toString());
    }

    public void fire(AssignAddressResponseType msg) {
        try {
            if (!this.checkVmState()) {
                this.clearState();
            } else {
                this.address.clearPending();
                EventRecord.here(AssignAddressCallback.class, (EventType)EventType.ADDRESS_ASSIGNED, (String[])new String[]{Address.State.assigned.toString(), this.address.toString()}).info();
            }
        }
        catch (Exception e) {
            LOG.debug((Object)e, (Throwable)e);
            this.clearState();
        }
    }

    public void fireException(Throwable e) {
        LOG.error((Object)e);
        Logs.extreme().error((Object)e, e);
        this.clearState();
    }

    private void clearState() {
        EventRecord.here(AssignAddressCallback.class, (EventType)EventType.ADDRESS_ASSIGNING, (String[])new String[]{Address.Transition.assigning.toString(), "FAILED", this.address.toString()}).debug();
        if (this.address.isPending()) {
            try {
                this.address.clearPending();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.address.isSystemOwned()) {
            Addresses.release(this.address);
        } else if (this.address.isAssigned() && this.vm != null) {
            AddressingDispatcher.dispatch(AsyncRequests.newRequest(this.address.unassign().getCallback()), this.vm.getPartition());
        } else if (this.address.isAssigned() && this.vm == null) {
            this.address.unassign().clearPending();
        }
    }

    private boolean checkVmState() {
        try {
            if (this.vm != null) {
                VmInstance foundVm = VmInstances.lookup(this.vm.getInstanceId());
                return VmInstance.VmStateSet.RUN.apply(foundVm);
            }
            return false;
        }
        catch (NoSuchElementException e) {
            LOG.debug((Object)e, (Throwable)e);
            return false;
        }
    }

    public String toString() {
        return "AssignAddressCallback " + (Object)((Object)this.address) + " vm=" + (this.vm != null ? this.vm.getInstanceId() : "none");
    }
}

