/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.cluster;

import com.eucalyptus.cloud.ResourceToken;
import com.eucalyptus.cloud.run.Allocations;
import com.eucalyptus.cloud.util.NotEnoughResourcesException;
import com.eucalyptus.records.EventRecord;
import com.eucalyptus.records.EventType;
import com.eucalyptus.records.Logs;
import com.eucalyptus.util.LogUtil;
import com.eucalyptus.util.OwnerFullName;
import com.eucalyptus.vmtypes.VmType;
import com.eucalyptus.vmtypes.VmTypes;
import com.google.common.base.Joiner;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import edu.ucsb.eucalyptus.msgs.ResourceType;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.NavigableSet;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import org.apache.log4j.Logger;

public class ResourceState {
    private static Logger LOG = Logger.getLogger(ResourceState.class);
    private ConcurrentNavigableMap<String, VmTypeAvailability> typeMap;
    private NavigableSet<ResourceToken> pendingTokens;
    private NavigableSet<ResourceToken> submittedTokens;
    private NavigableSet<ResourceToken> redeemedTokens;
    private String clusterName;

    public ResourceState(String clusterName) {
        this.clusterName = clusterName;
        this.typeMap = new ConcurrentSkipListMap<String, VmTypeAvailability>();
        for (VmType v : VmTypes.list()) {
            this.typeMap.putIfAbsent(v.getName(), new VmTypeAvailability(v, 0, 0));
        }
        this.pendingTokens = new ConcurrentSkipListSet<ResourceToken>();
        this.submittedTokens = new ConcurrentSkipListSet<ResourceToken>();
        this.redeemedTokens = new ConcurrentSkipListSet<ResourceToken>();
    }

    public boolean hasUnorderedTokens() {
        return Iterables.any(this.pendingTokens, (Predicate)new Predicate<ResourceToken>(){

            public boolean apply(ResourceToken arg0) {
                return arg0.isUnorderedType();
            }
        });
    }

    public synchronized List<ResourceToken> requestResourceAllocation(Allocations.Allocation allocInfo, int minAmount, int maxAmount) throws NotEnoughResourcesException {
        VmTypeAvailability vmTypeStatus = (VmTypeAvailability)this.typeMap.get(allocInfo.getVmType().getName());
        Integer available = vmTypeStatus.getAvailable();
        NavigableSet<VmTypeAvailability> sorted = this.sorted();
        LOG.debug((Object)LogUtil.header((String)"BEFORE ALLOCATE"));
        LOG.debug(sorted);
        if (vmTypeStatus.getAvailable() < minAmount) {
            throw new NotEnoughResourcesException("Not enough resources (" + available + " < " + minAmount + ": vm instances.");
        }
        Integer quantity = maxAmount < available ? maxAmount : available;
        SortedSet<VmTypeAvailability> tailSet = sorted.tailSet(vmTypeStatus);
        SortedSet<VmTypeAvailability> headSet = sorted.headSet(vmTypeStatus);
        LOG.debug((Object)LogUtil.header((String)"DURING ALLOCATE"));
        LOG.debug((Object)LogUtil.subheader((String)("TAILSET: \n" + tailSet)));
        LOG.debug((Object)LogUtil.subheader((String)("HEADSET: \n" + headSet)));
        for (VmTypeAvailability v : tailSet) {
            v.decrement(quantity);
        }
        for (VmTypeAvailability v : headSet) {
            v.setAvailable(vmTypeStatus.getAvailable());
        }
        LOG.debug((Object)LogUtil.header((String)"AFTER ALLOCATE"));
        LOG.debug(sorted);
        ArrayList tokenList = Lists.newArrayList();
        for (int i = 0; i < quantity; ++i) {
            try {
                ResourceToken token = new ResourceToken(allocInfo, i);
                LOG.debug((Object)(EventType.TOKEN_RESERVED.name() + ": " + token.toString()));
                this.pendingTokens.add(token);
                tokenList.add(token);
                continue;
            }
            catch (Exception ex) {
                LOG.error((Object)ex);
                Logs.extreme().error((Object)ex, (Throwable)ex);
                for (ResourceToken token : tokenList) {
                    this.pendingTokens.remove(token);
                }
            }
        }
        return tokenList;
    }

    public int countUncommittedPendingInstances(OwnerFullName ownerFullName) {
        int count = 0;
        for (ResourceToken token : this.pendingTokens) {
            if (token.isCommitted() || !token.getOwner().isOwner(ownerFullName)) continue;
            count += token.getAmount().intValue();
        }
        return count;
    }

    public synchronized void releaseToken(ResourceToken token) {
        VmTypeAvailability vmAvailable;
        LOG.debug((Object)(EventType.TOKEN_RELEASED.name() + ": " + token.toString()));
        if (this.pendingTokens.remove(token) && (vmAvailable = (VmTypeAvailability)this.typeMap.get(token.getAllocationInfo().getVmType().getName())) != null) {
            vmAvailable.decrement(-1);
        }
        this.submittedTokens.remove(token);
        this.redeemedTokens.remove(token);
    }

    public synchronized void submitToken(ResourceToken token) throws NoSuchTokenException {
        LOG.debug((Object)(EventType.TOKEN_SUBMITTED.name() + ": " + token.toString()));
        if (!this.pendingTokens.remove(token)) {
            throw new NoSuchTokenException(token.toString());
        }
        this.submittedTokens.add(token);
    }

    public synchronized void redeemToken(ResourceToken token) throws NoSuchTokenException {
        LOG.debug((Object)(EventType.TOKEN_REDEEMED.name() + ": " + token.toString()));
        if (this.submittedTokens.remove(token) || this.pendingTokens.remove(token)) {
            this.redeemedTokens.add(token);
        } else {
            LOG.error((Object)("Failed to find token: " + token + "\n" + Joiner.on((String)"\n").join((Object)"pending", this.pendingTokens, new Object[]{"submitted", this.submittedTokens, "redeemed", this.redeemedTokens})), (Throwable)new NoSuchTokenException(token.toString()));
        }
    }

    public synchronized boolean isPending(ResourceToken token) {
        return this.pendingTokens.contains(token);
    }

    public synchronized void update(List<ResourceType> rscUpdate) {
        long expiryAge = System.currentTimeMillis() - TimeUnit.MINUTES.toMillis(this.getExpiryMinutes(15));
        this.expirePendingTokens(expiryAge);
        int pending = 0;
        int submitted = 0;
        int redeemed = 0;
        for (ResourceToken t : this.pendingTokens) {
            pending += t.getAmount().intValue();
        }
        for (ResourceToken t : this.submittedTokens) {
            submitted += t.getAmount().intValue();
        }
        for (ResourceToken t : this.redeemedTokens) {
            redeemed += t.getAmount().intValue();
        }
        int outstandingCount = pending + submitted;
        EventRecord.here(ResourceState.class, (EventType)EventType.CLUSTER_STATE_UPDATE, (String[])new String[]{this.clusterName, String.format("outstanding=%d:pending=%d:submitted=%d:redeemed=%d", outstandingCount, pending, submitted, redeemed)}).info();
        this.redeemedTokens.clear();
        StringBuilder before = new StringBuilder();
        StringBuilder after = new StringBuilder();
        for (ResourceType rsc : rscUpdate) {
            VmTypeAvailability vmAvailable = (VmTypeAvailability)this.typeMap.get(rsc.getInstanceType().getName());
            if (vmAvailable == null) continue;
            before.append(String.format(":%s:%d/%d", vmAvailable.getType().getName(), vmAvailable.getAvailable(), vmAvailable.getMax()));
            vmAvailable.setAvailable(rsc.getAvailableInstances());
            vmAvailable.decrement(outstandingCount);
            vmAvailable.setMax(rsc.getMaxInstances());
            after.append(String.format(":%s:%d/%d", vmAvailable.getType().getName(), vmAvailable.getAvailable(), vmAvailable.getMax()));
        }
        EventRecord.here(ResourceState.class, (EventType)EventType.CLUSTER_STATE_UPDATE, (String[])new String[]{this.clusterName, "ANTE" + before.toString()}).info();
        EventRecord.here(ResourceState.class, (EventType)EventType.CLUSTER_STATE_UPDATE, (String[])new String[]{this.clusterName, "POST" + after.toString()}).info();
    }

    private int getExpiryMinutes(int defaultValue) {
        try {
            return Integer.parseInt(System.getProperty("com.eucalyptus.cluster.pendingTokenTimeout", String.valueOf(defaultValue)));
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    private void expirePendingTokens(long expireBefore) {
        Date oldestDate = new Date(expireBefore);
        for (ResourceToken token : this.pendingTokens) {
            if (!token.getCreationTime().before(oldestDate)) continue;
            LOG.error((Object)("Expiring pending token: " + token));
            this.pendingTokens.remove(token);
        }
    }

    private NavigableSet<VmTypeAvailability> sorted() {
        TreeSet<VmTypeAvailability> available = new TreeSet<VmTypeAvailability>();
        for (String typeName : this.typeMap.keySet()) {
            available.add((VmTypeAvailability)this.typeMap.get(typeName));
        }
        available.add(VmTypeAvailability.ZERO);
        LOG.debug((Object)("Resource information for " + this.clusterName));
        return available;
    }

    public VmTypeAvailability getAvailability(String vmTypeName) {
        return (VmTypeAvailability)this.typeMap.get(vmTypeName);
    }

    public String toString() {
        return String.format("ClusterNodeState pending=%s redeemed=%s submitted=%s", this.pendingTokens, this.redeemedTokens, this.submittedTokens);
    }

    public static class VmTypeAvailability
    implements Comparable {
        private VmType type;
        private int max;
        private int available;
        public static VmTypeAvailability ZERO = new ZeroTypeAvailability();

        public VmTypeAvailability(VmType type, int max, int available) {
            this.type = type;
            this.max = max;
            this.available = available;
        }

        public VmType getType() {
            return this.type;
        }

        public void decrement(int quantity) {
            this.available -= quantity;
            this.available = this.available < 0 ? 0 : this.available;
        }

        public int getMax() {
            return this.max;
        }

        public void setMax(int max) {
            this.max = max;
        }

        public int getAvailable() {
            return this.available;
        }

        public void setAvailable(int available) {
            this.available = available;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof VmTypeAvailability)) {
                return false;
            }
            VmTypeAvailability that = (VmTypeAvailability)o;
            return this.type.equals((Object)that.type);
        }

        public int hashCode() {
            return this.type.hashCode();
        }

        public int compareTo(@Nonnull Object o) {
            VmTypeAvailability v = (VmTypeAvailability)o;
            if (v.getAvailable() == this.getAvailable()) {
                return this.type.compareTo(v.getType());
            }
            return v.getAvailable() - this.getAvailable();
        }

        public String toString() {
            return "VmTypeAvailability  " + (Object)((Object)this.type) + " " + this.available + " / " + this.max;
        }

        static class ZeroTypeAvailability
        extends VmTypeAvailability {
            ZeroTypeAvailability() {
                super(VmType.create("ZERO", -1, -1, -1), 0, 0);
            }

            @Override
            public int compareTo(@Nonnull Object o) {
                VmTypeAvailability v = (VmTypeAvailability)o;
                if (v == ZERO) {
                    return 0;
                }
                if (v.getAvailable() > 0) {
                    return 1;
                }
                return -1;
            }

            @Override
            public void setAvailable(int available) {
            }

            @Override
            public void decrement(int quantity) {
            }

            @Override
            public boolean equals(Object o) {
                return this == o;
            }
        }
    }

    public static class NoSuchTokenException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public NoSuchTokenException(String message) {
            super(message);
        }
    }
}

