/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.cluster;

import com.eucalyptus.cluster.Cluster;
import com.eucalyptus.component.ServiceConfiguration;
import com.eucalyptus.configurable.ConfigurableClass;
import com.eucalyptus.configurable.ConfigurableField;
import com.eucalyptus.entities.AbstractPersistent;
import com.eucalyptus.entities.Transactions;
import com.eucalyptus.event.AbstractNamedRegistry;
import com.eucalyptus.records.Logs;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.TreeSet;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.PersistenceContext;
import javax.persistence.Table;
import org.apache.log4j.Logger;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;

public class Clusters
extends AbstractNamedRegistry<Cluster> {
    private static Clusters singleton = Clusters.getInstance();
    private static Logger LOG = Logger.getLogger(Clusters.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Clusters getInstance() {
        Class<Clusters> clazz = Clusters.class;
        synchronized (Clusters.class) {
            if (singleton == null) {
                singleton = new Clusters();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return singleton;
        }
    }

    public List<String> getClusterAddresses() {
        TreeSet<String> hostOrdered = new TreeSet<String>();
        for (Cluster c : this.listValues()) {
            hostOrdered.add(c.getConfiguration().getHostName());
        }
        return Lists.newArrayList(hostOrdered);
    }

    public static Cluster lookup(ServiceConfiguration clusterConfig) {
        try {
            return (Cluster)Clusters.getInstance().lookup(clusterConfig.getName());
        }
        catch (NoSuchElementException ex) {
            return (Cluster)Clusters.getInstance().lookupDisabled(clusterConfig.getName());
        }
    }

    public static Configuration getConfiguration() {
        Configuration ret = null;
        try {
            ret = (Configuration)((Object)Transactions.find((Object)((Object)new Configuration())));
        }
        catch (Exception ex1) {
            try {
                ret = (Configuration)((Object)Transactions.save((Object)((Object)new Configuration())));
            }
            catch (Exception ex) {
                Logs.extreme().error((Object)ex, (Throwable)ex);
                ret = new Configuration();
            }
        }
        return ret;
    }

    @Entity
    @PersistenceContext(name="eucalyptus_cloud")
    @Table(name="cloud_cluster_configuration")
    @Cache(usage=CacheConcurrencyStrategy.TRANSACTIONAL)
    @ConfigurableClass(root="cloud.cluster", description="Configuration options controlling interactions with Cluster Controllers.")
    static class Configuration
    extends AbstractPersistent {
        private static final long serialVersionUID = 1L;
        @ConfigurableField(description="The number of concurrent requests which will be sent to a single Cluster Controller.")
        @Column(name="config_cluster_workers", nullable=false)
        private Integer requestWorkers = 8;
        @ConfigurableField(description="The time period between service state checks for a Cluster Controller which is PENDING.")
        @Column(name="config_cluster_interval_pending", nullable=false)
        private Long pendingInterval = 3L;
        @ConfigurableField(description="The time period between service state checks for a Cluster Controller which is NOTREADY.")
        @Column(name="config_cluster_interval_notready", nullable=false)
        private Long notreadyInterval = 10L;
        @ConfigurableField(description="The time period between service state checks for a Cluster Controller which is DISABLED.")
        @Column(name="config_cluster_interval_disabled", nullable=false)
        private Long disabledInterval = 15L;
        @ConfigurableField(description="The time period between service state checks for a Cluster Controller which is ENABLED.")
        @Column(name="config_cluster_interval_enabled", nullable=false)
        private Long enabledInterval = 15L;
        @ConfigurableField(description="The number of times a request will be retried while bootstrapping a Cluster Controller.")
        @Column(name="config_cluster_startup_sync_retries", nullable=false)
        private Integer startupSyncRetries = 10;

        public Integer getRequestWorkers() {
            return this.requestWorkers;
        }

        private void setRequestWorkers(Integer requestWorkers) {
            this.requestWorkers = requestWorkers;
        }

        public void setStartupSyncRetries(Integer startupSyncRetries) {
            this.startupSyncRetries = startupSyncRetries;
        }

        public Integer getStartupSyncRetries() {
            return this.startupSyncRetries;
        }

        private void setEnabledInterval(Long enabledInterval) {
            this.enabledInterval = enabledInterval;
        }

        public Long getEnabledInterval() {
            return this.enabledInterval;
        }

        private void setDisabledInterval(Long disabledInterval) {
            this.disabledInterval = disabledInterval;
        }

        public Long getDisabledInterval() {
            return this.disabledInterval;
        }

        private void setNotreadyInterval(Long notreadyInterval) {
            this.notreadyInterval = notreadyInterval;
        }

        public Long getNotreadyInterval() {
            return this.notreadyInterval;
        }

        private void setPendingInterval(Long pendingInterval) {
            this.pendingInterval = pendingInterval;
        }

        public Long getPendingInterval() {
            return this.pendingInterval;
        }
    }
}

