/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.cluster;

import com.eucalyptus.auth.AuthContextSupplier;
import com.eucalyptus.auth.Permissions;
import com.eucalyptus.cluster.Cluster;
import com.eucalyptus.cluster.Clusters;
import com.eucalyptus.cluster.ResourceState;
import com.eucalyptus.component.Component;
import com.eucalyptus.component.Components;
import com.eucalyptus.component.Partition;
import com.eucalyptus.component.ServiceConfiguration;
import com.eucalyptus.component.ServiceUris;
import com.eucalyptus.component.Topology;
import com.eucalyptus.component.id.ClusterController;
import com.eucalyptus.component.id.Eucalyptus;
import com.eucalyptus.compute.ComputeException;
import com.eucalyptus.compute.common.CloudMetadatas;
import com.eucalyptus.compute.common.ClusterInfoType;
import com.eucalyptus.compute.common.ImageMetadata;
import com.eucalyptus.compute.common.RegionInfoType;
import com.eucalyptus.compute.common.backend.DescribeAvailabilityZonesResponseType;
import com.eucalyptus.compute.common.backend.DescribeAvailabilityZonesType;
import com.eucalyptus.compute.common.backend.DescribeRegionsResponseType;
import com.eucalyptus.compute.common.backend.DescribeRegionsType;
import com.eucalyptus.compute.common.backend.MigrateInstancesResponseType;
import com.eucalyptus.compute.common.backend.MigrateInstancesType;
import com.eucalyptus.context.Context;
import com.eucalyptus.context.Contexts;
import com.eucalyptus.crypto.util.B64;
import com.eucalyptus.entities.Entities;
import com.eucalyptus.node.Nodes;
import com.eucalyptus.tags.Filter;
import com.eucalyptus.tags.FilterSupport;
import com.eucalyptus.tags.Filters;
import com.eucalyptus.util.CollectionUtils;
import com.eucalyptus.util.EucalyptusCloudException;
import com.eucalyptus.util.async.AsyncRequests;
import com.eucalyptus.vm.VmInstance;
import com.eucalyptus.vm.VmInstances;
import com.eucalyptus.vmtypes.VmType;
import com.eucalyptus.vmtypes.VmTypes;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Strings;
import com.google.common.base.Supplier;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import edu.ucsb.eucalyptus.cloud.NodeInfo;
import edu.ucsb.eucalyptus.msgs.BaseMessage;
import edu.ucsb.eucalyptus.msgs.ClusterGetConsoleOutputResponseType;
import edu.ucsb.eucalyptus.msgs.ClusterGetConsoleOutputType;
import edu.ucsb.eucalyptus.msgs.NodeCertInfo;
import edu.ucsb.eucalyptus.msgs.NodeLogInfo;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.NoSuchElementException;
import java.util.concurrent.ConcurrentSkipListSet;
import javax.annotation.Nullable;
import org.apache.log4j.Logger;
import org.mule.api.MuleException;
import org.mule.api.lifecycle.Startable;

public class ClusterEndpoint
implements Startable {
    private static Logger LOG = Logger.getLogger(ClusterEndpoint.class);
    private Map<String, Supplier<List<ClusterInfoType>>> describeKeywords = new HashMap<String, Supplier<List<ClusterInfoType>>>(){
        {
            this.put("verbose", new Supplier<List<ClusterInfoType>>(){

                public List<ClusterInfoType> get() {
                    ArrayList verbose = Lists.newArrayList();
                    for (Cluster c : Clusters.getInstance().listValues()) {
                        verbose.addAll((Collection)describeSystemInfo.apply((Object)c));
                    }
                    return verbose;
                }
            });
        }
    };
    private static String INFO_FSTRING = "|- %s";
    private static String HEADER_STRING = "free / max   cpu   ram  disk";
    private static String STATE_FSTRING = "%04d / %04d  %2d   %4d  %4d";
    private static Function<Cluster, List<ClusterInfoType>> describeSystemInfo = new Function<Cluster, List<ClusterInfoType>>(){

        public List<ClusterInfoType> apply(Cluster cluster) {
            ArrayList<ClusterInfoType> info = new ArrayList<ClusterInfoType>();
            try {
                info.add(new ClusterInfoType(cluster.getConfiguration().getPartition(), cluster.getConfiguration().getHostName() + " " + cluster.getConfiguration().getFullName()));
                info.add(new ClusterInfoType(String.format(INFO_FSTRING, "vm types"), HEADER_STRING));
                for (VmType v : VmTypes.list()) {
                    ResourceState.VmTypeAvailability va = cluster.getNodeState().getAvailability(v.getName());
                    info.add(ClusterEndpoint.s(v.getName(), String.format(STATE_FSTRING, va.getAvailable(), va.getMax(), v.getCpu(), v.getMemory(), v.getDisk())));
                }
            }
            catch (Exception e) {
                LOG.error((Object)e, (Throwable)e);
            }
            return info;
        }
    };
    private static Function<String, List<ClusterInfoType>> describeLogInfo = new Function<String, List<ClusterInfoType>>(){

        public List<ClusterInfoType> apply(String serviceTag) {
            ArrayList<ClusterInfoType> info = new ArrayList<ClusterInfoType>();
            if (Clusters.getInstance().contains(serviceTag)) {
                Cluster c = (Cluster)Clusters.getInstance().lookup(serviceTag);
                NodeLogInfo logInfo = c.getLastLog();
                info.add(ClusterEndpoint.t(c.getConfiguration().getFullName().toString(), " state=" + c.getState()));
                if (!logInfo.getCcLog().isEmpty()) {
                    info.add(ClusterEndpoint.s("cc.log\n", logInfo.getCcLog()));
                }
                info.add(ClusterEndpoint.t(c.getConfiguration().getFullName().toString(), " state=" + c.getState()));
                info.add(ClusterEndpoint.s("axis2.log\n", logInfo.getAxis2Log()));
                info.add(ClusterEndpoint.t(c.getConfiguration().getFullName().toString(), " state=" + c.getState()));
                info.add(ClusterEndpoint.s("httpd.log\n", logInfo.getHttpdLog()));
            } else {
                for (Cluster c : Clusters.getInstance().listValues()) {
                    if (c.getNode(serviceTag) == null) continue;
                    NodeInfo node = c.getNode(serviceTag);
                    NodeLogInfo logInfo = node.getLogs();
                    info.add(ClusterEndpoint.t(node.getName(), "last-seen=" + node.getLastSeen()));
                    if (!logInfo.getNcLog().isEmpty()) {
                        info.add(ClusterEndpoint.s("nc.log\n", logInfo.getNcLog()));
                    }
                    info.add(ClusterEndpoint.t(node.getName(), "last-seen=" + node.getLastSeen()));
                    info.add(ClusterEndpoint.s("axis2.log\n", logInfo.getAxis2Log()));
                    info.add(ClusterEndpoint.t(node.getName(), "last-seen=" + node.getLastSeen()));
                    info.add(ClusterEndpoint.s("httpd.log\n", logInfo.getHttpdLog()));
                }
            }
            return info;
        }
    };
    private static Function<String, List<ClusterInfoType>> describeCertInfo = new Function<String, List<ClusterInfoType>>(){

        public List<ClusterInfoType> apply(String serviceTag) {
            ArrayList<ClusterInfoType> info = new ArrayList<ClusterInfoType>();
            if (Clusters.getInstance().contains(serviceTag)) {
                Cluster c = (Cluster)Clusters.getInstance().lookup(serviceTag);
                info.add(ClusterEndpoint.t(c.getConfiguration().getFullName().toString(), " state=" + c.getState()));
                info.add(ClusterEndpoint.s("CC cert\n", c.getClusterCertificate().toString()));
                info.add(ClusterEndpoint.s("NC cert\n", c.getNodeCertificate().toString()));
            } else {
                for (Cluster c : Clusters.getInstance().listValues()) {
                    if (c.getNode(serviceTag) == null) continue;
                    NodeInfo node = c.getNode(serviceTag);
                    info.add(ClusterEndpoint.t(node.getName(), "last-seen=" + node.getLastSeen()));
                    NodeCertInfo certInfo = node.getCerts();
                    info.add(ClusterEndpoint.s("CC cert\n", certInfo.getCcCert()));
                    info.add(ClusterEndpoint.s("NC cert\n", certInfo.getCcCert()));
                }
            }
            return info;
        }
    };

    public void start() throws MuleException {
        Clusters.getInstance();
    }

    public MigrateInstancesResponseType migrateInstances(final MigrateInstancesType request) throws EucalyptusCloudException {
        MigrateInstancesResponseType reply = (MigrateInstancesResponseType)request.getReply();
        Context context = Contexts.lookup();
        if (!context.isAdministrator() || !Permissions.isAuthorized((String)"ec2", (String)"instance", (String)"", null, (String)"migrateinstances", (AuthContextSupplier)context.getAuthContext())) {
            throw new EucalyptusCloudException("Authorization failed.");
        }
        if (!Strings.isNullOrEmpty((String)request.getSourceHost())) {
            Predicate<VmInstance> filterHost = new Predicate<VmInstance>(){

                public boolean apply(@Nullable VmInstance input) {
                    String vmHost = URI.create(input.getServiceTag()).getHost();
                    return Strings.nullToEmpty((String)vmHost).equals(request.getSourceHost());
                }
            };
            for (ServiceConfiguration ccConfig : Topology.enabledServices(ClusterController.class)) {
                try {
                    ServiceConfiguration node = Nodes.lookup(ccConfig, request.getSourceHost());
                    Cluster cluster = Clusters.lookup(ccConfig);
                    List<VmInstance> instances = VmInstances.list((Predicate<? super VmInstance>)filterHost);
                    for (VmInstance instance : instances) {
                        try {
                            this.updatePasswordIfWindows(instance, ccConfig);
                        }
                        catch (Exception exception) {}
                    }
                    try {
                        cluster.migrateInstances(request.getSourceHost(), request.getAllowHosts(), request.getDestinationHosts());
                        return (MigrateInstancesResponseType)reply.markWinning();
                    }
                    catch (Exception ex) {
                        LOG.error((Object)ex);
                        throw new EucalyptusCloudException("Migrating off of node " + request.getSourceHost() + " failed because of: " + Strings.nullToEmpty((String)ex.getMessage()).replaceAll(".*:status=", ""), (Throwable)ex);
                    }
                }
                catch (EucalyptusCloudException ex) {
                    throw ex;
                }
                catch (NoSuchElementException ex) {
                }
                catch (Exception ex) {
                    LOG.error((Object)ex);
                    throw new EucalyptusCloudException("Migrating off of node " + request.getSourceHost() + " failed because of: " + ex.getMessage(), (Throwable)ex);
                }
            }
            throw new EucalyptusCloudException("No ENABLED cluster found which can service the requested node: " + request.getSourceHost());
        }
        if (!Strings.isNullOrEmpty((String)request.getInstanceId())) {
            VmInstance vm;
            try {
                vm = VmInstances.lookup(request.getInstanceId());
                if (!VmInstance.VmState.RUNNING.apply(vm)) {
                    throw new EucalyptusCloudException("Cannot migrate a " + ((VmInstance.VmState)vm.getState()).name().toLowerCase() + " instance: " + request.getInstanceId());
                }
            }
            catch (VmInstances.TerminatedInstanceException ex) {
                throw new EucalyptusCloudException("Cannot migrate a terminated instance: " + request.getInstanceId(), (Throwable)ex);
            }
            catch (NoSuchElementException ex) {
                throw new EucalyptusCloudException("Failed to lookup requested instance: " + request.getInstanceId(), (Throwable)ex);
            }
            try {
                ServiceConfiguration ccConfig = Topology.lookup(ClusterController.class, (Partition[])new Partition[]{vm.lookupPartition()});
                Cluster cluster = Clusters.lookup(ccConfig);
                try {
                    this.updatePasswordIfWindows(vm, ccConfig);
                }
                catch (Exception ex) {
                    // empty catch block
                }
                try {
                    cluster.migrateInstance(request.getInstanceId(), request.getAllowHosts(), request.getDestinationHosts());
                    return (MigrateInstancesResponseType)reply.markWinning();
                }
                catch (Exception ex) {
                    LOG.error((Object)ex);
                    throw new EucalyptusCloudException("Migrating instance " + request.getInstanceId() + " failed because of: " + Strings.nullToEmpty((String)ex.getMessage()).replaceAll(".*:status=", ""), (Throwable)ex);
                }
            }
            catch (NoSuchElementException ex) {
                throw new EucalyptusCloudException("Failed to lookup ENABLED cluster for instance " + request.getInstanceId(), (Throwable)ex);
            }
        }
        throw new EucalyptusCloudException("Either the sourceHost or instanceId must be provided");
    }

    private void updatePasswordIfWindows(final VmInstance vm, ServiceConfiguration ccConfig) throws Exception {
        if (ImageMetadata.Platform.windows.name().equals(vm.getPlatform()) && (vm.getPasswordData() == null || vm.getPasswordData().length() <= 0)) {
            try {
                ClusterGetConsoleOutputResponseType consoleOutput = (ClusterGetConsoleOutputResponseType)AsyncRequests.sendSync((ServiceConfiguration)ccConfig, (BaseMessage)new ClusterGetConsoleOutputType(vm.getInstanceId()));
                String tempCo = B64.standard.decString((String)String.valueOf(consoleOutput.getOutput())).replaceAll("[\r\n]*", "");
                String passwordData = tempCo.replaceAll(".*<Password>", "").replaceAll("</Password>.*", "");
                if (tempCo.matches(".*<Password>[\\w=+/]*</Password>.*")) {
                    Entities.asTransaction(VmInstance.class, (Predicate)new Predicate<String>(){

                        public boolean apply(String passwordData) {
                            VmInstance vmMerge = (VmInstance)((Object)Entities.merge((Object)((Object)vm)));
                            vmMerge.updatePasswordData(passwordData);
                            return true;
                        }
                    }).apply((Object)passwordData);
                    vm.updatePasswordData(passwordData);
                }
            }
            catch (Exception e) {
                throw new ComputeException("InternalError", "Error processing request: " + e.getMessage());
            }
        }
    }

    public DescribeAvailabilityZonesResponseType DescribeAvailabilityZones(DescribeAvailabilityZonesType request) throws EucalyptusCloudException {
        ArrayList clusters;
        DescribeAvailabilityZonesResponseType reply = (DescribeAvailabilityZonesResponseType)request.getReply();
        ArrayList args = request.getAvailabilityZoneSet();
        Filter filter = Filters.generate(request.getFilterSet(), Cluster.class);
        if (Contexts.lookup().hasAdministrativePrivileges()) {
            for (String keyword : this.describeKeywords.keySet()) {
                if (!args.remove(keyword)) continue;
                reply.getAvailabilityZoneInfo().addAll((Collection)this.describeKeywords.get(keyword).get());
                return reply;
            }
        } else {
            for (String keyword : this.describeKeywords.keySet()) {
                args.remove(keyword);
            }
        }
        Clusters clusterRegistry = Clusters.getInstance();
        if (args.isEmpty()) {
            clusters = Lists.newArrayList((Iterable)clusterRegistry.listValues());
            Iterables.addAll((Collection)clusters, (Iterable)Iterables.filter((Iterable)clusterRegistry.listDisabledValues(), (Predicate)Predicates.not((Predicate)CollectionUtils.propertyPredicate((Collection)Collections2.transform((Collection)clusters, (Function)CloudMetadatas.toDisplayName()), (Function)CloudMetadatas.toDisplayName()))));
        } else {
            clusters = Lists.newArrayList();
            for (final String partitionName : request.getAvailabilityZoneSet()) {
                try {
                    clusters.add(Iterables.find((Iterable)clusterRegistry.listValues(), (Predicate)new Predicate<Cluster>(){

                        public boolean apply(Cluster input) {
                            return partitionName.equals(input.getConfiguration().getPartition());
                        }
                    }));
                }
                catch (NoSuchElementException e) {
                    try {
                        clusters.add(clusterRegistry.lookup(partitionName));
                    }
                    catch (NoSuchElementException ex) {
                        try {
                            clusters.add(clusterRegistry.lookupDisabled(partitionName));
                        }
                        catch (NoSuchElementException noSuchElementException) {}
                    }
                }
            }
        }
        for (Cluster c : Iterables.filter((Iterable)clusters, filter.asPredicate())) {
            reply.getAvailabilityZoneInfo().addAll(this.getDescriptionEntry(c));
        }
        return reply;
    }

    private List<ClusterInfoType> getDescriptionEntry(Cluster c) {
        ArrayList ret = Lists.newArrayList();
        ret.add(new ClusterInfoType(c.getConfiguration().getPartition(), (String)ClusterFunctions.STATE.apply(c)));
        NavigableSet<Object> tagList = new ConcurrentSkipListSet();
        if (tagList.size() == 1) {
            tagList = c.getNodeTags();
        } else {
            tagList.retainAll(c.getNodeTags());
        }
        return ret;
    }

    private static ClusterInfoType t(String left, String right) {
        return new ClusterInfoType(left, right);
    }

    private static ClusterInfoType s(String left, String right) {
        return new ClusterInfoType(String.format(INFO_FSTRING, left), right);
    }

    public DescribeRegionsResponseType DescribeRegions(DescribeRegionsType request) throws EucalyptusCloudException {
        DescribeRegionsResponseType reply = (DescribeRegionsResponseType)request.getReply();
        for (Class componentIdClass : ImmutableList.of(Eucalyptus.class)) {
            try {
                Component component = Components.lookup((Class)componentIdClass);
                String region = component.getComponentId().name();
                ArrayList regions = Lists.newArrayList();
                NavigableSet configs = component.services();
                if (!configs.isEmpty() && Component.State.ENABLED.equals((Object)((ServiceConfiguration)configs.first()).lookupState())) {
                    regions.add(new Region(region, ServiceUris.remotePublicify((ServiceConfiguration)((ServiceConfiguration)configs.first()), (String[])new String[0]).toASCIIString()));
                }
                Filter filter = Filters.generate(request.getFilterSet(), Region.class);
                Predicate requested = Predicates.and(ClusterEndpoint.filterByName(request.getRegions()), filter.asPredicate());
                for (Region item : Iterables.filter((Iterable)regions, (Predicate)requested)) {
                    reply.getRegionInfo().add(new RegionInfoType(item.getDisplayName(), item.getEndpointUrl()));
                }
            }
            catch (NoSuchElementException ex) {
                LOG.error((Object)ex, (Throwable)ex);
            }
        }
        return reply;
    }

    private static Predicate<Object> filterByName(final Collection<String> requestedIdentifiers) {
        return new Predicate<Object>(){

            public boolean apply(Object region) {
                return requestedIdentifiers == null || requestedIdentifiers.isEmpty() || requestedIdentifiers.contains(((Region)region).getDisplayName());
            }
        };
    }

    public static class AvailabilityZoneFilterSupport
    extends FilterSupport<Cluster> {
        public AvailabilityZoneFilterSupport() {
            super(AvailabilityZoneFilterSupport.builderFor(Cluster.class).withUnsupportedProperty("message").withUnsupportedProperty("region-name").withStringProperty("state", ClusterFunctions.STATE).withStringProperty("zone-name", (Function<Cluster, String>)CloudMetadatas.toDisplayName()));
        }
    }

    private static enum ClusterFunctions implements Function<Cluster, String>
    {
        STATE{

            public String apply(Cluster cluster) {
                return ((Cluster.State)cluster.getStateMachine().getState()).ordinal() > Cluster.State.ENABLING_ADDRS_PASS_TWO.ordinal() ? "available" : "unavailable";
            }
        };

    }

    public static class RegionFilterSupport
    extends FilterSupport<Region> {
        public RegionFilterSupport() {
            super(RegionFilterSupport.builderFor(Region.class).withStringProperty("endpoint", RegionFunctions.ENDPOINT_URL).withStringProperty("region-name", RegionFunctions.REGION_NAME));
        }
    }

    private static enum RegionFunctions implements Function<Region, String>
    {
        REGION_NAME{

            public String apply(Region region) {
                return region.getDisplayName();
            }
        }
        ,
        ENDPOINT_URL{

            public String apply(Region region) {
                return region.getEndpointUrl();
            }
        };

    }

    protected static class Region {
        private final String displayName;
        private final String endpointUrl;

        protected Region(String displayName, String endpointUrl) {
            this.displayName = displayName;
            this.endpointUrl = endpointUrl;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public String getEndpointUrl() {
            return this.endpointUrl;
        }
    }
}

