/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.cluster;

import com.eucalyptus.cluster.Clusters;
import com.eucalyptus.component.annotation.ComponentPart;
import com.eucalyptus.component.id.ClusterController;
import com.eucalyptus.http.MappingHttpRequest;
import com.eucalyptus.ws.Handlers;
import com.eucalyptus.ws.StackConfiguration;
import com.eucalyptus.ws.handlers.ClusterWsSecHandler;
import com.google.common.base.Joiner;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelFutureListener;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelHandler;

@ComponentPart(value=ClusterController.class)
public final class ClusterClientPipelineFactory
implements ChannelPipelineFactory {
    private static Logger LOG = Logger.getLogger(ClusterClientPipelineFactory.class);
    private static final Supplier<ChannelHandler> wsSecHandler = Suppliers.memoize((Supplier)ClusterWsSec.INSTANCE);
    public static final Supplier<Integer> CLUSTER_CLIENT_PERMITS = new Supplier<Integer>(){

        public Integer get() {
            return Clusters.getConfiguration().getRequestWorkers();
        }
    };
    private static final CacheLoader<InetAddress, Semaphore> loader = new CacheLoader<InetAddress, Semaphore>(){

        public Semaphore load(InetAddress key) throws Exception {
            return new Semaphore((Integer)CLUSTER_CLIENT_PERMITS.get(), true);
        }
    };
    private static final LoadingCache<InetAddress, Semaphore> counters = CacheBuilder.newBuilder().build(loader);

    public ChannelPipeline getPipeline() throws Exception {
        SimpleChannelHandler limitSockets = new SimpleChannelHandler(){
            private final String uuid = UUID.randomUUID().toString();

            public void writeRequested(ChannelHandlerContext ctx, MessageEvent e) throws Exception {
                try {
                    MappingHttpRequest message = (MappingHttpRequest)e.getMessage();
                    String logMessage = message.getMessage() != null ? message.getMessage().getClass().toString().replaceAll("^.*\\.", "") : message.toString();
                    LOG.debug((Object)Joiner.on((String)" ").join((Object)this.uuid, (Object)"writeRequested", new Object[]{ctx.getChannel(), "message", logMessage}));
                }
                catch (Exception e1) {
                    LOG.debug((Object)e1);
                }
                super.writeRequested(ctx, e);
            }

            public void connectRequested(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
                try {
                    final InetSocketAddress remoteAddress = (InetSocketAddress)e.getValue();
                    final Semaphore sem = (Semaphore)counters.getUnchecked((Object)remoteAddress.getAddress());
                    final int semAvailable = sem.availablePermits();
                    final int semQueued = sem.getQueueLength();
                    final long start = System.nanoTime();
                    sem.acquire();
                    final long waitTime = System.nanoTime();
                    e.getChannel().getCloseFuture().addListener(new ChannelFutureListener(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void operationComplete(ChannelFuture future) throws Exception {
                            try {
                                long end = System.nanoTime();
                                LOG.trace((Object)Joiner.on((String)" ").join((Object)uuid, (Object)remoteAddress, new Object[]{String.format("%d/%d+%d-queue", semAvailable, CLUSTER_CLIENT_PERMITS.get(), semQueued), String.format("%d+%d=%d-msec", TimeUnit.NANOSECONDS.toMillis(waitTime - start), TimeUnit.NANOSECONDS.toMillis(end - waitTime), TimeUnit.NANOSECONDS.toMillis(end - start))}));
                            }
                            catch (Exception e1) {
                                LOG.trace((Object)e1);
                            }
                            finally {
                                sem.release();
                            }
                        }
                    });
                }
                catch (Exception e1) {
                    LOG.trace((Object)e1);
                }
                super.connectRequested(ctx, e);
            }
        };
        ChannelPipeline pipeline = Channels.pipeline();
        for (Map.Entry e : Handlers.channelMonitors((TimeUnit)TimeUnit.SECONDS, (int)StackConfiguration.CLIENT_INTERNAL_TIMEOUT_SECS).entrySet()) {
            pipeline.addLast((String)e.getKey(), (ChannelHandler)e.getValue());
        }
        pipeline.addLast("decoder", Handlers.newHttpResponseDecoder());
        pipeline.addLast("aggregator", Handlers.newHttpChunkAggregator());
        pipeline.addLast("encoder", Handlers.httpRequestEncoder());
        pipeline.addLast("serializer", Handlers.soapMarshalling());
        pipeline.addLast("wssec", (ChannelHandler)wsSecHandler.get());
        pipeline.addLast("addressing", Handlers.newAddressingHandler((String)"EucalyptusCC#"));
        pipeline.addLast("soap", Handlers.soapHandler());
        pipeline.addLast("binding", Handlers.bindingHandler((String)"eucalyptus_ucsb_edu"));
        pipeline.addLast("gating", (ChannelHandler)limitSockets);
        return pipeline;
    }

    private static enum ClusterWsSec implements Supplier<ChannelHandler>
    {
        INSTANCE;


        public ChannelHandler get() {
            return new ClusterWsSecHandler();
        }
    }
}

