/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.cluster;

import com.eucalyptus.bootstrap.Handles;
import com.eucalyptus.cluster.Cluster;
import com.eucalyptus.cluster.ClusterConfiguration;
import com.eucalyptus.cluster.Clusters;
import com.eucalyptus.component.AbstractServiceBuilder;
import com.eucalyptus.component.ComponentId;
import com.eucalyptus.component.ComponentIds;
import com.eucalyptus.component.Faults;
import com.eucalyptus.component.Partition;
import com.eucalyptus.component.Partitions;
import com.eucalyptus.component.ServiceConfiguration;
import com.eucalyptus.component.ServiceRegistrationException;
import com.eucalyptus.component.ServiceUris;
import com.eucalyptus.component.annotation.ComponentPart;
import com.eucalyptus.component.id.ClusterController;
import com.eucalyptus.config.DeregisterClusterType;
import com.eucalyptus.config.DescribeClustersType;
import com.eucalyptus.config.ModifyClusterAttributeType;
import com.eucalyptus.config.RegisterClusterType;
import com.eucalyptus.node.Nodes;
import com.eucalyptus.records.EventRecord;
import com.eucalyptus.records.EventType;
import com.eucalyptus.records.Logs;
import java.util.NoSuchElementException;
import org.apache.log4j.Logger;

@ComponentPart(value=ClusterController.class)
@Handles(value={RegisterClusterType.class, DeregisterClusterType.class, DescribeClustersType.class, ModifyClusterAttributeType.class})
public class ClusterBuilder
extends AbstractServiceBuilder<ClusterConfiguration> {
    static Logger LOG = Logger.getLogger(ClusterBuilder.class);

    public boolean checkAdd(String partition, String name, String host, Integer port) throws ServiceRegistrationException {
        try {
            Partition part = Partitions.lookup((ServiceConfiguration)this.newInstance(partition, name, host, port));
            part.syncKeysToDisk();
        }
        catch (Exception ex) {
            Logs.extreme().error((Object)ex, (Throwable)ex);
            throw new ServiceRegistrationException(String.format("Unexpected error caused cluster registration to fail for: partition=%s name=%s host=%s port=%d", partition, name, host, port), (Throwable)ex);
        }
        return super.checkAdd(partition, name, host, port);
    }

    public ClusterConfiguration newInstance() {
        return new ClusterConfiguration();
    }

    public ClusterConfiguration newInstance(String partition, String name, String host, Integer port) {
        return new ClusterConfiguration(partition, name, host, port);
    }

    public ComponentId getComponentId() {
        return ComponentIds.lookup(ClusterController.class);
    }

    public void fireStart(ServiceConfiguration config) throws ServiceRegistrationException {
        LOG.info((Object)("Starting cluster: " + config));
        EventRecord.here(ClusterBuilder.class, (EventType)EventType.COMPONENT_SERVICE_START, (String[])new String[]{config.getComponentId().name(), config.getName(), ServiceUris.remote((ServiceConfiguration)config, (String[])new String[0]).toASCIIString()}).info();
        try {
            if (!Clusters.getInstance().contains(config.getName())) {
                Cluster newCluster = new Cluster((ClusterConfiguration)config);
                newCluster.start();
            } else {
                try {
                    Cluster newCluster = (Cluster)Clusters.getInstance().lookupDisabled(config.getName());
                    Clusters.getInstance().deregister(config.getName());
                    newCluster.start();
                }
                catch (NoSuchElementException ex) {
                    Cluster newCluster = (Cluster)Clusters.getInstance().lookup(config.getName());
                    Clusters.getInstance().deregister(config.getName());
                    newCluster.start();
                }
            }
        }
        catch (NoSuchElementException ex) {
            LOG.error((Object)ex, (Throwable)ex);
        }
    }

    public void fireEnable(ServiceConfiguration config) throws ServiceRegistrationException {
        block4: {
            LOG.info((Object)("Enabling cluster: " + config));
            EventRecord.here(ClusterBuilder.class, (EventType)EventType.COMPONENT_SERVICE_ENABLED, (String[])new String[]{config.getComponentId().name(), config.getName(), ServiceUris.remote((ServiceConfiguration)config, (String[])new String[0]).toASCIIString()}).info();
            Cluster newCluster = null;
            try {
                try {
                    newCluster = (Cluster)Clusters.getInstance().lookupDisabled(config.getName());
                    newCluster.enable();
                }
                catch (NoSuchElementException ex) {
                    newCluster = (Cluster)Clusters.getInstance().lookup(config.getName());
                    newCluster.enable();
                }
            }
            catch (Exception ex) {
                LOG.error((Object)ex);
                if (newCluster == null) break block4;
                Nodes.clusterCleanup(newCluster, ex);
                throw ex;
            }
        }
    }

    public void fireDisable(ServiceConfiguration config) throws ServiceRegistrationException {
        LOG.info((Object)("Disabling cluster: " + config));
        EventRecord.here(ClusterBuilder.class, (EventType)EventType.COMPONENT_SERVICE_DISABLED, (String[])new String[]{config.getComponentId().name(), config.getName(), ServiceUris.remote((ServiceConfiguration)config, (String[])new String[0]).toASCIIString()}).info();
        try {
            if (Clusters.getInstance().contains(config.getName())) {
                try {
                    Cluster newCluster = (Cluster)Clusters.getInstance().lookup(config.getName());
                    newCluster.disable();
                }
                catch (NoSuchElementException ex) {
                    Cluster newCluster = (Cluster)Clusters.getInstance().lookupDisabled(config.getName());
                    newCluster.disable();
                }
            }
        }
        catch (NoSuchElementException ex) {
            LOG.error((Object)ex, (Throwable)ex);
        }
    }

    public void fireStop(ServiceConfiguration config) throws ServiceRegistrationException {
        try {
            LOG.info((Object)("Tearing down cluster: " + config));
            Cluster cluster = (Cluster)Clusters.getInstance().lookupDisabled(config.getName());
            EventRecord.here(ClusterBuilder.class, (EventType)EventType.COMPONENT_SERVICE_STOPPED, (String[])new String[]{config.getComponentId().name(), config.getName(), ServiceUris.remote((ServiceConfiguration)config, (String[])new String[0]).toASCIIString()}).info();
            cluster.stop();
        }
        catch (NoSuchElementException ex) {
            LOG.error((Object)ex, (Throwable)ex);
        }
        catch (Exception ex) {
            LOG.error((Object)ex, (Throwable)ex);
        }
    }

    public void fireCheck(ServiceConfiguration config) throws ServiceRegistrationException {
        Cluster cluster = Clusters.lookup(config);
        try {
            try {
                cluster.check();
            }
            catch (NoSuchElementException ex) {
                throw Faults.failure((ServiceConfiguration)config, (Throwable[])new Throwable[]{ex});
            }
            catch (IllegalStateException ex) {
                Logs.exhaust().error((Object)ex, (Throwable)ex);
                throw Faults.failure((ServiceConfiguration)config, (Throwable[])new Throwable[]{ex});
            }
            catch (Exception ex) {
                Logs.exhaust().error((Object)ex, (Throwable)ex);
                throw Faults.failure((ServiceConfiguration)config, (Throwable[])new Throwable[]{ex});
            }
        }
        catch (Faults.CheckException e) {
            Nodes.clusterCleanup(cluster, (Exception)((Object)e));
            throw e;
        }
    }
}

