/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.cluster;

import com.eucalyptus.auth.principal.Principals;
import com.eucalyptus.bootstrap.Bootstrap;
import com.eucalyptus.bootstrap.Hosts;
import com.eucalyptus.cluster.ClusterConfiguration;
import com.eucalyptus.cluster.ClusterState;
import com.eucalyptus.cluster.Clusters;
import com.eucalyptus.cluster.ResourceState;
import com.eucalyptus.cluster.callback.ClusterCertsCallback;
import com.eucalyptus.cluster.callback.LogDataCallback;
import com.eucalyptus.cluster.callback.NetworkStateCallback;
import com.eucalyptus.cluster.callback.PublicAddressStateCallback;
import com.eucalyptus.cluster.callback.ResourceStateCallback;
import com.eucalyptus.cluster.callback.VmStateCallback;
import com.eucalyptus.component.Component;
import com.eucalyptus.component.ComponentId;
import com.eucalyptus.component.ComponentIds;
import com.eucalyptus.component.Components;
import com.eucalyptus.component.Faults;
import com.eucalyptus.component.Partition;
import com.eucalyptus.component.Partitions;
import com.eucalyptus.component.ServiceConfiguration;
import com.eucalyptus.component.ServiceConfigurations;
import com.eucalyptus.component.ServiceRegistrationException;
import com.eucalyptus.component.ServiceUris;
import com.eucalyptus.component.id.ClusterController;
import com.eucalyptus.compute.common.CloudMetadata;
import com.eucalyptus.compute.common.CloudMetadatas;
import com.eucalyptus.context.Contexts;
import com.eucalyptus.context.ServiceStateException;
import com.eucalyptus.crypto.util.B64;
import com.eucalyptus.crypto.util.PEMFiles;
import com.eucalyptus.empyrean.DescribeServicesResponseType;
import com.eucalyptus.empyrean.DescribeServicesType;
import com.eucalyptus.empyrean.DisableServiceType;
import com.eucalyptus.empyrean.EnableServiceType;
import com.eucalyptus.empyrean.ServiceId;
import com.eucalyptus.empyrean.ServiceStatusType;
import com.eucalyptus.empyrean.ServiceTransitionType;
import com.eucalyptus.empyrean.StartServiceType;
import com.eucalyptus.entities.Entities;
import com.eucalyptus.event.ClockTick;
import com.eucalyptus.event.Event;
import com.eucalyptus.event.EventListener;
import com.eucalyptus.event.Hertz;
import com.eucalyptus.event.ListenerRegistry;
import com.eucalyptus.event.Listeners;
import com.eucalyptus.records.EventRecord;
import com.eucalyptus.records.EventType;
import com.eucalyptus.records.Logs;
import com.eucalyptus.system.Threads;
import com.eucalyptus.util.Callback;
import com.eucalyptus.util.Classes;
import com.eucalyptus.util.Exceptions;
import com.eucalyptus.util.FullName;
import com.eucalyptus.util.HasFullName;
import com.eucalyptus.util.LogUtil;
import com.eucalyptus.util.OwnerFullName;
import com.eucalyptus.util.TypeMappers;
import com.eucalyptus.util.async.AsyncRequests;
import com.eucalyptus.util.async.CheckedListenableFuture;
import com.eucalyptus.util.async.ConnectionException;
import com.eucalyptus.util.async.FailedRequestException;
import com.eucalyptus.util.async.RemoteCallback;
import com.eucalyptus.util.async.SubjectMessageCallback;
import com.eucalyptus.util.async.SubjectRemoteCallbackFactory;
import com.eucalyptus.util.fsm.AbstractTransitionAction;
import com.eucalyptus.util.fsm.Automata;
import com.eucalyptus.util.fsm.HasStateMachine;
import com.eucalyptus.util.fsm.StateMachine;
import com.eucalyptus.util.fsm.StateMachineBuilder;
import com.eucalyptus.util.fsm.TransitionAction;
import com.eucalyptus.util.fsm.Transitions;
import com.eucalyptus.vm.MigrationState;
import com.eucalyptus.vm.VmInstance;
import com.eucalyptus.vm.VmInstances;
import com.eucalyptus.vmtypes.VmType;
import com.eucalyptus.vmtypes.VmTypes;
import com.eucalyptus.ws.WebServicesException;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Strings;
import com.google.common.collect.ForwardingMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.ObjectArrays;
import edu.ucsb.eucalyptus.cloud.NodeInfo;
import edu.ucsb.eucalyptus.msgs.BaseMessage;
import edu.ucsb.eucalyptus.msgs.ClusterMigrateInstancesType;
import edu.ucsb.eucalyptus.msgs.NodeCertInfo;
import edu.ucsb.eucalyptus.msgs.NodeLogInfo;
import java.io.IOException;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.NoSuchElementException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.annotation.Nullable;
import org.apache.log4j.Logger;

public class Cluster
implements CloudMetadata.AvailabilityZoneMetadata,
HasFullName<Cluster>,
EventListener,
HasStateMachine<Cluster, State, Transition> {
    private static Logger LOG = Logger.getLogger(Cluster.class);
    private final StateMachine<Cluster, State, Transition> stateMachine;
    private final ClusterConfiguration configuration;
    private final ConcurrentNavigableMap<String, NodeInfo> nodeMap;
    private final Map<String, NodeInfo> nodeHostAddrMap = new ForwardingMap<String, NodeInfo>(){

        protected Map<String, NodeInfo> delegate() {
            return Cluster.this.nodeMap;
        }

        public boolean containsKey(Object keyObject) {
            return this.delegate().containsKey(this.findRealKey(keyObject));
        }

        public NodeInfo get(Object key) {
            return (NodeInfo)this.delegate().get(this.findRealKey(key));
        }

        public String findRealKey(Object keyObject) {
            if (keyObject instanceof String) {
                String key = (String)keyObject;
                for (String serviceTag : this.delegate().keySet()) {
                    try {
                        URI tag = new URI(serviceTag);
                        String host = tag.getHost();
                        if (host != null && host.equals(key)) {
                            return serviceTag;
                        }
                        InetAddress addr = InetAddress.getByName(host);
                        String hostAddr = addr.getHostAddress();
                        if (hostAddr == null || !hostAddr.equals(key)) continue;
                        return serviceTag;
                    }
                    catch (UnknownHostException ex) {
                        LOG.debug((Object)ex);
                    }
                    catch (URISyntaxException ex) {
                        LOG.debug((Object)ex);
                    }
                }
                return key;
            }
            return "" + keyObject;
        }
    };
    private final BlockingQueue<Throwable> pendingErrors = new LinkedBlockingDeque<Throwable>();
    private final ClusterState state;
    private final ResourceState nodeState;
    private NodeLogInfo lastLog = new NodeLogInfo();
    private boolean hasClusterCert = false;
    private boolean hasNodeCert = false;
    private final ReadWriteLock gateLock = new ReentrantReadWriteLock();
    private static final List<Class<? extends Exception>> communicationErrors = Lists.newArrayList((Object[])new Class[]{ConnectionException.class, IOException.class, WebServicesException.class});
    private static final List<Class<? extends Exception>> executionErrors = Lists.newArrayList((Object[])new Class[]{UndeclaredThrowableException.class, ExecutionException.class});
    private static final State[] PATH_NOTREADY = new State[]{State.PENDING, State.AUTHENTICATING, State.STARTING, State.STARTING_NOTREADY, State.NOTREADY};
    private static final State[] PATH_DISABLED = (State[])ObjectArrays.concat((Object[])PATH_NOTREADY, (Object)((Object)State.DISABLED));
    private static final State[] PATH_ENABLED = new State[]{State.PENDING, State.AUTHENTICATING, State.STARTING, State.STARTING_NOTREADY, State.NOTREADY, State.DISABLED, State.ENABLING, State.ENABLING_RESOURCES, State.ENABLING_NET, State.ENABLING_VMS, State.ENABLING_ADDRS, State.ENABLING_VMS_PASS_TWO, State.ENABLING_ADDRS_PASS_TWO, State.ENABLED};
    private static final State[] PATH_ENABLED_CHECK = new State[]{State.ENABLED, State.ENABLED_SERVICE_CHECK, State.ENABLED_ADDRS, State.ENABLED_RSC, State.ENABLED_NET, State.ENABLED_VMS, State.ENABLED};
    private final AtomicBoolean logUpdate = new AtomicBoolean(false);
    private final Predicate<VmInstance> filterPartition = new Predicate<VmInstance>(){

        public boolean apply(@Nullable VmInstance input) {
            return input.getPartition().equals(Cluster.this.getPartition()) && MigrationState.isMigrating(input);
        }
    };

    private static void fireCallback(Cluster parent, SubjectRemoteCallbackFactory<RemoteCallback, Cluster> factory, Callback.Completion transitionCallback) {
        Cluster.fireCallback(parent, (ServiceConfiguration)parent.getConfiguration(), true, factory, transitionCallback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void fireCallback(Cluster parent, ServiceConfiguration config, boolean doCoordinatorCheck, SubjectRemoteCallbackFactory<RemoteCallback, Cluster> factory, Callback.Completion transitionCallback) {
        block12: {
            RemoteCallback messageCallback = null;
            try {
                if (!doCoordinatorCheck || Cluster.checkCoordinator(transitionCallback)) {
                    try {
                        messageCallback = (RemoteCallback)factory.newInstance();
                        try {
                            BaseMessage baseMessage = AsyncRequests.newRequest((RemoteCallback)messageCallback).sendSync(config);
                            transitionCallback.fire();
                            if (Logs.isExtrrreeeme()) {
                                Logs.extreme().debug((Object)baseMessage);
                            }
                            break block12;
                        }
                        catch (Exception t) {
                            if (!parent.swallowException(t)) {
                                transitionCallback.fireException(Exceptions.unwrapCause((Throwable)t));
                                break block12;
                            }
                            transitionCallback.fire();
                        }
                    }
                    catch (CancellationException ex) {
                        transitionCallback.fire();
                    }
                    catch (Exception ex) {
                        transitionCallback.fireException((Throwable)ex);
                    }
                    break block12;
                }
                transitionCallback.fire();
            }
            finally {
                if (!transitionCallback.isDone()) {
                    LOG.debug((Object)(parent.getFullName() + " transition fell through w/o completing: " + messageCallback));
                    Logs.extreme().debug((Object)Exceptions.toUndeclared((String)(parent.getFullName() + " transition fell through w/o completing: " + messageCallback), (Throwable[])new Throwable[0]));
                    transitionCallback.fire();
                }
            }
        }
    }

    private static boolean checkCoordinator(Callback.Completion transitionCallback) {
        boolean coordinator = false;
        try {
            coordinator = Hosts.isCoordinator();
            if (!coordinator) {
                transitionCallback.fire();
                return false;
            }
        }
        catch (Exception ex) {
            transitionCallback.fire();
            return false;
        }
        return coordinator;
    }

    protected Cluster(ClusterConfiguration configuration, Void nothing) {
        this.configuration = configuration;
        this.state = null;
        this.nodeState = null;
        this.nodeMap = new ConcurrentSkipListMap<String, NodeInfo>();
        this.stateMachine = null;
    }

    public Cluster(ClusterConfiguration configuration) {
        this.configuration = configuration;
        this.state = new ClusterState(configuration.getName());
        this.nodeState = new ResourceState(configuration.getName());
        this.nodeMap = new ConcurrentSkipListMap<String, NodeInfo>();
        this.stateMachine = new StateMachineBuilder<Cluster, State, Transition>(this, State.PENDING){
            {
                TransitionAction noop = Transitions.noop();
                this.in(State.DISABLED).run((Predicate)ZoneRegistration.DEREGISTER);
                this.in(State.NOTREADY).run((Predicate)ServiceStateDispatch.DISABLED);
                this.in(State.ENABLED).run((Predicate)ZoneRegistration.REGISTER);
                this.from(State.BROKEN).to((Automata.State)State.PENDING).error((Automata.State)State.BROKEN).on((Automata.Transition)Transition.RESTART_BROKEN).run(noop);
                this.from(State.STOPPED).to((Automata.State)State.PENDING).error((Automata.State)State.PENDING).on((Automata.Transition)Transition.PRESTART).run(noop);
                this.from(State.PENDING).to((Automata.State)State.AUTHENTICATING).error((Automata.State)State.PENDING).on((Automata.Transition)Transition.AUTHENTICATE).run((Function)LogRefresh.CERTS);
                this.from(State.AUTHENTICATING).to((Automata.State)State.STARTING).error((Automata.State)State.PENDING).on((Automata.Transition)Transition.START).run(noop);
                this.from(State.STARTING).to((Automata.State)State.STARTING_NOTREADY).error((Automata.State)State.PENDING).on((Automata.Transition)Transition.START_CHECK).run((Function)Refresh.SERVICEREADY);
                this.from(State.STARTING_NOTREADY).to((Automata.State)State.NOTREADY).error((Automata.State)State.PENDING).on((Automata.Transition)Transition.STARTING_SERVICES).run((Function)Refresh.SERVICEREADY);
                this.from(State.NOTREADY).to((Automata.State)State.DISABLED).error((Automata.State)State.NOTREADY).on((Automata.Transition)Transition.NOTREADYCHECK).run((Function)Refresh.SERVICEREADY);
                this.from(State.DISABLED).to((Automata.State)State.DISABLED).error((Automata.State)State.NOTREADY).on((Automata.Transition)Transition.DISABLEDCHECK).addListener((Callback)ErrorStateListeners.FLUSHPENDING).run((Function)Refresh.SERVICEREADY);
                this.from(State.DISABLED).to((Automata.State)State.ENABLING).error((Automata.State)State.DISABLED).on((Automata.Transition)Transition.ENABLE).run((Predicate)ServiceStateDispatch.ENABLED);
                this.from(State.DISABLED).to((Automata.State)State.STOPPED).error((Automata.State)State.PENDING).on((Automata.Transition)Transition.STOP).run(noop);
                this.from(State.ENABLED).to((Automata.State)State.DISABLED).error((Automata.State)State.NOTREADY).on((Automata.Transition)Transition.DISABLE).run((Predicate)ServiceStateDispatch.DISABLED);
                this.from(State.ENABLING).to((Automata.State)State.ENABLING_RESOURCES).error((Automata.State)State.NOTREADY).on((Automata.Transition)Transition.ENABLING_RESOURCES).run((Function)Refresh.RESOURCES);
                this.from(State.ENABLING_RESOURCES).to((Automata.State)State.ENABLING_NET).error((Automata.State)State.NOTREADY).on((Automata.Transition)Transition.ENABLING_NET).run((Function)Refresh.NETWORKS);
                this.from(State.ENABLING_NET).to((Automata.State)State.ENABLING_VMS).error((Automata.State)State.NOTREADY).on((Automata.Transition)Transition.ENABLING_VMS).run((Function)Refresh.INSTANCES);
                this.from(State.ENABLING_VMS).to((Automata.State)State.ENABLING_ADDRS).error((Automata.State)State.NOTREADY).on((Automata.Transition)Transition.ENABLING_ADDRS).run((Function)Refresh.ADDRESSES);
                this.from(State.ENABLING_ADDRS).to((Automata.State)State.ENABLING_VMS_PASS_TWO).error((Automata.State)State.NOTREADY).on((Automata.Transition)Transition.ENABLING_VMS_PASS_TWO).run((Function)Refresh.INSTANCES);
                this.from(State.ENABLING_VMS_PASS_TWO).to((Automata.State)State.ENABLING_ADDRS_PASS_TWO).error((Automata.State)State.NOTREADY).on((Automata.Transition)Transition.ENABLING_ADDRS_PASS_TWO).run((Function)Refresh.ADDRESSES);
                this.from(State.ENABLING_ADDRS_PASS_TWO).to((Automata.State)State.ENABLED).error((Automata.State)State.NOTREADY).on((Automata.Transition)Transition.ENABLING_ADDRS_PASS_TWO).run((Function)Refresh.ADDRESSES);
                this.from(State.ENABLED).to((Automata.State)State.ENABLED_SERVICE_CHECK).error((Automata.State)State.NOTREADY).on((Automata.Transition)Transition.ENABLED_SERVICES).run((Function)Refresh.SERVICEREADY);
                this.from(State.ENABLED_SERVICE_CHECK).to((Automata.State)State.ENABLED_ADDRS).error((Automata.State)State.NOTREADY).on((Automata.Transition)Transition.ENABLED_ADDRS).run((Function)Refresh.ADDRESSES);
                this.from(State.ENABLED_ADDRS).to((Automata.State)State.ENABLED_RSC).error((Automata.State)State.NOTREADY).on((Automata.Transition)Transition.ENABLED_RSC).run((Function)Refresh.RESOURCES);
                this.from(State.ENABLED_RSC).to((Automata.State)State.ENABLED_NET).error((Automata.State)State.NOTREADY).on((Automata.Transition)Transition.ENABLED_NET).run((Function)Refresh.NETWORKS);
                this.from(State.ENABLED_NET).to((Automata.State)State.ENABLED_VMS).error((Automata.State)State.NOTREADY).on((Automata.Transition)Transition.ENABLED_VMS).run((Function)Refresh.INSTANCES);
                this.from(State.ENABLED_VMS).to((Automata.State)State.ENABLED).error((Automata.State)State.NOTREADY).on((Automata.Transition)Transition.ENABLED).run((Callback)ErrorStateListeners.FLUSHPENDING);
            }
        }.newAtomicMarkedState();
    }

    public void clearExceptions() {
        if (!this.pendingErrors.isEmpty()) {
            ArrayList currentErrors = Lists.newArrayList();
            this.pendingErrors.drainTo(currentErrors);
            for (Throwable t : currentErrors) {
                Throwable filtered = Exceptions.filterStackTrace((Throwable)t);
                LOG.debug((Object)(this.configuration + ": Clearing error: " + filtered.getMessage()), filtered);
            }
        } else {
            LOG.debug((Object)(this.configuration + ": no pending errors to clear."));
        }
    }

    private void fireClockTick(Hertz tick) {
        try {
            boolean initialized;
            Component.State systemState;
            try {
                systemState = this.configuration.lookupState();
            }
            catch (NoSuchElementException ex1) {
                this.stop();
                return;
            }
            boolean bl = initialized = systemState.ordinal() > Component.State.LOADED.ordinal();
            if (!this.stateMachine.isBusy()) {
                Callable<CheckedListenableFuture<Cluster>> transition = null;
                switch ((State)this.stateMachine.getState()) {
                    case PENDING: 
                    case AUTHENTICATING: 
                    case STARTING: {
                        if (!tick.isAsserted(Clusters.getConfiguration().getPendingInterval().longValue())) break;
                        transition = this.startingTransition();
                        break;
                    }
                    case NOTREADY: {
                        if (!initialized || !tick.isAsserted(Clusters.getConfiguration().getNotreadyInterval().longValue())) break;
                        transition = this.notreadyTransition();
                        break;
                    }
                    case DISABLED: {
                        if (initialized && tick.isAsserted(Clusters.getConfiguration().getDisabledInterval().longValue()) && (Component.State.DISABLED.equals((Object)systemState) || Component.State.NOTREADY.equals((Object)systemState))) {
                            transition = this.disabledTransition();
                            break;
                        }
                        if (!initialized || !tick.isAsserted(Clusters.getConfiguration().getDisabledInterval().longValue()) || !Component.State.ENABLED.equals((Object)systemState)) break;
                        transition = this.enablingTransition();
                        break;
                    }
                    case ENABLING: 
                    case ENABLING_RESOURCES: 
                    case ENABLING_NET: 
                    case ENABLING_VMS: 
                    case ENABLING_ADDRS: 
                    case ENABLING_VMS_PASS_TWO: 
                    case ENABLING_ADDRS_PASS_TWO: {
                        break;
                    }
                    case ENABLED: 
                    case ENABLED_ADDRS: 
                    case ENABLED_RSC: 
                    case ENABLED_NET: 
                    case ENABLED_VMS: 
                    case ENABLED_SERVICE_CHECK: {
                        if (!initialized || !tick.isAsserted(VmInstances.VOLATILE_STATE_INTERVAL_SEC.longValue()) || !Component.State.ENABLED.equals((Object)this.configuration.lookupState())) break;
                        Refresh.VOLATILEINSTANCES.fire(this);
                        break;
                    }
                }
            }
        }
        catch (Exception ex) {
            LOG.error((Object)ex, (Throwable)ex);
        }
    }

    private Callable<CheckedListenableFuture<Cluster>> disableTransition() {
        if (((State)this.stateMachine.getState()).ordinal() >= State.ENABLED.ordinal()) {
            return Automata.sequenceTransitions((HasStateMachine)this, (Automata.State[])new State[]{State.ENABLED, State.DISABLED});
        }
        return Automata.sequenceTransitions((HasStateMachine)this, (Automata.State[])PATH_DISABLED);
    }

    private Callable<CheckedListenableFuture<Cluster>> enabledTransition() {
        if (((State)this.stateMachine.getState()).ordinal() >= State.ENABLED.ordinal()) {
            return Automata.sequenceTransitions((HasStateMachine)this, (Automata.State[])PATH_ENABLED_CHECK);
        }
        return Automata.sequenceTransitions((HasStateMachine)this, (Automata.State[])PATH_ENABLED);
    }

    private Callable<CheckedListenableFuture<Cluster>> enablingTransition() {
        return Automata.sequenceTransitions((HasStateMachine)this, (Automata.State[])PATH_ENABLED);
    }

    private Callable<CheckedListenableFuture<Cluster>> disabledTransition() {
        if (((State)this.stateMachine.getState()).ordinal() >= State.ENABLED.ordinal()) {
            return Automata.sequenceTransitions((HasStateMachine)this, (Automata.State[])((Automata.State[])ObjectArrays.concat((Object[])PATH_ENABLED_CHECK, (Object)((Object)State.DISABLED))));
        }
        return Automata.sequenceTransitions((HasStateMachine)this, (Automata.State[])((Automata.State[])ObjectArrays.concat((Object[])PATH_DISABLED, (Object)((Object)State.DISABLED))));
    }

    private Callable<CheckedListenableFuture<Cluster>> notreadyTransition() {
        if (((State)this.stateMachine.getState()).ordinal() >= State.ENABLED.ordinal()) {
            return Automata.sequenceTransitions((HasStateMachine)this, (Automata.State[])((Automata.State[])ObjectArrays.concat((Object[])PATH_ENABLED_CHECK, (Object)((Object)State.DISABLED))));
        }
        return Automata.sequenceTransitions((HasStateMachine)this, (Automata.State[])PATH_DISABLED);
    }

    private Callable<CheckedListenableFuture<Cluster>> startingTransition() {
        return Automata.sequenceTransitions((HasStateMachine)this, (Automata.State[])PATH_DISABLED);
    }

    public Boolean isReady() {
        return this.hasClusterCert && this.hasNodeCert && Bootstrap.isFinished() != false;
    }

    public X509Certificate getClusterCertificate() {
        return Partitions.lookup((ServiceConfiguration)this.configuration).getCertificate();
    }

    public X509Certificate getNodeCertificate() {
        return Partitions.lookup((ServiceConfiguration)this.configuration).getNodeCertificate();
    }

    public String getName() {
        return this.configuration.getName();
    }

    public NavigableSet<String> getNodeTags() {
        return this.nodeMap.navigableKeySet();
    }

    public NodeInfo getNode(String serviceTag) {
        if (this.nodeMap.containsKey(serviceTag)) {
            return (NodeInfo)this.nodeMap.get(serviceTag);
        }
        try {
            URI tag = new URI(serviceTag);
            String host = tag.getHost();
            InetAddress addr = InetAddress.getByName(host);
            String hostAddr = addr.getHostAddress();
            String altTag = serviceTag.replace(host, hostAddr);
            if (this.nodeMap.containsKey(altTag)) {
                return (NodeInfo)this.nodeMap.get(altTag);
            }
            return null;
        }
        catch (Exception ex) {
            return null;
        }
    }

    public int compareTo(Cluster that) {
        return this.getName().compareTo(that.getName());
    }

    public ClusterConfiguration getConfiguration() {
        return this.configuration;
    }

    public ClusterState getState() {
        return this.state;
    }

    public ResourceState getNodeState() {
        return this.nodeState;
    }

    public void start() throws ServiceRegistrationException {
        try {
            Clusters.getInstance().registerDisabled(this);
            if (!State.DISABLED.equals(this.stateMachine.getState())) {
                Callable<CheckedListenableFuture<Cluster>> trans = this.startingTransition();
                Throwable lastEx = null;
                for (int i = 0; i < Clusters.getConfiguration().getStartupSyncRetries(); ++i) {
                    try {
                        trans.call().get();
                        lastEx = null;
                        break;
                    }
                    catch (InterruptedException ex) {
                        Thread.currentThread().interrupt();
                        continue;
                    }
                    catch (ServiceRegistrationException ex) {
                        lastEx = ex;
                        Logs.extreme().debug((Object)ex, (Throwable)ex);
                        continue;
                    }
                    catch (Exception ex) {
                        lastEx = ex;
                        Logs.extreme().debug((Object)ex, (Throwable)ex);
                    }
                }
                Listeners.register(Hertz.class, (EventListener)this);
            }
        }
        catch (NoSuchElementException ex) {
            Logs.extreme().debug((Object)ex, (Throwable)ex);
            throw ex;
        }
        catch (Exception ex) {
            Logs.extreme().debug((Object)ex, (Throwable)ex);
            throw new ServiceRegistrationException("Failed to call start() on cluster " + this.configuration + " because of: " + ex.getMessage(), (Throwable)ex);
        }
    }

    public void enable() throws ServiceRegistrationException {
        if (State.ENABLING.ordinal() > ((State)this.stateMachine.getState()).ordinal()) {
            try {
                Callable<CheckedListenableFuture<Cluster>> trans = this.enablingTransition();
                RuntimeException fail = null;
                for (int i = 0; i < Clusters.getConfiguration().getStartupSyncRetries(); ++i) {
                    try {
                        trans.call().get();
                        fail = null;
                        break;
                    }
                    catch (Exception ex) {
                        try {
                            TimeUnit.SECONDS.sleep(1L);
                        }
                        catch (Exception ex1) {
                            LOG.error((Object)ex1, (Throwable)ex1);
                        }
                        fail = Exceptions.toUndeclared((Throwable)ex);
                        continue;
                    }
                }
                if (fail != null) {
                    throw fail;
                }
            }
            catch (Exception ex) {
                Logs.extreme().debug((Object)ex, (Throwable)ex);
                throw new ServiceRegistrationException("Failed to call enable() on cluster " + this.configuration + " because of: " + ex.getMessage(), (Throwable)ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disable() throws ServiceRegistrationException {
        try {
            if (State.NOTREADY.equals(this.getStateMachine().getState())) {
                ((CheckedListenableFuture)Automata.sequenceTransitions((HasStateMachine)this, (Automata.State[])new State[]{State.NOTREADY, State.DISABLED}).call()).get();
            } else if (State.ENABLED.equals(this.getStateMachine().getState())) {
                ((CheckedListenableFuture)Automata.sequenceTransitions((HasStateMachine)this, (Automata.State[])new State[]{State.ENABLED, State.DISABLED}).call()).get();
            }
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
        catch (Exception ex) {
            Logs.extreme().debug((Object)ex, (Throwable)ex);
        }
        finally {
            try {
                Clusters.getInstance().disable(this.getName());
            }
            catch (Exception ex) {}
        }
    }

    public void stop() throws ServiceRegistrationException {
        try {
            ((CheckedListenableFuture)Automata.sequenceTransitions((HasStateMachine)this, (Automata.State[])new State[]{State.DISABLED, State.STOPPED}).call()).get();
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
        catch (Exception ex) {
            Logs.extreme().debug((Object)ex, (Throwable)ex);
            throw new ServiceRegistrationException("Failed to call stop() on cluster " + this.configuration + " because of: " + ex.getMessage(), (Throwable)ex);
        }
        finally {
            try {
                ListenerRegistry.getInstance().deregister(Hertz.class, (EventListener)this);
                ListenerRegistry.getInstance().deregister(ClockTick.class, (EventListener)this);
            }
            catch (Exception ex) {}
            Clusters.getInstance().deregister(this.getName());
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.configuration == null ? 0 : this.configuration.hashCode());
        result = 31 * result + (this.state == null ? 0 : this.state.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Cluster other = (Cluster)obj;
        if (this.configuration == null ? other.configuration != null : !this.configuration.equals(other.configuration)) {
            return false;
        }
        return !(this.state == null ? other.state != null : !this.state.equals(other.state));
    }

    public URI getUri() {
        return ServiceUris.remote((ServiceConfiguration)this.configuration, (String[])new String[0]);
    }

    public String getHostName() {
        return this.configuration.getHostName();
    }

    public String getInsecureServicePath() {
        return this.configuration.getInsecureServicePath();
    }

    public Integer getPort() {
        return this.configuration.getPort();
    }

    public String getServicePath() {
        return this.configuration.getServicePath();
    }

    public ThreadFactory getThreadFactory() {
        return Threads.lookup(ClusterController.class, Cluster.class, (String)this.getFullName().toString());
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("Cluster ").append(this.configuration).append('\n');
        buf.append("Cluster ").append(this.configuration.getName());
        for (NodeInfo node : this.nodeMap.values()) {
            buf.append("Cluster ").append(this.configuration.getName()).append(" node=").append(node).append('\n');
        }
        for (VmType type : VmTypes.list()) {
            ResourceState.VmTypeAvailability avail = this.nodeState.getAvailability(type.getName());
            buf.append("Cluster ").append(this.configuration.getName()).append(" node=").append(avail).append('\n');
        }
        return buf.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NodeLogInfo getLastLog() {
        block0: {
            if (!this.logUpdate.compareAndSet(false, true)) break block0;
            Cluster self = this;
            this.logUpdate.set(false);
        }
        return this.lastLog;
    }

    public void clearLogPending() {
        this.logUpdate.set(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NodeLogInfo getNodeLog(final String nodeIp) {
        NodeInfo nodeInfo;
        block1: {
            nodeInfo = (NodeInfo)Iterables.find(this.nodeMap.values(), (Predicate)new Predicate<NodeInfo>(){

                public boolean apply(NodeInfo arg0) {
                    return nodeIp.equals(arg0.getName());
                }
            });
            if (nodeInfo == null) {
                throw new NoSuchElementException("Error obtaining node log files for: " + nodeIp);
            }
            if (!this.logUpdate.compareAndSet(false, true)) break block1;
            Cluster self = this;
            this.logUpdate.set(false);
        }
        return nodeInfo.getLogs();
    }

    public void setLastLog(NodeLogInfo lastLog) {
        this.lastLog = lastLog;
    }

    public boolean checkCerts(NodeCertInfo certs) {
        if (certs == null || certs.getCcCert() == null || certs.getNcCert() == null) {
            return false;
        }
        X509Certificate clusterx509 = PEMFiles.getCert((byte[])B64.standard.dec((String)certs.getCcCert()));
        X509Certificate nodex509 = PEMFiles.getCert((byte[])B64.standard.dec((String)certs.getNcCert()));
        if ("self".equals(certs.getServiceTag()) || certs.getServiceTag() == null) {
            this.hasClusterCert = this.checkCerts(this.getClusterCertificate(), clusterx509);
            return this.hasClusterCert && (this.hasNodeCert = this.checkCerts(this.getNodeCertificate(), nodex509));
        }
        if (this.nodeMap.containsKey(certs.getServiceTag())) {
            NodeInfo nodeInfo = (NodeInfo)this.nodeMap.get(certs.getServiceTag());
            nodeInfo.setHasClusterCert(Boolean.valueOf(this.checkCerts(this.getClusterCertificate(), clusterx509)));
            nodeInfo.setHasNodeCert(Boolean.valueOf(this.checkCerts(this.getNodeCertificate(), nodex509)));
            return nodeInfo.getHasClusterCert() != false && nodeInfo.getHasNodeCert() != false;
        }
        LOG.error((Object)("Cluster " + this.getName() + " failed to find cluster/node info for service tag: " + certs.getServiceTag()));
        return false;
    }

    private boolean checkCerts(X509Certificate realx509, X509Certificate msgx509) {
        if (realx509 != null) {
            Boolean match = realx509.equals(msgx509);
            EventRecord.here(Cluster.class, (EventType)EventType.CLUSTER_CERT, (String[])new String[]{this.getName(), realx509.getSubjectX500Principal().getName(), match.toString()}).info();
            if (!match.booleanValue()) {
                LOG.warn((Object)(LogUtil.subheader((String)"EXPECTED CERTIFICATE") + realx509));
                LOG.warn((Object)(LogUtil.subheader((String)"RECEIVED CERTIFICATE") + msgx509));
            }
            return match;
        }
        return false;
    }

    private AbstractTransitionAction<Cluster> newLogRefresh(Class msgClass) {
        Cluster cluster = this;
        final SubjectRemoteCallbackFactory factory = Cluster.newSubjectMessageFactory(msgClass, cluster);
        return new AbstractTransitionAction<Cluster>(){

            public final void leave(Cluster parent, Callback.Completion transitionCallback) {
                Cluster.fireCallback(parent, parent.getLogServiceConfiguration(), false, (SubjectRemoteCallbackFactory<RemoteCallback, Cluster>)factory, transitionCallback);
            }
        };
    }

    protected ServiceConfiguration getLogServiceConfiguration() {
        ComponentId glId = ComponentIds.lookup(ClusterController.GatherLogService.class);
        ClusterConfiguration conf = this.getConfiguration();
        URI glUri = ServiceUris.remote(ClusterController.GatherLogService.class, (InetAddress)conf.getInetAddress(), (String[])new String[0]);
        return ServiceConfigurations.createEphemeral((ComponentId)glId, (String)conf.getPartition(), (String)conf.getName(), (URI)glUri);
    }

    public void fireEvent(Event event) {
        if (!Bootstrap.isFinished().booleanValue()) {
            LOG.info((Object)(this.getFullName() + " skipping clock event because bootstrap isn't finished"));
        } else if (Hosts.isCoordinator() && event instanceof Hertz) {
            this.fireClockTick((Hertz)event);
        }
    }

    private static <P, T extends SubjectMessageCallback<P, Q, R>, Q extends BaseMessage, R extends BaseMessage> SubjectRemoteCallbackFactory<T, P> newSubjectMessageFactory(final Class<T> callbackClass, final P subject) throws CancellationException {
        return new SubjectRemoteCallbackFactory<T, P>(){

            public T newInstance() {
                try {
                    if (subject != null) {
                        try {
                            SubjectMessageCallback callback = (SubjectMessageCallback)Classes.builder((Class)callbackClass).arg(subject).newInstance();
                            return callback;
                        }
                        catch (UndeclaredThrowableException ex) {
                            if (ex.getCause() instanceof CancellationException) {
                                throw (CancellationException)ex.getCause();
                            }
                            if (ex.getCause() instanceof NoSuchMethodException) {
                                try {
                                    SubjectMessageCallback callback = (SubjectMessageCallback)Classes.builder((Class)callbackClass).newInstance();
                                    callback.setSubject(subject);
                                    return callback;
                                }
                                catch (UndeclaredThrowableException ex1) {
                                    if (ex1.getCause() instanceof CancellationException) {
                                        throw (CancellationException)ex.getCause();
                                    }
                                    if (ex1.getCause() instanceof NoSuchMethodException) {
                                        throw ex1;
                                    }
                                    throw ex1;
                                }
                                catch (Exception ex1) {
                                    if (ex1.getCause() instanceof CancellationException) {
                                        throw (CancellationException)ex.getCause();
                                    }
                                    if (ex1.getCause() instanceof NoSuchMethodException) {
                                        throw ex;
                                    }
                                    throw Exceptions.toUndeclared((Throwable)ex1);
                                }
                            }
                            SubjectMessageCallback callback = (SubjectMessageCallback)callbackClass.newInstance();
                            LOG.error((Object)("Creating uninitialized callback (subject=" + subject + ") for type: " + callbackClass.getCanonicalName()));
                            return callback;
                        }
                        catch (RuntimeException ex) {
                            LOG.error((Object)("Failed to create instance of: " + callbackClass));
                            Logs.extreme().error((Object)ex, (Throwable)ex);
                            throw ex;
                        }
                    }
                    SubjectMessageCallback callback = (SubjectMessageCallback)callbackClass.newInstance();
                    LOG.error((Object)("Creating uninitialized callback (subject=" + subject + ") for type: " + callbackClass.getCanonicalName()));
                    return callback;
                }
                catch (CancellationException ex) {
                    LOG.debug((Object)ex);
                    throw ex;
                }
                catch (Exception ex) {
                    LOG.error((Object)ex);
                    Logs.extreme().error((Object)ex, (Throwable)ex);
                    throw Exceptions.toUndeclared((Throwable)ex);
                }
            }

            public P getSubject() {
                return subject;
            }
        };
    }

    private <T extends Throwable> boolean swallowException(T t) {
        LOG.error((Object)(this.getConfiguration().getFullName() + " checking: " + Exceptions.causeString(t)));
        if (Exceptions.isCausedBy(t, InterruptedException.class)) {
            Thread.currentThread().interrupt();
            return true;
        }
        if (Exceptions.isCausedBy(t, FailedRequestException.class)) {
            Logs.extreme().debug(t, t);
            this.pendingErrors.add(t);
            return false;
        }
        if (Exceptions.isCausedBy(t, ConnectionException.class) || Exceptions.isCausedBy(t, IOException.class)) {
            LOG.error((Object)(this.getName() + ": Error communicating with cluster: " + t.getMessage()));
            Logs.extreme().debug(t, t);
            this.pendingErrors.add(t);
            return false;
        }
        Logs.extreme().debug(t, t);
        this.pendingErrors.add(t);
        return false;
    }

    public void refreshResources() {
        try {
            Refresh.RESOURCES.fire(this);
        }
        catch (Exception ex) {
            LOG.error((Object)ex);
            LOG.debug((Object)ex, (Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void check() throws Faults.CheckException, IllegalStateException, InterruptedException, ServiceStateException {
        block15: {
            if (this.gateLock.readLock().tryLock(60L, TimeUnit.SECONDS)) {
                try {
                    ArrayList currentErrors;
                    State currentState;
                    block14: {
                        currentState = (State)this.stateMachine.getState();
                        currentErrors = Lists.newArrayList(this.pendingErrors);
                        this.pendingErrors.clear();
                        try {
                            Component.State state = this.configuration.lookupState();
                            if (Component.State.ENABLED.equals((Object)this.configuration.lookupState())) {
                                this.enabledTransition().call().get();
                            } else if (Component.State.DISABLED.equals((Object)this.configuration.lookupState())) {
                                this.disabledTransition().call().get();
                            } else if (Component.State.NOTREADY.equals((Object)this.configuration.lookupState())) {
                                this.notreadyTransition().call().get();
                            } else {
                                Refresh.SERVICEREADY.fire(this);
                            }
                        }
                        catch (Exception ex) {
                            if (ex.getCause() instanceof CancellationException) break block14;
                            currentErrors.add(ex);
                        }
                    }
                    Component.State externalState = this.configuration.lookupState();
                    if (!currentErrors.isEmpty()) {
                        throw Faults.failure((ServiceConfiguration)this.configuration, (List)currentErrors);
                    }
                    if (Component.State.ENABLED.equals((Object)externalState) && State.ENABLING.ordinal() >= currentState.ordinal()) {
                        IllegalStateException ex = new IllegalStateException("Cluster is currently reported as " + externalState + " but is really " + (Object)((Object)currentState) + ":  please see logs for additional information.");
                        currentErrors.add(ex);
                        throw Faults.failure((ServiceConfiguration)this.configuration, (List)currentErrors);
                    }
                    break block15;
                }
                finally {
                    this.gateLock.readLock().unlock();
                }
            }
            throw new ServiceStateException("Failed to check state in the zone " + this.getPartition() + ", it is currently locked for maintenance.");
        }
    }

    public String getPartition() {
        return this.configuration.getPartition();
    }

    public Partition lookupPartition() {
        return Partitions.lookup((ServiceConfiguration)this.getConfiguration());
    }

    public FullName getFullName() {
        return this.configuration.getFullName();
    }

    public StateMachine<Cluster, State, Transition> getStateMachine() {
        return this.stateMachine;
    }

    public String getDisplayName() {
        return this.getPartition();
    }

    public OwnerFullName getOwner() {
        return Principals.systemFullName();
    }

    public ConcurrentNavigableMap<String, NodeInfo> getNodeMap() {
        return this.nodeMap;
    }

    public Map<String, NodeInfo> getNodeHostMap() {
        return this.nodeHostAddrMap;
    }

    public ReadWriteLock getGateLock() {
        return this.gateLock;
    }

    public void migrateInstances(final String sourceHost, final Boolean destHostsWhiteList, final List<String> destHosts) throws Exception {
        if (this.gateLock.writeLock().tryLock(60L, TimeUnit.SECONDS)) {
            try {
                List<VmInstance> currentMigrations = this.lookupCurrentMigrations();
                if (!currentMigrations.isEmpty()) {
                    throw Exceptions.toUndeclared((String)("Cannot start a new migration because the following are already ongoing: " + Joiner.on((String)", ").join(Iterables.transform(currentMigrations, (Function)CloudMetadatas.toDisplayName()))), (Throwable[])new Throwable[0]);
                }
                this.retryCheck();
                this.prepareInstanceEvacuations(sourceHost);
                try {
                    AsyncRequests.sendSync((ServiceConfiguration)this.getConfiguration(), (BaseMessage)new ClusterMigrateInstancesType(){
                        {
                            this.setCorrelationId(Contexts.lookup().getCorrelationId());
                            this.setSourceHost(sourceHost);
                            this.setAllowHosts(destHostsWhiteList);
                            this.getDestinationHosts().addAll(destHosts);
                        }
                    });
                }
                catch (Exception ex) {
                    this.rollbackInstanceEvacuations(sourceHost);
                    throw ex;
                }
                this.retryCheck();
            }
            catch (Exception ex) {
                LOG.error((Object)ex);
                throw ex;
            }
            finally {
                this.gateLock.writeLock().unlock();
            }
        }
        throw new ServiceStateException("Failed to request migration in the zone " + this.getPartition() + ", it is currently locked for maintenance.");
    }

    public void migrateInstance(final String instanceId, final Boolean destHostsWhiteList, final List<String> destHosts) throws Exception {
        if (this.gateLock.writeLock().tryLock(60L, TimeUnit.SECONDS)) {
            try {
                List<VmInstance> currentMigrations = this.lookupCurrentMigrations();
                if (!currentMigrations.isEmpty()) {
                    throw Exceptions.toUndeclared((String)("Cannot start a new migration because the following are already ongoing: " + Joiner.on((String)", ").join(Iterables.transform(currentMigrations, (Function)CloudMetadatas.toDisplayName()))), (Throwable[])new Throwable[0]);
                }
                this.retryCheck();
                this.prepareInstanceMigrations(instanceId);
                try {
                    AsyncRequests.sendSync((ServiceConfiguration)this.getConfiguration(), (BaseMessage)new ClusterMigrateInstancesType(){
                        {
                            this.setCorrelationId(Contexts.lookup().getCorrelationId());
                            this.setInstanceId(instanceId);
                            this.setAllowHosts(destHostsWhiteList);
                            this.getDestinationHosts().addAll(destHosts);
                        }
                    });
                }
                catch (Exception ex) {
                    this.rollbackInstanceMigrations(instanceId);
                    throw ex;
                }
                this.retryCheck();
            }
            catch (Exception ex) {
                LOG.error((Object)ex);
                throw ex;
            }
            finally {
                this.gateLock.writeLock().unlock();
            }
        }
        throw new ServiceStateException("Failed to request migration in the zone " + this.getPartition() + ", it is currently locked for maintenance.");
    }

    private void rollbackInstanceEvacuations(final String sourceHost) {
        Predicate<VmInstance> filterHost = new Predicate<VmInstance>(){

            public boolean apply(@Nullable VmInstance input) {
                String vmHost = URI.create(input.getServiceTag()).getHost();
                return Strings.nullToEmpty((String)vmHost).equals(sourceHost);
            }
        };
        Predicate<VmInstance> rollbackMigration = new Predicate<VmInstance>(){

            public boolean apply(@Nullable VmInstance input) {
                input.abortMigration();
                return true;
            }
        };
        Predicate filterAndAbort = Predicates.and(this.filterPartition, (Predicate)rollbackMigration);
        Predicate rollbackMigrationTx = Entities.asTransaction(VmInstance.class, (Predicate)filterAndAbort);
        VmInstances.list((Predicate<? super VmInstance>)rollbackMigrationTx);
    }

    private void prepareInstanceEvacuations(final String sourceHost) {
        Predicate<VmInstance> filterHost = new Predicate<VmInstance>(){

            public boolean apply(@Nullable VmInstance input) {
                String vmHost = URI.create(input.getServiceTag()).getHost();
                return Strings.nullToEmpty((String)vmHost).equals(sourceHost);
            }
        };
        Predicate<VmInstance> startMigration = new Predicate<VmInstance>(){

            public boolean apply(@Nullable VmInstance input) {
                input.startMigration();
                return true;
            }
        };
        Predicate filterAndAbort = Predicates.and(this.filterPartition, (Predicate)startMigration);
        Predicate startMigrationTx = Entities.asTransaction(VmInstance.class, (Predicate)filterAndAbort);
        VmInstances.list((Predicate<? super VmInstance>)startMigrationTx);
    }

    private void rollbackInstanceMigrations(String instanceId) {
        Predicate<VmInstance> rollbackMigration = new Predicate<VmInstance>(){

            public boolean apply(@Nullable VmInstance input) {
                input.abortMigration();
                return true;
            }
        };
        Predicate rollbackMigrationTx = Entities.asTransaction(VmInstance.class, (Predicate)rollbackMigration);
        rollbackMigrationTx.apply((Object)VmInstances.lookup(instanceId));
    }

    private void prepareInstanceMigrations(String instanceId) {
        Predicate<VmInstance> startMigration = new Predicate<VmInstance>(){

            public boolean apply(@Nullable VmInstance input) {
                input.startMigration();
                return true;
            }
        };
        Predicate startMigrationTx = Entities.asTransaction(VmInstance.class, (Predicate)startMigration);
        startMigrationTx.apply((Object)VmInstances.lookup(instanceId));
    }

    private List<VmInstance> lookupCurrentMigrations() throws Exception {
        return VmInstances.list(this.filterPartition);
    }

    private void retryCheck() throws Exception {
        Exception lastEx = null;
        for (int i = 0; i < 5; ++i) {
            try {
                this.check();
                return;
            }
            catch (Exception ex) {
                LOG.debug((Object)("Retrying after failed attempt to refresh cluster state in check(): " + ex.getMessage()));
                lastEx = ex;
                TimeUnit.SECONDS.sleep(2L);
                continue;
            }
        }
        throw new ServiceStateException("Failed to request migration in the zone " + this.getPartition() + " because updating resources returned an error: " + (lastEx != null ? lastEx.getMessage() : "unknown error"));
    }

    static enum ErrorStateListeners implements Callback<Cluster>
    {
        FLUSHPENDING{

            public void fire(Cluster t) {
                LOG.debug((Object)("Clearing error logs for: " + t));
                t.clearExceptions();
            }
        }
        ,
        CHECKPENDING{

            public void fire(Cluster t) {
                if (!t.pendingErrors.isEmpty()) {
                    Logs.extreme().error((Object)t.pendingErrors);
                }
                LOG.debug((Object)("Clearing error logs for: " + t));
                t.clearExceptions();
            }
        };

    }

    public static enum Transition implements Automata.Transition<Transition>
    {
        RESTART_BROKEN,
        PRESTART,
        AUTHENTICATE,
        START,
        START_CHECK,
        STARTING_SERVICES,
        NOTREADYCHECK,
        ENABLE,
        ENABLING_RESOURCES,
        ENABLING_NET,
        ENABLING_VMS,
        ENABLING_ADDRS,
        ENABLING_VMS_PASS_TWO,
        ENABLING_ADDRS_PASS_TWO,
        ENABLED,
        ENABLED_ADDRS,
        ENABLED_VMS,
        ENABLED_NET,
        ENABLED_SERVICES,
        ENABLED_RSC,
        DISABLE,
        DISABLEDCHECK,
        STOP;

    }

    public static enum State implements Automata.State<State>
    {
        BROKEN,
        STOPPED,
        PENDING,
        AUTHENTICATING,
        STARTING,
        STARTING_NOTREADY,
        NOTREADY,
        DISABLED,
        ENABLING,
        ENABLING_RESOURCES,
        ENABLING_NET,
        ENABLING_VMS,
        ENABLING_ADDRS,
        ENABLING_VMS_PASS_TWO,
        ENABLING_ADDRS_PASS_TWO,
        ENABLED,
        ENABLED_SERVICE_CHECK,
        ENABLED_ADDRS,
        ENABLED_RSC,
        ENABLED_NET,
        ENABLED_VMS;


        public Component.State proxyState() {
            try {
                return Component.State.valueOf((String)this.name());
            }
            catch (Exception ex) {
                if (this.equals((Object)DISABLED)) {
                    return Component.State.DISABLED;
                }
                if (this.ordinal() < DISABLED.ordinal()) {
                    return Component.State.NOTREADY;
                }
                if (this.ordinal() >= ENABLING.ordinal()) {
                    return Component.State.ENABLED;
                }
                return Component.State.INITIALIZED;
            }
        }
    }

    static enum Refresh implements Function<Cluster, TransitionAction<Cluster>>
    {
        RESOURCES(ResourceStateCallback.class),
        NETWORKS(NetworkStateCallback.class),
        INSTANCES(VmStateCallback.class),
        VOLATILEINSTANCES(VmStateCallback.VmPendingCallback.class),
        ADDRESSES(PublicAddressStateCallback.class),
        SERVICEREADY(ServiceStateCallback.class);

        Class refresh;

        private Refresh(Class refresh) {
            this.refresh = refresh;
        }

        public TransitionAction<Cluster> apply(Cluster cluster) {
            final SubjectRemoteCallbackFactory factory = Cluster.newSubjectMessageFactory(this.refresh, cluster);
            return new AbstractTransitionAction<Cluster>(){

                public final void leave(Cluster parent, Callback.Completion transitionCallback) {
                    Cluster.fireCallback(parent, (SubjectRemoteCallbackFactory<RemoteCallback, Cluster>)factory, transitionCallback);
                }
            };
        }

        public void fire(Cluster input) {
            SubjectRemoteCallbackFactory factory = Cluster.newSubjectMessageFactory(this.refresh, input);
            try {
                RemoteCallback messageCallback = (RemoteCallback)factory.newInstance();
                BaseMessage baseMessage = AsyncRequests.newRequest((RemoteCallback)messageCallback).sendSync((ServiceConfiguration)input.getConfiguration());
                Logs.extreme().debug((Object)("Response to " + messageCallback + ": " + baseMessage));
            }
            catch (CancellationException messageCallback) {
            }
            catch (Exception ex) {
                LOG.error((Object)ex);
                Logs.extreme().error((Object)ex);
                throw Exceptions.toUndeclared((Throwable)ex);
            }
        }

        public String toString() {
            return this.name() + ":" + this.refresh.getSimpleName();
        }
    }

    private static class ServiceStateCallback
    extends SubjectMessageCallback<Cluster, DescribeServicesType, DescribeServicesResponseType> {
        public ServiceStateCallback() {
            this.setRequest((BaseMessage)new DescribeServicesType());
        }

        public void fire(DescribeServicesResponseType msg) {
            ArrayList serviceStatuses = msg.getServiceStatuses();
            Cluster parent = (Cluster)this.getSubject();
            LOG.debug((Object)("DescribeServices for " + parent.getFullName()));
            if (serviceStatuses.isEmpty()) {
                throw new NoSuchElementException("Failed to find service info for cluster: " + parent.getFullName());
            }
            if (!Bootstrap.isOperational().booleanValue()) {
                return;
            }
            ClusterConfiguration config = parent.getConfiguration();
            for (ServiceStatusType status : serviceStatuses) {
                if ("self".equals(status.getServiceId().getName()) || !config.getName().equals(status.getServiceId().getName())) {
                    status.setServiceId((ServiceId)TypeMappers.transform((Object)parent.getConfiguration(), ServiceId.class));
                }
                if (status.getServiceId() == null || status.getServiceId().getName() == null || status.getServiceId().getType() == null) {
                    LOG.error((Object)("Received invalid service id: " + status));
                    continue;
                }
                if (!config.getName().equals(status.getServiceId().getName()) || !Components.lookup(ClusterController.class).getName().equals(status.getServiceId().getType())) continue;
                LOG.debug((Object)("Found service info: " + status));
                Component.State serviceState = Component.State.valueOf((String)status.getLocalState());
                Component.State localState = parent.getConfiguration().lookupState();
                Component.State proxyState = ((State)parent.getStateMachine().getState()).proxyState();
                Faults.CheckException ex = (Faults.CheckException)Faults.transformToExceptions().apply((Object)status);
                if (Component.State.NOTREADY.equals((Object)serviceState)) {
                    throw new IllegalStateException((Throwable)ex);
                }
                if (Component.State.ENABLED.equals((Object)serviceState) && Component.State.DISABLED.ordinal() >= localState.ordinal()) {
                    ServiceStateDispatch.DISABLED.apply(parent);
                } else if (Component.State.DISABLED.equals((Object)serviceState) && Component.State.ENABLED.equals((Object)localState)) {
                    ServiceStateDispatch.ENABLED.apply(parent);
                } else if (Component.State.LOADED.equals((Object)serviceState) && Component.State.NOTREADY.ordinal() <= localState.ordinal()) {
                    ServiceStateDispatch.STARTED.apply(parent);
                } else if (Component.State.NOTREADY.ordinal() < serviceState.ordinal()) {
                    parent.clearExceptions();
                }
                return;
            }
            LOG.error((Object)("Failed to find service info for cluster: " + parent.getFullName() + " instead found service status for: " + serviceStatuses));
            throw new NoSuchElementException("Failed to find service info for cluster: " + parent.getFullName());
        }

        public void setSubject(Cluster subject) {
            ((DescribeServicesType)this.getRequest()).getServices().add(TypeMappers.transform((Object)subject.getConfiguration(), ServiceId.class));
            super.setSubject((Object)subject);
        }
    }

    static enum LogRefresh implements Function<Cluster, TransitionAction<Cluster>>
    {
        LOGS(LogDataCallback.class),
        CERTS(ClusterCertsCallback.class);

        Class refresh;

        private LogRefresh(Class refresh) {
            this.refresh = refresh;
        }

        public TransitionAction<Cluster> apply(Cluster cluster) {
            final SubjectRemoteCallbackFactory factory = Cluster.newSubjectMessageFactory(this.refresh, cluster);
            return new AbstractTransitionAction<Cluster>(){

                public final void leave(Cluster parent, Callback.Completion transitionCallback) {
                    Cluster.fireCallback(parent, parent.getLogServiceConfiguration(), false, (SubjectRemoteCallbackFactory<RemoteCallback, Cluster>)factory, transitionCallback);
                }
            };
        }
    }

    private static enum ServiceStateDispatch implements Predicate<Cluster>,
    RemoteCallback<ServiceTransitionType, ServiceTransitionType>
    {
        STARTED(StartServiceType.class),
        ENABLED(EnableServiceType.class){

            @Override
            public boolean apply(Cluster input) {
                try {
                    if (Bootstrap.isOperational().booleanValue()) {
                        super.apply(input);
                    }
                    ZoneRegistration.REGISTER.apply(input);
                    return true;
                }
                catch (Exception t) {
                    return input.swallowException(t);
                }
            }
        }
        ,
        DISABLED(DisableServiceType.class){

            @Override
            public boolean apply(Cluster input) {
                try {
                    if (Bootstrap.isOperational().booleanValue()) {
                        super.apply(input);
                    }
                    ZoneRegistration.DEREGISTER.apply(input);
                    return true;
                }
                catch (Exception ex) {
                    return false;
                }
            }
        };

        final Class<? extends ServiceTransitionType> msgClass;

        private ServiceStateDispatch(Class<? extends ServiceTransitionType> msgClass) {
            this.msgClass = msgClass;
        }

        public ServiceTransitionType getRequest() {
            return (ServiceTransitionType)Classes.newInstance(this.msgClass, (Object[])new Object[0]);
        }

        public void fire(ServiceTransitionType msg) {
            LOG.debug((Object)(this.name() + " service: " + msg));
        }

        public boolean apply(Cluster input) {
            if (Hosts.isCoordinator()) {
                try {
                    AsyncRequests.newRequest((RemoteCallback)this).sendSync((ServiceConfiguration)input.configuration);
                    return true;
                }
                catch (Exception t) {
                    return input.swallowException(t);
                }
            }
            return true;
        }

        public void initialize(ServiceTransitionType request) throws Exception {
        }

        public void fireException(Throwable t) {
            Logs.extreme().error((Object)t, t);
        }
    }

    static enum ZoneRegistration implements Predicate<Cluster>
    {
        REGISTER{

            public boolean apply(Cluster input) {
                Clusters.getInstance().register(input);
                return true;
            }
        }
        ,
        DEREGISTER{

            public boolean apply(Cluster input) {
                Clusters.getInstance().registerDisabled(input);
                return true;
            }
        };

    }
}

