/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.cloud.util;

import com.eucalyptus.cloud.util.Reference;
import com.eucalyptus.cloud.util.ResourceAllocationException;
import com.eucalyptus.entities.Entities;
import com.eucalyptus.entities.UserMetadata;
import com.eucalyptus.util.HasNaturalId;
import com.eucalyptus.util.OwnerFullName;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.persistence.MappedSuperclass;

@MappedSuperclass
public abstract class PersistentReference<T extends PersistentReference<T, R>, R extends HasNaturalId>
extends UserMetadata<Reference.State>
implements Reference<T, R> {
    private static final long serialVersionUID = 1L;

    protected PersistentReference(OwnerFullName owner, String displayName) {
        super(owner, displayName);
    }

    private T get() {
        return (T)this;
    }

    protected abstract void setReference(@Nullable R var1);

    protected abstract R getReference();

    @Override
    public final T allocate() throws ResourceAllocationException {
        return this.doSetReferer(null, Reference.State.FREE, Reference.State.PENDING);
    }

    @Override
    public T release() throws ResourceAllocationException {
        return this.doSetReferer(null, null, Reference.State.FREE);
    }

    @Override
    public final boolean teardown() throws ResourceAllocationException {
        Entities.delete((Object)this);
        return true;
    }

    @Override
    public final T reclaim(R referer) throws ResourceAllocationException {
        return this.doSetReferer(referer, null, Reference.State.EXTANT);
    }

    protected T doSetReferer(R referer, Reference.State preconditionState, Reference.State finalState) throws ResourceAllocationException {
        this.checkPreconditions(referer, preconditionState, finalState);
        if (referer != null && !Reference.State.PENDING.equals((Object)finalState)) {
            this.setReference(referer);
            this.setState(finalState);
        } else {
            this.setReference(null);
            this.setState(finalState);
        }
        return this.get();
    }

    protected void ensureTransaction() {
        if (!Entities.hasTransaction((Object)this)) {
            throw new RuntimeException("Error allocating resource " + this.getClass().getSimpleName() + " with id " + this.getDisplayName() + " as there is no ongoing transaction.");
        }
    }

    private void checkPreconditions(R referer, Reference.State preconditionState, Reference.State finalState) throws RuntimeException {
        boolean matchReferer;
        this.ensureTransaction();
        Reference.State currentState = (Reference.State)this.getState();
        boolean matchPrecondition = preconditionState == null || currentState != null && preconditionState.equals((Object)currentState);
        boolean matchFinal = finalState == null && currentState == null || finalState != null && currentState != null && finalState.equals((Object)currentState);
        boolean bl = matchReferer = this.getReference() == null || referer != null && this.getReference() != null && referer.equals(this.getReference());
        if (!(matchFinal && matchReferer || matchPrecondition)) {
            throw new RuntimeException("Error allocating resource " + this.getClass().getSimpleName() + " with id " + this.getDisplayName() + " as the state is not either the precondition " + preconditionState.name() + " or the final state " + Objects.toString((Object)finalState) + " (currently " + Objects.toString((Object)currentState) + ", referer " + this.getReference() + ", passed referer " + referer + ")");
        }
    }

    @Override
    public T set(R referer) throws ResourceAllocationException {
        return this.doSetReferer(referer, Reference.State.PENDING, Reference.State.EXTANT);
    }
}

