/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.cloud.run;

import com.eucalyptus.auth.Accounts;
import com.eucalyptus.auth.AuthContextSupplier;
import com.eucalyptus.auth.AuthException;
import com.eucalyptus.auth.Permissions;
import com.eucalyptus.auth.policy.ern.Ern;
import com.eucalyptus.auth.policy.ern.EuareResourceName;
import com.eucalyptus.auth.principal.Account;
import com.eucalyptus.auth.principal.InstanceProfile;
import com.eucalyptus.auth.principal.Role;
import com.eucalyptus.auth.principal.UserFullName;
import com.eucalyptus.cloud.VmInstanceLifecycleHelpers;
import com.eucalyptus.cloud.run.Allocations;
import com.eucalyptus.cloud.util.IllegalMetadataAccessException;
import com.eucalyptus.cloud.util.InvalidInstanceProfileMetadataException;
import com.eucalyptus.cloud.util.InvalidMetadataException;
import com.eucalyptus.cloud.util.MetadataException;
import com.eucalyptus.cloud.util.VerificationException;
import com.eucalyptus.cluster.Cluster;
import com.eucalyptus.cluster.Clusters;
import com.eucalyptus.component.Partition;
import com.eucalyptus.component.Partitions;
import com.eucalyptus.component.Topology;
import com.eucalyptus.component.id.ClusterController;
import com.eucalyptus.compute.common.BlockDeviceMappingItemType;
import com.eucalyptus.compute.common.ImageMetadata;
import com.eucalyptus.compute.common.VmTypeDetails;
import com.eucalyptus.compute.common.backend.RunInstancesType;
import com.eucalyptus.images.BlockStorageImageInfo;
import com.eucalyptus.images.BootableImageInfo;
import com.eucalyptus.images.DeviceMapping;
import com.eucalyptus.images.Emis;
import com.eucalyptus.images.ImageInfo;
import com.eucalyptus.images.Images;
import com.eucalyptus.images.MachineImageInfo;
import com.eucalyptus.imaging.ImagingServiceProperties;
import com.eucalyptus.imaging.common.EucalyptusActivityTasks;
import com.eucalyptus.keys.KeyPairs;
import com.eucalyptus.keys.SshKeyPair;
import com.eucalyptus.util.Exceptions;
import com.eucalyptus.util.OwnerFullName;
import com.eucalyptus.util.RestrictedTypes;
import com.eucalyptus.vm.VmInstances;
import com.eucalyptus.vmtypes.VmType;
import com.eucalyptus.vmtypes.VmTypes;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import edu.ucsb.eucalyptus.cloud.NodeInfo;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.NoSuchElementException;
import net.sf.json.JSONException;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class VerifyMetadata {
    private static Logger LOG = Logger.getLogger(VerifyMetadata.class);
    private static final long BYTES_PER_GB = 0x40000000L;
    private static final ArrayList<? extends MetadataVerifier> verifiers = Lists.newArrayList((Object[])new Enum[]{VmTypeVerifier.INSTANCE, PartitionVerifier.INSTANCE, ImageVerifier.INSTANCE, KeyPairVerifier.INSTANCE, NetworkResourceVerifier.INSTANCE, RoleVerifier.INSTANCE, BlockDeviceMapVerifier.INSTANCE, UserDataVerifier.INSTANCE});
    private static final ArrayList<? extends MetadataVerifier> postVerifiers = Lists.newArrayList((Object[])new EkiEriSupportVerifier[]{EkiEriSupportVerifier.INSTANCE});

    public static Predicate<Allocations.Allocation> getVerifiers() {
        return Predicates.and((Iterable)Lists.transform(verifiers, (Function)AsPredicate.INSTANCE));
    }

    public static Predicate<Allocations.Allocation> getPostVerifiers() {
        return Predicates.and((Iterable)Lists.transform(postVerifiers, (Function)AsPredicate.INSTANCE));
    }

    public static class ImageInstanceTypeVerificationException
    extends VerificationException {
        private static final long serialVersionUID = -1L;

        public ImageInstanceTypeVerificationException(String message) {
            super(message);
        }
    }

    static enum UserDataVerifier implements MetadataVerifier
    {
        INSTANCE;


        @Override
        public boolean apply(Allocations.Allocation allocInfo) throws MetadataException {
            byte[] userData = allocInfo.getUserData();
            if (userData != null && userData.length > Integer.parseInt(VmInstances.USER_DATA_MAX_SIZE_KB) * 1024) {
                throw new InvalidMetadataException("User data may not exceed " + VmInstances.USER_DATA_MAX_SIZE_KB + " KB");
            }
            return true;
        }
    }

    static enum BlockDeviceMapVerifier implements MetadataVerifier
    {
        INSTANCE;


        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean apply(Allocations.Allocation allocInfo) throws MetadataException {
            BootableImageInfo imageInfo = allocInfo.getBootSet().getMachine();
            final ArrayList<BlockDeviceMappingItemType> instanceMappings = allocInfo.getRequest().getBlockDeviceMapping() != null ? allocInfo.getRequest().getBlockDeviceMapping() : new ArrayList<BlockDeviceMappingItemType>();
            ArrayList<DeviceMapping> imageMappings = new ArrayList<DeviceMapping>(((ImageInfo)((Object)imageInfo)).getDeviceMappings());
            instanceMappings.addAll(Lists.transform((List)Lists.newArrayList((Iterable)Iterables.filter(imageMappings, (Predicate)new Predicate<DeviceMapping>(){

                public boolean apply(DeviceMapping arg0) {
                    return !Iterables.any((Iterable)instanceMappings, Images.findBlockDeviceMappingItempType(arg0.getDeviceName()));
                }
            })), (Function)Images.DeviceMappingDetails.INSTANCE));
            ArrayList<Object> resultedInstanceMappings = new ArrayList();
            if (imageInfo instanceof BlockStorageImageInfo) {
                if (!instanceMappings.isEmpty()) {
                    resultedInstanceMappings = Images.validateBlockDeviceMappings(instanceMappings, EnumSet.of(Images.DeviceMappingValidationOption.AllowSuppressMapping, Images.DeviceMappingValidationOption.AllowEbsMapping, Images.DeviceMappingValidationOption.SkipExtraEphemeral));
                    BlockStorageImageInfo bfebsImage = (BlockStorageImageInfo)imageInfo;
                    Integer imageSizeGB = (int)(bfebsImage.getImageSizeBytes() / 0x40000000L);
                    Integer userRequestedSizeGB = null;
                    BlockDeviceMappingItemType rootBlockDevice = (BlockDeviceMappingItemType)Iterables.find(resultedInstanceMappings, Images.findEbsRootOptionalSnapshot(bfebsImage.getRootDeviceName()), null);
                    if (rootBlockDevice == null) throw new InvalidMetadataException("Root block device mapping not found\n");
                    if (StringUtils.isNotBlank((String)rootBlockDevice.getEbs().getSnapshotId()) && !StringUtils.equals((String)rootBlockDevice.getEbs().getSnapshotId(), (String)bfebsImage.getSnapshotId())) {
                        throw new InvalidMetadataException("Snapshot ID cannot be modified for the root device. Source snapshot from the image registration will be used for creating the root device");
                    }
                    if (StringUtils.isNotBlank((String)rootBlockDevice.getVirtualName())) {
                        throw new InvalidMetadataException("Logical type cannot be modified for the root device. Source snapshot from the image registration will be used for creating the root device");
                    }
                    if (rootBlockDevice.getNoDevice() != null && rootBlockDevice.getNoDevice().booleanValue()) {
                        throw new InvalidMetadataException("Root device cannot be suppressed. Source snapshot from the image registration will be used for creating the root device");
                    }
                    userRequestedSizeGB = rootBlockDevice.getEbs().getVolumeSize();
                    if (userRequestedSizeGB != null && userRequestedSizeGB < imageSizeGB) {
                        throw new InvalidMetadataException("Root device volume cannot be smaller than the image size");
                    }
                    if (rootBlockDevice.getEbs().getSnapshotId() == null) {
                        rootBlockDevice.getEbs().setSnapshotId(bfebsImage.getSnapshotId());
                    }
                    if (rootBlockDevice.getEbs().getVolumeSize() == null) {
                        rootBlockDevice.getEbs().setVolumeSize(imageSizeGB);
                    }
                    if (rootBlockDevice.getEbs().getDeleteOnTermination() == null) {
                        rootBlockDevice.getEbs().setDeleteOnTermination(bfebsImage.getDeleteOnTerminate());
                    }
                }
            } else {
                resultedInstanceMappings = Images.validateBlockDeviceMappings(instanceMappings, EnumSet.of(Images.DeviceMappingValidationOption.AllowSuppressMapping, Images.DeviceMappingValidationOption.SkipExtraEphemeral));
            }
            allocInfo.getRequest().setBlockDeviceMapping(resultedInstanceMappings);
            return true;
        }
    }

    static enum RoleVerifier implements MetadataVerifier
    {
        INSTANCE;


        @Override
        public boolean apply(Allocations.Allocation allocInfo) throws MetadataException {
            UserFullName ownerFullName = allocInfo.getOwnerFullName();
            String instanceProfileArn = allocInfo.getRequest().getIamInstanceProfileArn();
            String instanceProfileName = allocInfo.getRequest().getIamInstanceProfileName();
            if (!Strings.isNullOrEmpty((String)instanceProfileArn) || !Strings.isNullOrEmpty((String)instanceProfileName)) {
                InstanceProfile profile;
                block16: {
                    if (!Strings.isNullOrEmpty((String)instanceProfileArn)) {
                        try {
                            Ern name = Ern.parse((String)instanceProfileArn);
                            if (!(name instanceof EuareResourceName)) {
                                throw new InvalidInstanceProfileMetadataException("Invalid IAM instance profile ARN: " + instanceProfileArn);
                            }
                            profile = Accounts.lookupAccountById((String)name.getNamespace()).lookupInstanceProfileByName(((EuareResourceName)name).getName());
                            if (!Strings.isNullOrEmpty((String)instanceProfileName) && !instanceProfileName.equals(profile.getName())) {
                                throw new InvalidInstanceProfileMetadataException(String.format("Invalid IAM instance profile name '%s' for ARN: %s", name, instanceProfileArn));
                            }
                            break block16;
                        }
                        catch (AuthException | JSONException e) {
                            throw new InvalidInstanceProfileMetadataException("Invalid IAM instance profile ARN: " + instanceProfileArn, e);
                        }
                    }
                    if (!Strings.isNullOrEmpty((String)instanceProfileName)) {
                        try {
                            profile = Accounts.lookupAccountById((String)ownerFullName.getAccountNumber()).lookupInstanceProfileByName(instanceProfileName);
                        }
                        catch (AuthException e) {
                            throw new InvalidInstanceProfileMetadataException("Invalid IAM instance profile name: " + instanceProfileName, e);
                        }
                    } else {
                        profile = null;
                    }
                }
                if (profile != null) {
                    try {
                        String roleArn;
                        String profileArn = Accounts.getInstanceProfileArn((InstanceProfile)profile);
                        AuthContextSupplier user = allocInfo.getAuthContext();
                        if (!Permissions.isAuthorized((String)"iam", (String)"instance-profile", (String)Accounts.getInstanceProfileFullName((InstanceProfile)profile), (Account)profile.getAccount(), (String)"listinstanceprofiles", (AuthContextSupplier)user)) {
                            throw new IllegalMetadataAccessException(String.format("Not authorized to access instance profile with ARN %s for %s", profileArn, ownerFullName));
                        }
                        Role role = profile.getRole();
                        String string = roleArn = role == null ? null : Accounts.getRoleArn((Role)role);
                        if (role != null && !Permissions.isAuthorized((String)"iam", (String)"role", (String)Accounts.getRoleFullName((Role)role), (Account)role.getAccount(), (String)"passrole", (AuthContextSupplier)user)) {
                            throw new IllegalMetadataAccessException(String.format("Not authorized to pass role with ARN %s for %s", roleArn, ownerFullName));
                        }
                        if (role == null) {
                            throw new InvalidInstanceProfileMetadataException("Role not found for IAM instance profile ARN: " + instanceProfileArn);
                        }
                        allocInfo.setInstanceProfileArn(profileArn);
                        allocInfo.setIamInstanceProfileId(profile.getInstanceProfileId());
                        allocInfo.setIamRoleArn(roleArn);
                    }
                    catch (AuthException e) {
                        throw new MetadataException("IAM instance profile error", e);
                    }
                }
            }
            return true;
        }
    }

    static enum NetworkResourceVerifier implements MetadataVerifier
    {
        INSTANCE;


        @Override
        public boolean apply(Allocations.Allocation allocInfo) throws MetadataException {
            VmInstanceLifecycleHelpers.get().verifyAllocation(allocInfo);
            return true;
        }
    }

    static enum KeyPairVerifier implements MetadataVerifier
    {
        INSTANCE;


        @Override
        public boolean apply(Allocations.Allocation allocInfo) throws MetadataException {
            if (allocInfo.getRequest().getKeyName() == null || "".equals(allocInfo.getRequest().getKeyName())) {
                allocInfo.setSshKeyPair(KeyPairs.noKey());
                return true;
            }
            UserFullName ownerFullName = allocInfo.getOwnerFullName();
            RunInstancesType request = allocInfo.getRequest();
            String keyName = request.getKeyName();
            SshKeyPair key = KeyPairs.lookup((OwnerFullName)ownerFullName.asAccountFullName(), keyName);
            if (!RestrictedTypes.filterPrivileged().apply((Object)key)) {
                throw new IllegalMetadataAccessException("Not authorized to use keypair " + keyName + " by " + ownerFullName.getUserName());
            }
            allocInfo.setSshKeyPair(key);
            return true;
        }
    }

    static enum ImageVerifier implements MetadataVerifier
    {
        INSTANCE;

        private static long GIG;
        private static long MB;

        @Override
        public boolean apply(Allocations.Allocation allocInfo) throws MetadataException, AuthException, VerificationException {
            RunInstancesType msg = allocInfo.getRequest();
            String imageId = msg.getImageId();
            VmType vmType = allocInfo.getVmType();
            try {
                Emis.BootableSet bootSet = Emis.newBootableSet(imageId);
                allocInfo.setBootableSet(bootSet);
                if (!bootSet.isBlockStorage()) {
                    if (ImageMetadata.Platform.windows.equals((Object)bootSet.getMachine().getPlatform()) && bootSet.getMachine().getImageSizeBytes() > 0x40000000L * (long)vmType.getDisk().intValue() + 0xA00000L) {
                        throw new ImageInstanceTypeVerificationException("Unable to run instance " + bootSet.getMachine().getDisplayName() + " in which the size " + bootSet.getMachine().getImageSizeBytes() + " bytes of the instance is greater than the vmType " + vmType.getDisplayName() + " size " + vmType.getDisk() + " GB.");
                    }
                    if (bootSet.getMachine().getImageSizeBytes() >= 0x40000000L * (long)vmType.getDisk().intValue()) {
                        throw new ImageInstanceTypeVerificationException("Unable to run instance " + bootSet.getMachine().getDisplayName() + " in which the size " + bootSet.getMachine().getImageSizeBytes() + " bytes of the instance is greater than the vmType " + vmType.getDisplayName() + " size " + vmType.getDisk() + " GB.");
                    }
                    MachineImageInfo emi = Emis.LookupMachine.INSTANCE.apply(imageId);
                    if (ImageMetadata.State.pending_available.equals((Object)emi.getState()) && !ImageVerifier.verifyImagerCapacity(emi)) {
                        throw new MetadataException("Partition image of this size cannot be deployed without an adequately provisioned Imaging Worker. Please contact your cloud administrator.");
                    }
                }
            }
            catch (VerificationException e) {
                throw e;
            }
            catch (MetadataException ex) {
                LOG.error((Object)ex);
                throw ex;
            }
            catch (RuntimeException ex) {
                LOG.error((Object)ex);
                throw new VerificationException("Failed to verify references for request: " + msg.toSimpleString() + " because of: " + ex.getMessage(), ex);
            }
            return true;
        }

        private static boolean verifyImagerCapacity(MachineImageInfo img) throws MetadataException {
            MachineImageInfo emi;
            String workerType = ImagingServiceProperties.INSTANCE_TYPE;
            String emiName = ImagingServiceProperties.IMAGE;
            if (workerType == null) {
                return false;
            }
            if (emiName == null || "NULL".equals(emiName)) {
                throw new MetadataException("Partition image cannot be deployed without an enabled Imaging Service. Please contact your cloud administrator.");
            }
            List allTypes = EucalyptusActivityTasks.getInstance().describeVMTypes();
            long diskSizeBytes = 0L;
            for (VmTypeDetails type : allTypes) {
                if (!type.getName().equalsIgnoreCase(workerType)) continue;
                diskSizeBytes = (long)type.getDisk().intValue() * GIG;
                break;
            }
            try {
                emi = Emis.LookupMachine.INSTANCE.apply(emiName);
            }
            catch (NoSuchElementException ex) {
                throw new MetadataException("Partition image cannot be deployed without an enabled Imaging Service. Please contact your cloud administrator.");
            }
            long spaceLeft = diskSizeBytes - emi.getImageSizeBytes() - img.getImageSizeBytes() - 200L * MB;
            return spaceLeft > 0L;
        }

        static {
            GIG = 0x40000000L;
            MB = 0x100000L;
        }
    }

    static enum PartitionVerifier implements MetadataVerifier
    {
        INSTANCE;


        @Override
        public boolean apply(Allocations.Allocation allocInfo) throws MetadataException {
            RunInstancesType request = allocInfo.getRequest();
            String zoneName = request.getAvailabilityZone();
            if (Clusters.getInstance().listValues().isEmpty()) {
                LOG.debug((Object)("enabled values: " + Joiner.on((String)"\n").join((Iterable)Clusters.getInstance().listValues())));
                LOG.debug((Object)("disabled values: " + Joiner.on((String)"\n").join((Iterable)Clusters.getInstance().listValues())));
                throw new VerificationException("Not enough resources: no cluster controller is currently available to run instances.");
            }
            if (Partitions.exists((String)zoneName)) {
                Partition partition = Partitions.lookupByName((String)zoneName);
                allocInfo.setPartition(partition);
            } else if ("".equals(zoneName)) {
                Partition partition = Partition.DEFAULT;
                allocInfo.setPartition(partition);
            } else {
                throw new VerificationException("Not enough resources: no cluster controller is currently available to run instances.");
            }
            return true;
        }
    }

    static enum VmTypeVerifier implements MetadataVerifier
    {
        INSTANCE;


        @Override
        public boolean apply(Allocations.Allocation allocInfo) throws MetadataException {
            String instanceType = allocInfo.getRequest().getInstanceType();
            VmType vmType = VmTypes.lookup(instanceType);
            if (!RestrictedTypes.filterPrivileged().apply((Object)vmType)) {
                throw new IllegalMetadataAccessException("Not authorized to allocate vm type " + instanceType + " for " + allocInfo.getOwnerFullName());
            }
            allocInfo.setVmType(vmType);
            return true;
        }
    }

    static enum EkiEriSupportVerifier implements MetadataVerifier
    {
        INSTANCE;


        @Override
        public boolean apply(Allocations.Allocation allocInfo) throws VerificationException {
            Cluster c;
            if (!(allocInfo.getRunInstancesRequest().getKernelId() == null && allocInfo.getRunInstancesRequest().getRamdiskId() == null || (c = Clusters.lookup(Topology.lookup(ClusterController.class, (Partition[])new Partition[]{allocInfo.getPartition()}))).getNodeHostMap().values().isEmpty())) {
                NodeInfo.Hypervisor h = c.getNodeHostMap().values().iterator().next().getHypervisor();
                LOG.warn((Object)("Hypervisor is" + h));
                if (!h.supportEkiEri()) {
                    throw new VerificationException("EKI/ERI options are not supported by installation on " + h.name());
                }
            }
            return true;
        }
    }

    private static enum AsPredicate implements Function<MetadataVerifier, Predicate<Allocations.Allocation>>
    {
        INSTANCE;


        public Predicate<Allocations.Allocation> apply(final MetadataVerifier arg0) {
            return new Predicate<Allocations.Allocation>(){

                public boolean apply(Allocations.Allocation allocInfo) {
                    try {
                        return arg0.apply(allocInfo);
                    }
                    catch (Exception ex) {
                        throw Exceptions.toUndeclared((Throwable)ex);
                    }
                }
            };
        }
    }

    private static interface MetadataVerifier {
        public boolean apply(Allocations.Allocation var1) throws MetadataException, AuthException, VerificationException;
    }
}

