/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.cloud.run;

import com.eucalyptus.auth.Accounts;
import com.eucalyptus.auth.AuthException;
import com.eucalyptus.auth.euare.SignCertificateResponseType;
import com.eucalyptus.auth.euare.SignCertificateType;
import com.eucalyptus.auth.principal.User;
import com.eucalyptus.auth.principal.UserFullName;
import com.eucalyptus.blockstorage.Snapshot;
import com.eucalyptus.blockstorage.Snapshots;
import com.eucalyptus.blockstorage.Storage;
import com.eucalyptus.blockstorage.Volume;
import com.eucalyptus.blockstorage.Volumes;
import com.eucalyptus.blockstorage.msgs.DescribeStorageVolumesResponseType;
import com.eucalyptus.blockstorage.msgs.DescribeStorageVolumesType;
import com.eucalyptus.blockstorage.msgs.GetVolumeTokenResponseType;
import com.eucalyptus.blockstorage.msgs.GetVolumeTokenType;
import com.eucalyptus.blockstorage.msgs.StorageVolume;
import com.eucalyptus.blockstorage.util.StorageProperties;
import com.eucalyptus.cloud.ResourceToken;
import com.eucalyptus.cloud.VmInstanceLifecycleHelpers;
import com.eucalyptus.cloud.VmRunType;
import com.eucalyptus.cloud.run.Allocations;
import com.eucalyptus.cloud.util.MetadataException;
import com.eucalyptus.cloud.util.NotEnoughResourcesException;
import com.eucalyptus.cluster.Cluster;
import com.eucalyptus.cluster.Clusters;
import com.eucalyptus.cluster.ResourceState;
import com.eucalyptus.cluster.callback.ResourceStateCallback;
import com.eucalyptus.cluster.callback.VmRunCallback;
import com.eucalyptus.component.Partition;
import com.eucalyptus.component.Partitions;
import com.eucalyptus.component.ServiceConfiguration;
import com.eucalyptus.component.Topology;
import com.eucalyptus.component.auth.SystemCredentials;
import com.eucalyptus.component.id.ClusterController;
import com.eucalyptus.component.id.Euare;
import com.eucalyptus.component.id.Eucalyptus;
import com.eucalyptus.compute.common.BlockDeviceMappingItemType;
import com.eucalyptus.compute.common.backend.RunInstancesType;
import com.eucalyptus.compute.common.backend.StartInstancesType;
import com.eucalyptus.compute.identifier.ResourceIdentifiers;
import com.eucalyptus.crypto.Certs;
import com.eucalyptus.crypto.Ciphers;
import com.eucalyptus.crypto.Crypto;
import com.eucalyptus.crypto.Digest;
import com.eucalyptus.crypto.util.B64;
import com.eucalyptus.crypto.util.PEMFiles;
import com.eucalyptus.entities.Entities;
import com.eucalyptus.entities.TransactionResource;
import com.eucalyptus.images.BlockStorageImageInfo;
import com.eucalyptus.images.Images;
import com.eucalyptus.keys.SshKeyPair;
import com.eucalyptus.records.EventRecord;
import com.eucalyptus.records.EventType;
import com.eucalyptus.records.Logs;
import com.eucalyptus.system.Threads;
import com.eucalyptus.system.tracking.MessageContexts;
import com.eucalyptus.util.EucalyptusCloudException;
import com.eucalyptus.util.Exceptions;
import com.eucalyptus.util.LogUtil;
import com.eucalyptus.util.OwnerFullName;
import com.eucalyptus.util.async.AsyncRequests;
import com.eucalyptus.util.async.RemoteCallback;
import com.eucalyptus.util.async.Request;
import com.eucalyptus.util.async.StatefulMessageSet;
import com.eucalyptus.vm.VmEphemeralAttachment;
import com.eucalyptus.vm.VmInstance;
import com.eucalyptus.vm.VmInstances;
import com.eucalyptus.vm.VmVolumeAttachment;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import edu.ucsb.eucalyptus.cloud.VirtualBootRecord;
import edu.ucsb.eucalyptus.cloud.VmKeyInfo;
import edu.ucsb.eucalyptus.msgs.BaseMessage;
import edu.ucsb.eucalyptus.msgs.VmTypeInfo;
import java.security.Key;
import java.security.KeyPair;
import java.security.MessageDigest;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import javax.persistence.EntityTransaction;
import org.apache.log4j.Logger;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.encoders.Base64;

public class ClusterAllocator
implements Runnable {
    private static final long BYTES_PER_GB = 0x40000000L;
    private static Logger LOG = Logger.getLogger(ClusterAllocator.class);
    public static Boolean SPLIT_REQUESTS = true;
    private StatefulMessageSet<State> messages;
    private final Allocations.Allocation allocInfo;
    private Cluster cluster;

    public static Predicate<Allocations.Allocation> get() {
        return SubmitAllocation.INSTANCE;
    }

    private ClusterAllocator(Allocations.Allocation allocInfo, ServiceConfiguration clusterConfig) {
        this.allocInfo = allocInfo;
        EntityTransaction db = Entities.get(VmInstance.class);
        try {
            this.cluster = Clusters.lookup(clusterConfig);
            this.messages = new StatefulMessageSet(this.cluster, (Enum[])State.values());
            this.setupNetworkMessages();
            this.setupVolumeMessages();
            this.setupCredentialMessages();
            this.updateResourceMessages();
            db.commit();
        }
        catch (Exception e) {
            db.rollback();
            this.cleanupOnFailure(allocInfo, e);
            return;
        }
        try {
            for (ResourceToken token : allocInfo.getAllocationTokens()) {
                this.setupVmMessages(token);
            }
        }
        catch (Exception e) {
            this.cleanupOnFailure(allocInfo, e);
        }
    }

    private void updateResourceMessages() {
        HashSet clustersToUpdate = Sets.newHashSet();
        for (ResourceToken token : this.allocInfo.getAllocationTokens()) {
            if (!token.isUnorderedType()) continue;
            clustersToUpdate.add(token.getCluster());
        }
        for (Cluster cluster : clustersToUpdate) {
            ResourceStateCallback cb = new ResourceStateCallback();
            cb.setSubject(cluster);
            Request request = AsyncRequests.newRequest((RemoteCallback)cb);
            this.messages.addRequest(State.UPDATE_RESOURCES, request);
        }
    }

    private void cleanupOnFailure(Allocations.Allocation allocInfo, Exception e) {
        LOG.error((Object)e);
        Logs.extreme().error((Object)e, (Throwable)e);
        this.allocInfo.abort();
        for (ResourceToken token : allocInfo.getAllocationTokens()) {
            try {
                VmInstance vm = VmInstances.lookup(token.getInstanceId());
                if (VmInstance.VmState.STOPPED.equals(vm.getLastState())) {
                    VmInstances.stopped(vm);
                    continue;
                }
                VmInstances.terminated(vm);
            }
            catch (Exception e1) {
                LOG.error((Object)e1);
                Logs.extreme().error((Object)e1, (Throwable)e1);
            }
        }
    }

    private void setupCredentialMessages() {
        try {
            User owner = Accounts.lookupUserById((String)this.allocInfo.getOwnerFullName().getUserId());
            if (!owner.isSystemAdmin()) {
                return;
            }
        }
        catch (AuthException ex) {
            return;
        }
        if (this.allocInfo.getUserData() == null || this.allocInfo.getUserData().length <= 0) {
            return;
        }
        String userData = new String(this.allocInfo.getUserData());
        if (!VmInstances.VmSpecialUserData.apply(userData)) {
            return;
        }
        String payload = null;
        int expirationDays = 180;
        try {
            VmInstances.VmSpecialUserData specialData = new VmInstances.VmSpecialUserData(userData);
            if (!VmInstances.VmSpecialUserData.EUCAKEY_CRED_SETUP.equals(specialData.getKey())) {
                return;
            }
            String strExpDay = specialData.getExpirationDays();
            if (strExpDay != null) {
                expirationDays = Integer.parseInt(strExpDay);
            }
            payload = specialData.getPayload();
        }
        catch (Exception ex) {
            LOG.error((Object)"Failed to parse VM user data", (Throwable)ex);
            return;
        }
        for (String s : this.allocInfo.getInstanceIds()) {
            try {
                TransactionResource db = Entities.transactionFor(VmInstance.class);
                Throwable throwable = null;
                try {
                    VmInstance instance = VmInstances.lookup(s);
                    instance.setUserDataAsString(payload);
                }
                catch (Throwable x2) {
                    throwable = x2;
                    throw x2;
                }
                finally {
                    if (db == null) continue;
                    if (throwable != null) {
                        try {
                            db.close();
                        }
                        catch (Throwable x2) {
                            throwable.addSuppressed(x2);
                        }
                        continue;
                    }
                    db.close();
                }
            }
            catch (NoSuchElementException e) {
                LOG.error((Object)("Can't find instance " + s + " to change its user data"));
            }
        }
        try {
            KeyPair kp = Certs.generateKeyPair();
            ServiceConfiguration euare = Topology.lookup(Euare.class, (Partition[])new Partition[0]);
            SignCertificateType req = new SignCertificateType();
            String pubkey = B64.standard.encString((byte[])kp.getPublic().getEncoded());
            req.setKey(pubkey);
            req.setInstance(this.allocInfo.getInstanceId(0));
            req.setExpirationDays(Integer.valueOf(expirationDays));
            SignCertificateResponseType resp = (SignCertificateResponseType)AsyncRequests.sendSync((ServiceConfiguration)euare, (BaseMessage)req);
            X509Certificate kpCert = PEMFiles.getCert((byte[])B64.standard.dec((String)resp.getSignCertificateResult().getCertificate()));
            String b64PubKey = B64.standard.encString((byte[])PEMFiles.getBytes((Object)kpCert));
            MessageDigest digest = Digest.SHA256.get();
            byte[] salt = new byte[32];
            ((SecureRandom)Crypto.getSecureRandomSupplier().get()).nextBytes(salt);
            digest.update(salt);
            SecretKeySpec symmKey = new SecretKeySpec(digest.digest(), "AES");
            Cipher cipher = Ciphers.AES_GCM.get();
            byte[] iv = new byte[12];
            ((SecureRandom)Crypto.getSecureRandomSupplier().get()).nextBytes(iv);
            cipher.init(1, (Key)symmKey, new IvParameterSpec(iv), (SecureRandom)Crypto.getSecureRandomSupplier().get());
            byte[] cipherText = cipher.doFinal(Base64.encode((byte[])PEMFiles.getBytes((Object)kp.getPrivate())));
            String encPrivKey = new String(Base64.encode((byte[])Arrays.concatenate((byte[])iv, (byte[])cipherText)));
            String token = "NULL";
            cipher = Ciphers.AES_GCM.get();
            cipher.init(1, (Key)symmKey, new IvParameterSpec(iv), (SecureRandom)Crypto.getSecureRandomSupplier().get());
            byte[] byteToken = cipher.doFinal("NULL".getBytes());
            String encToken = new String(Base64.encode((byte[])Arrays.concatenate((byte[])iv, (byte[])byteToken)));
            X509Certificate nodeCert = this.allocInfo.getPartition().getNodeCertificate();
            cipher = Ciphers.RSA_PKCS1.get();
            cipher.init(1, (Key)nodeCert.getPublicKey(), (SecureRandom)Crypto.getSecureRandomSupplier().get());
            byte[] symmkey = cipher.doFinal(symmKey.getEncoded());
            String encSymmKey = new String(Base64.encode((byte[])symmkey));
            X509Certificate euareCert = SystemCredentials.lookup(Euare.class).getCertificate();
            String b64EuarePubkey = B64.standard.encString((byte[])PEMFiles.getBytes((Object)euareCert));
            X509Certificate eucalyptusCert = SystemCredentials.lookup(Eucalyptus.class).getCertificate();
            String b64EucalyptusPubkey = B64.standard.encString((byte[])PEMFiles.getBytes((Object)eucalyptusCert));
            String credential = String.format("%s\n%s\n%s\n%s\n%s\n%s", b64EuarePubkey, b64PubKey, encToken, encSymmKey, encPrivKey, b64EucalyptusPubkey);
            this.allocInfo.setCredential(credential);
        }
        catch (Exception ex) {
            LOG.error((Object)"failed to setup instance credential", (Throwable)ex);
        }
    }

    /*
     * Could not resolve type clashes
     */
    private void setupVolumeMessages() throws NoSuchElementException, MetadataException, ExecutionException {
        if (this.allocInfo.getBootSet().getMachine() instanceof BlockStorageImageInfo) {
            ArrayList instanceDeviceMappings = new ArrayList(this.allocInfo.getRequest().getBlockDeviceMapping());
            final ServiceConfiguration sc = Topology.lookup(Storage.class, (Partition[])new Partition[]{this.cluster.getConfiguration().lookupPartition()});
            BlockStorageImageInfo imgInfo = (BlockStorageImageInfo)this.allocInfo.getBootSet().getMachine();
            String rootDevName = imgInfo.getRootDeviceName();
            Long volSizeBytes = imgInfo.getImageSizeBytes();
            for (BlockDeviceMappingItemType blockDevMapping : Iterables.filter(instanceDeviceMappings, Images.findEbsRootOptionalSnapshot(rootDevName))) {
                if (blockDevMapping.getEbs().getVolumeSize() == null) continue;
                volSizeBytes = 0x40000000L * (long)blockDevMapping.getEbs().getVolumeSize().intValue();
            }
            int rootVolSizeInGb = (int)Math.ceil((double)volSizeBytes.longValue() / 1.073741824E9);
            for (ResourceToken token : this.allocInfo.getAllocationTokens()) {
                VmInstance vm = VmInstances.lookup(token.getInstanceId());
                if (!vm.getBootRecord().hasPersistentVolumes()) {
                    if (!instanceDeviceMappings.isEmpty()) {
                        for (BlockDeviceMappingItemType mapping : instanceDeviceMappings) {
                            if (Images.isEbsMapping(mapping).booleanValue()) {
                                Volume volume;
                                int volumeSize;
                                LOG.debug((Object)("About to prepare volume for instance " + vm.getDisplayName() + " to be mapped to " + mapping.getDeviceName() + " device"));
                                int n = volumeSize = mapping.getEbs().getVolumeSize() != null ? mapping.getEbs().getVolumeSize() : -1;
                                if (volumeSize <= 0) {
                                    if (mapping.getEbs().getSnapshotId() != null) {
                                        Snapshot originalSnapshot = Snapshots.lookup(null, (String)ResourceIdentifiers.tryNormalize().apply((Object)mapping.getEbs().getSnapshotId()));
                                        volumeSize = originalSnapshot.getVolumeSize();
                                    } else {
                                        volumeSize = rootVolSizeInGb;
                                    }
                                }
                                final UserFullName fullName = this.allocInfo.getOwnerFullName();
                                final String snapshotId = (String)ResourceIdentifiers.tryNormalize().apply((Object)mapping.getEbs().getSnapshotId());
                                final int volSize = volumeSize;
                                RunInstancesType request = this.allocInfo.getRequest();
                                Callable<Volume> createVolume = new Callable<Volume>((BaseMessage)request){
                                    final /* synthetic */ BaseMessage val$request;
                                    {
                                        this.val$request = baseMessage;
                                    }

                                    @Override
                                    public Volume call() throws Exception {
                                        return Volumes.createStorageVolume(sc, fullName, snapshotId, volSize, this.val$request);
                                    }
                                };
                                try {
                                    volume = (Volume)((Object)Threads.enqueue(Eucalyptus.class, ClusterAllocator.class, (Callable)createVolume).get());
                                }
                                catch (InterruptedException e) {
                                    throw Exceptions.toUndeclared((String)"Interrupted when creating volume from snapshot.", (Throwable[])new InterruptedException[]{e});
                                }
                                Boolean isRootDevice = mapping.getDeviceName().equals(rootDevName);
                                if (mapping.getEbs().getDeleteOnTermination().booleanValue()) {
                                    vm.addPersistentVolume(mapping.getDeviceName(), volume, isRootDevice);
                                } else {
                                    vm.addPermanentVolume(mapping.getDeviceName(), volume, isRootDevice);
                                }
                                if (isRootDevice.booleanValue()) {
                                    token.setRootVolume(volume);
                                    continue;
                                }
                                token.getEbsVolumes().put(mapping.getDeviceName(), volume);
                                continue;
                            }
                            if (mapping.getVirtualName() == null) continue;
                            vm.addEphemeralAttachment(mapping.getDeviceName(), mapping.getVirtualName());
                            token.getEphemeralDisks().put(mapping.getDeviceName(), mapping.getVirtualName());
                        }
                        continue;
                    }
                    LOG.error((Object)("Volume attachment for root device not found. Attach an EBS volume to root device of " + vm.getInstanceId() + " and retry"));
                    throw new MetadataException("Volume attachment for root device not found. Attach an EBS volume to root device of " + vm.getInstanceId() + " and retry");
                }
                boolean foundRoot = false;
                for (Comparable<VmVolumeAttachment> attachment : vm.getBootRecord().getPersistentVolumes()) {
                    Volume volume = Volumes.lookup(null, ((VmVolumeAttachment)attachment).getVolumeId());
                    if (((VmVolumeAttachment)attachment).getIsRootDevice().booleanValue() || ((VmVolumeAttachment)attachment).getDevice().equals(rootDevName)) {
                        token.setRootVolume(volume);
                        foundRoot = true;
                        continue;
                    }
                    token.getEbsVolumes().put(((VmVolumeAttachment)attachment).getDevice(), volume);
                }
                if (!foundRoot) {
                    LOG.error((Object)("Volume attachment for root device not found. Attach an EBS volume to root device of " + vm.getInstanceId() + " and retry"));
                    throw new MetadataException("Volume attachment for root device not found. Attach an EBS volume to root device of " + vm.getInstanceId() + " and retry");
                }
                for (Comparable<VmVolumeAttachment> attachment : vm.getBootRecord().getEphemeralStorage()) {
                    token.getEphemeralDisks().put(((VmEphemeralAttachment)attachment).getDevice(), ((VmEphemeralAttachment)attachment).getEphemeralId());
                }
            }
        }
    }

    private void setupNetworkMessages() throws NotEnoughResourcesException {
        VmInstanceLifecycleHelpers.get().prepareNetworkMessages(this.allocInfo, this.messages);
    }

    private void setupVmMessages(final ResourceToken token) throws Exception {
        VmTypeInfo vmInfo = this.allocInfo.getVmTypeInfo(this.allocInfo.getPartition(), token.getAllocationInfo().getReservationId());
        this.allocInfo.setRootDirective();
        try {
            VmTypeInfo childVmInfo = this.makeVmTypeInfo(vmInfo, token);
            VmRunCallback callback = this.makeRunCallback(token, childVmInfo);
            Request req = AsyncRequests.newRequest((RemoteCallback)callback);
            this.messages.addRequest(State.CREATE_VMS, req);
            this.messages.addCleanup(new Runnable(){

                @Override
                public void run() {
                    if (token.isPending()) {
                        try {
                            token.release();
                        }
                        catch (ResourceState.NoSuchTokenException e) {
                            Logs.extreme().error((Object)e, (Throwable)e);
                        }
                    }
                }
            });
            LOG.debug((Object)("Queued RunInstances: " + token));
        }
        catch (Exception ex) {
            Logs.extreme().error((Object)ex, (Throwable)ex);
            throw ex;
        }
    }

    private VmTypeInfo makeVmTypeInfo(VmTypeInfo vmInfo, ResourceToken token) throws Exception {
        VmTypeInfo childVmInfo = vmInfo.child();
        if (this.allocInfo.getBootSet().getMachine() instanceof BlockStorageImageInfo) {
            String instanceId = token.getInstanceId();
            VmInstance vm = VmInstances.lookup(instanceId);
            HashMap volumeAttachmentTokenMap = Maps.newHashMap();
            VirtualBootRecord rootVbr = childVmInfo.lookupRoot();
            Volume rootVolume = token.getRootVolume();
            String volumeId = rootVolume.getDisplayName();
            String volumeToken = null;
            LOG.debug((Object)("Wait for root ebs volume " + rootVolume.getDisplayName() + " to become available"));
            ServiceConfiguration scConfig = this.waitForVolume(rootVolume);
            try {
                GetVolumeTokenResponseType scGetTokenResponse;
                LOG.debug((Object)("About to get attachment token for volume " + rootVolume.getDisplayName() + " to instance " + instanceId));
                try {
                    GetVolumeTokenType req = new GetVolumeTokenType(volumeId);
                    scGetTokenResponse = (GetVolumeTokenResponseType)AsyncRequests.sendSync((ServiceConfiguration)scConfig, (BaseMessage)req);
                }
                catch (Exception e) {
                    LOG.debug((Object)e, (Throwable)e);
                    throw new EucalyptusCloudException(e.getMessage(), (Throwable)e);
                }
                LOG.debug((Object)("Got volume token response from SC for volume " + rootVolume.getDisplayName() + " and instance " + instanceId + "\n" + scGetTokenResponse));
                volumeToken = scGetTokenResponse.getToken();
                if (volumeToken == null) {
                    throw new EucalyptusCloudException("Failed to get remote device string for " + volumeId + " while running instance " + token.getInstanceId());
                }
                volumeToken = StorageProperties.formatVolumeAttachmentTokenForTransfer((String)volumeToken, (String)volumeId);
                rootVbr.setResourceLocation(volumeToken);
                rootVbr.setSize(Long.valueOf((long)rootVolume.getSize().intValue() * 0x40000000L));
                volumeAttachmentTokenMap.put(volumeId, volumeToken);
            }
            catch (Exception ex) {
                LOG.error((Object)ex);
                Logs.extreme().error((Object)ex, (Throwable)ex);
                throw ex;
            }
            for (Map.Entry<String, Volume> mapping : token.getEbsVolumes().entrySet()) {
                Volume volume = mapping.getValue();
                if (volume.getSize() <= 0) {
                    volume = Volumes.lookup((OwnerFullName)this.allocInfo.getOwnerFullName(), mapping.getValue().getDisplayName());
                }
                volumeId = volume.getDisplayName();
                LOG.debug((Object)("Wait for volume " + volumeId + " to become available"));
                ServiceConfiguration scConfigLocal = this.waitForVolume(volume);
                try {
                    GetVolumeTokenResponseType scGetTokenResponse;
                    LOG.debug((Object)("About to get attachment token for volume " + volume.getDisplayName() + " to instance " + instanceId));
                    try {
                        GetVolumeTokenType req = new GetVolumeTokenType(volumeId);
                        scGetTokenResponse = (GetVolumeTokenResponseType)AsyncRequests.sendSync((ServiceConfiguration)scConfigLocal, (BaseMessage)req);
                    }
                    catch (Exception e) {
                        LOG.debug((Object)e, (Throwable)e);
                        throw new EucalyptusCloudException(e.getMessage(), (Throwable)e);
                    }
                    LOG.debug((Object)("Got volume token response from SC for volume " + volume.getDisplayName() + " and instance " + instanceId + "\n" + scGetTokenResponse));
                    volumeToken = scGetTokenResponse.getToken();
                    if (volumeToken == null) {
                        throw new EucalyptusCloudException("Failed to get remote device string for " + volumeId + " while running instance " + token.getInstanceId());
                    }
                    volumeToken = StorageProperties.formatVolumeAttachmentTokenForTransfer((String)volumeToken, (String)volumeId);
                    VirtualBootRecord vbr = new VirtualBootRecord(volumeId, volumeToken, "ebs", mapping.getKey(), Long.valueOf((long)volume.getSize().intValue() * 0x40000000L), "none");
                    childVmInfo.getVirtualBootRecord().add(vbr);
                    volumeAttachmentTokenMap.put(volumeId, volumeToken);
                }
                catch (Exception ex) {
                    LOG.error((Object)ex);
                    Logs.extreme().error((Object)ex, (Throwable)ex);
                    throw ex;
                }
            }
            if (!volumeAttachmentTokenMap.isEmpty()) {
                vm.updateAttachmentToken(volumeAttachmentTokenMap);
            }
            for (String deviceName : token.getEphemeralDisks().keySet()) {
                childVmInfo.setEphemeral(Integer.valueOf(0), deviceName, Long.valueOf((long)this.allocInfo.getVmType().getDisk().intValue() * 0x40000000L), "none");
            }
            LOG.debug((Object)("Instance information: " + childVmInfo.dump()));
        }
        return childVmInfo;
    }

    public ServiceConfiguration waitForVolume(Volume vol) throws Exception {
        ServiceConfiguration scConfig = Topology.lookup(Storage.class, (Partition[])new Partition[]{Partitions.lookupByName((String)vol.getPartition())});
        long startTime = System.currentTimeMillis();
        int numDescVolError = 0;
        while (System.currentTimeMillis() - startTime < (long)(VmInstances.EBS_VOLUME_CREATION_TIMEOUT * 60) * 1000L) {
            try {
                DescribeStorageVolumesResponseType volState = null;
                try {
                    DescribeStorageVolumesType describeMsg = new DescribeStorageVolumesType(Lists.newArrayList((Object[])new String[]{vol.getDisplayName()}));
                    volState = (DescribeStorageVolumesResponseType)AsyncRequests.sendSync((ServiceConfiguration)scConfig, (BaseMessage)describeMsg);
                }
                catch (Exception e) {
                    if (numDescVolError++ < 5) {
                        try {
                            TimeUnit.SECONDS.sleep(5L);
                        }
                        catch (InterruptedException ex) {
                            Thread.currentThread().interrupt();
                        }
                        continue;
                    }
                    throw e;
                }
                StorageVolume storageVolume = (StorageVolume)volState.getVolumeSet().get(0);
                LOG.debug((Object)("Got storage volume info: " + storageVolume));
                if ("available".equals(storageVolume.getStatus())) {
                    return scConfig;
                }
                if ("failed".equals(storageVolume.getStatus())) {
                    throw new EucalyptusCloudException("volume creation failed");
                }
                TimeUnit.SECONDS.sleep(5L);
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
            }
            catch (Exception ex) {
                LOG.error((Object)ex, (Throwable)ex);
                throw ex;
            }
        }
        throw new EucalyptusCloudException("volume " + vol.getDisplayName() + " was not created in time");
    }

    private VmRunCallback makeRunCallback(ResourceToken childToken, VmTypeInfo vmInfo) {
        SshKeyPair keyPair = this.allocInfo.getSshKeyPair();
        VmKeyInfo vmKeyInfo = new VmKeyInfo((Object)keyPair.getName(), (Object)keyPair.getPublicKey(), (Object)keyPair.getFingerPrint());
        String platform = this.allocInfo.getBootSet().getMachine().getPlatform().name() != null ? this.allocInfo.getBootSet().getMachine().getPlatform().name() : "linux";
        VmRunType.Builder builder = VmRunType.builder();
        VmInstanceLifecycleHelpers.get().prepareVmRunType(childToken, builder);
        VmRunType run = builder.instanceId(childToken.getInstanceId()).naturalId(childToken.getInstanceUuid()).keyInfo(vmKeyInfo).launchIndex(childToken.getLaunchIndex()).networkNames(this.allocInfo.getNetworkGroups()).platform(platform).reservationId(childToken.getAllocationInfo().getReservationId()).userData(this.allocInfo.getRequest().getUserData()).credential(this.allocInfo.getCredential()).vmTypeInfo(vmInfo).owner(this.allocInfo.getOwnerFullName()).rootDirective(this.allocInfo.getRootDirective()).create();
        return new VmRunCallback(run, childToken);
    }

    @Override
    public void run() {
        this.messages.run();
    }

    static enum SubmitAllocation implements Predicate<Allocations.Allocation>
    {
        INSTANCE;


        public boolean apply(final Allocations.Allocation allocInfo) {
            try {
                String instId;
                if (EventRecord.isDebugEnabled(ClusterAllocator.class)) {
                    EventRecord.here(ClusterAllocator.class, (EventType)EventType.VM_PREPARE, (String[])new String[]{LogUtil.dumpObject((Object)allocInfo)}).debug();
                }
                final ServiceConfiguration config = Topology.lookup(ClusterController.class, (Partition[])new Partition[]{allocInfo.getPartition()});
                Callable<Boolean> runnable = new Callable<Boolean>(){

                    @Override
                    public Boolean call() {
                        try {
                            new ClusterAllocator(allocInfo, config).run();
                        }
                        catch (Exception ex) {
                            LOG.error((Object)("Failed to prepare allocator for: " + allocInfo.getAllocationTokens()), (Throwable)ex);
                        }
                        return Boolean.TRUE;
                    }
                };
                BaseMessage baseReq = null;
                Iterator<String> i$ = allocInfo.getInstanceIds().iterator();
                while (i$.hasNext() && (baseReq = MessageContexts.lookupLast((String)(instId = i$.next()), (Set)Sets.newHashSet((Object[])new Class[]{RunInstancesType.class, StartInstancesType.class}))) == null) {
                }
                Threads.enqueue((ServiceConfiguration)config, (Integer)32, (Callable)runnable, (String)(baseReq == null ? null : baseReq.getCorrelationId()));
                return true;
            }
            catch (Exception ex) {
                throw Exceptions.toUndeclared((Throwable)ex);
            }
        }
    }

    public static enum State {
        START,
        CREATE_VOLS,
        CREATE_IGROUPS,
        CREATE_NETWORK,
        CREATE_NETWORK_RULES,
        CREATE_VMS,
        UPDATE_RESOURCES,
        ATTACH_VOLS,
        ASSIGN_ADDRESSES,
        FINISHED,
        ROLLBACK;

    }
}

