/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.cloud.run;

import com.eucalyptus.auth.Accounts;
import com.eucalyptus.auth.AuthContextSupplier;
import com.eucalyptus.auth.AuthException;
import com.eucalyptus.auth.Permissions;
import com.eucalyptus.auth.principal.User;
import com.eucalyptus.auth.principal.UserFullName;
import com.eucalyptus.cloud.ResourceToken;
import com.eucalyptus.cloud.util.MetadataException;
import com.eucalyptus.cloud.util.NotEnoughResourcesException;
import com.eucalyptus.component.Partition;
import com.eucalyptus.compute.common.backend.RunInstancesType;
import com.eucalyptus.compute.vpc.Subnet;
import com.eucalyptus.context.Context;
import com.eucalyptus.context.Contexts;
import com.eucalyptus.entities.Entities;
import com.eucalyptus.entities.TransientEntityException;
import com.eucalyptus.images.Emis;
import com.eucalyptus.images.MachineImageInfo;
import com.eucalyptus.keys.KeyPairs;
import com.eucalyptus.keys.SshKeyPair;
import com.eucalyptus.network.ExtantNetwork;
import com.eucalyptus.network.NetworkGroup;
import com.eucalyptus.records.Logs;
import com.eucalyptus.util.TypedContext;
import com.eucalyptus.util.TypedKey;
import com.eucalyptus.util.UniqueIds;
import com.eucalyptus.vm.VmInstance;
import com.eucalyptus.vm.VmInstances;
import com.eucalyptus.vm.VmNetworkConfig;
import com.eucalyptus.vmtypes.VmType;
import com.eucalyptus.vmtypes.VmTypes;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import edu.ucsb.eucalyptus.cloud.VmInfo;
import edu.ucsb.eucalyptus.msgs.HasRequest;
import edu.ucsb.eucalyptus.msgs.VmTypeInfo;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.persistence.EntityTransaction;
import org.apache.log4j.Logger;
import org.bouncycastle.util.encoders.Base64;

public class Allocations {
    private static Logger LOG = Logger.getLogger(Allocations.class);

    public static Allocation run(RunInstancesType request) {
        return new Allocation(request);
    }

    public static Allocation start(VmInstance vm) {
        Emis.BootableSet bootSet = Emis.recreateBootableSet(vm);
        return new Allocation(vm.getReservationId(), vm.getInstanceId(), vm.getInstanceUuid(), vm.getUserData(), vm.getExpiration(), vm.lookupPartition(), vm.getKeyPair(), bootSet, vm.getVmType(), vm.getNetworkGroups(), vm.isUsePrivateAddressing(), vm.getMonitoring(), vm.getClientToken(), vm.getIamInstanceProfileArn(), vm.getIamInstanceProfileId(), vm.getIamRoleArn());
    }

    public static Allocation restore(VmInfo input, int launchIndex, VmType vmType, Emis.BootableSet bootSet, Partition partition, SshKeyPair sshKeyPair, byte[] userData, UserFullName ownerFullName) {
        return new Allocation(input.getReservationId(), input.getInstanceId(), input.getUuid(), launchIndex, VmNetworkConfig.DEFAULT_IP.equals(input.getNetParams().getIgnoredPublicIp()) || Strings.isNullOrEmpty((String)input.getNetParams().getIgnoredPublicIp()), vmType, bootSet, partition, sshKeyPair, userData, ownerFullName);
    }

    public static class Allocation
    implements HasRequest {
        private final Context context;
        private final RunInstancesType request;
        private final UserFullName ownerFullName;
        private byte[] userData;
        private String credential;
        private String rootDirective;
        private final int minCount;
        private final int maxCount;
        private boolean usePrivateAddressing;
        private final boolean monitoring;
        @Nullable
        private final String clientToken;
        private Partition partition;
        private SshKeyPair sshKeyPair;
        private Emis.BootableSet bootSet;
        private VmType vmType;
        private Subnet subnet;
        private NetworkGroup primaryNetwork;
        private Map<String, NetworkGroup> networkGroups = Maps.newHashMap();
        private String iamInstanceProfileArn;
        private String iamInstanceProfileId;
        private String iamRoleArn;
        private final String reservationId;
        private final List<ResourceToken> allocationTokens = Lists.newArrayList();
        private final Long reservationIndex;
        private final Map<Integer, String> instanceIds;
        private final Map<Integer, String> instanceUuids;
        private Date expiration;
        private final TypedContext allocationContext = TypedContext.newTypedContext();
        private final AtomicBoolean committed = new AtomicBoolean(false);

        private Allocation(RunInstancesType request) {
            this.context = Contexts.lookup();
            this.instanceIds = Maps.newHashMap();
            this.instanceUuids = Maps.newHashMap();
            this.request = request;
            this.minCount = request.getMinCount();
            this.maxCount = request.getMaxCount();
            this.usePrivateAddressing = "private".equals(request.getAddressingType());
            this.monitoring = request.getMonitoring() == null ? Boolean.FALSE : request.getMonitoring();
            this.clientToken = Strings.emptyToNull((String)request.getClientToken());
            this.ownerFullName = this.context.getUserFullName();
            if (this.request.getInstanceType() == null || "".equals(this.request.getInstanceType())) {
                this.request.setInstanceType(VmTypes.defaultTypeName());
            }
            this.reservationIndex = UniqueIds.nextIndex(VmInstance.class, (long)request.getMaxCount());
            this.reservationId = VmInstances.getId(this.reservationIndex, 0).replaceAll("i-", "r-");
            this.request.setMonitoring(Boolean.valueOf(this.monitoring));
            if (this.request.getUserData() != null) {
                try {
                    this.userData = Base64.decode((String)this.request.getUserData());
                    this.request.setUserData(new String(Base64.encode((byte[])this.userData)));
                }
                catch (Exception exception) {}
            } else {
                try {
                    this.request.setUserData(new String(Base64.encode((byte[])new byte[0])));
                }
                catch (Exception ex) {
                    LOG.error((Object)ex, (Throwable)ex);
                }
            }
            this.credential = null;
        }

        private Allocation(String reservationId, String instanceId, String instanceUuid, int launchIndex, boolean usePrivateAddressing, VmType vmType, Emis.BootableSet bootSet, Partition partition, SshKeyPair sshKeyPair, byte[] userData, UserFullName ownerFullName) {
            this.minCount = 1;
            this.maxCount = 1;
            this.vmType = vmType;
            this.bootSet = bootSet;
            this.partition = partition;
            this.sshKeyPair = sshKeyPair;
            this.userData = userData;
            this.ownerFullName = ownerFullName;
            this.reservationId = reservationId;
            this.reservationIndex = -1L;
            this.instanceIds = Maps.newHashMap();
            this.instanceIds.put(launchIndex, instanceId);
            this.instanceUuids = Maps.newHashMap();
            this.instanceUuids.put(launchIndex, instanceUuid);
            this.allocationTokens.add(new ResourceToken(this, launchIndex));
            this.context = null;
            this.monitoring = false;
            this.usePrivateAddressing = usePrivateAddressing;
            this.clientToken = null;
            this.request = this.inferRequest();
        }

        private Allocation(String reservationId, String instanceId, String instanceUuid, byte[] userData, Date expiration, Partition partition, SshKeyPair sshKeyPair, Emis.BootableSet bootSet, VmType vmType, final Set<NetworkGroup> networkGroups, boolean isUsePrivateAddressing, boolean monitoring, String clientToken, String iamInstanceProfileArn, String iamInstanceProfileId, String iamRoleArn) {
            this.context = Contexts.lookup();
            this.minCount = 1;
            this.maxCount = 1;
            this.usePrivateAddressing = isUsePrivateAddressing;
            this.ownerFullName = this.context.getUserFullName();
            this.reservationId = reservationId;
            this.reservationIndex = UniqueIds.nextIndex(VmInstance.class, (long)this.maxCount);
            this.instanceIds = Maps.newHashMap();
            this.instanceIds.put(0, instanceId);
            this.instanceUuids = Maps.newHashMap();
            this.instanceUuids.put(0, instanceUuid);
            this.userData = userData;
            this.partition = partition;
            this.sshKeyPair = sshKeyPair != null ? sshKeyPair : KeyPairs.noKey();
            this.bootSet = bootSet;
            this.expiration = expiration;
            this.vmType = vmType;
            this.monitoring = monitoring;
            this.clientToken = clientToken;
            this.iamInstanceProfileArn = iamInstanceProfileArn;
            this.iamInstanceProfileId = iamInstanceProfileId;
            this.iamRoleArn = iamRoleArn;
            this.credential = null;
            this.networkGroups = new HashMap<String, NetworkGroup>(){
                {
                    for (NetworkGroup g : networkGroups) {
                        if (Allocation.this.primaryNetwork == null) {
                            Allocation.this.primaryNetwork = g;
                        }
                        this.put(g.getDisplayName(), g);
                    }
                }
            };
            this.request = this.inferRequest();
        }

        private RunInstancesType inferRequest() {
            return new RunInstancesType(){
                {
                    this.setMinCount(1);
                    this.setMaxCount(1);
                    this.setImageId(Allocation.this.bootSet.getMachine().getDisplayName());
                    this.setAvailabilityZone(Allocation.this.partition.getName());
                    this.setInstanceType(Allocation.this.vmType.getName());
                }
            };
        }

        public RunInstancesType getRequest() {
            return this.getRunInstancesRequest();
        }

        public RunInstancesType getRunInstancesRequest() {
            return this.request;
        }

        public NetworkGroup getPrimaryNetwork() {
            return this.primaryNetwork;
        }

        public ExtantNetwork getExtantNetwork() {
            EntityTransaction db = Entities.get(ExtantNetwork.class);
            try {
                NetworkGroup net = (NetworkGroup)((Object)Entities.merge((Object)((Object)this.primaryNetwork)));
                ExtantNetwork ex = net.extantNetwork();
                db.commit();
                return ex;
            }
            catch (TransientEntityException ex) {
                LOG.error((Object)ex, (Throwable)ex);
                db.rollback();
                throw new RuntimeException(ex);
            }
            catch (NotEnoughResourcesException ex) {
                db.rollback();
                return ExtantNetwork.bogus(this.getPrimaryNetwork());
            }
        }

        public void commit() throws Exception {
            if (!this.committed.get()) {
                try {
                    for (ResourceToken t : this.getAllocationTokens()) {
                        VmInstance.Create.INSTANCE.apply(t);
                    }
                    this.committed.set(true);
                }
                catch (Exception ex) {
                    this.abort();
                    throw ex;
                }
            }
        }

        public boolean isCommitted() {
            return this.committed.get();
        }

        public void abort() {
            for (ResourceToken token : this.allocationTokens) {
                LOG.warn((Object)("Aborting resource token: " + token));
                Logs.exhaust().error((Object)"Aborting resource token", (Throwable)new RuntimeException());
                EntityTransaction db = Entities.get(VmInstance.class);
                try {
                    token.abort();
                    db.commit();
                }
                catch (Exception ex) {
                    LOG.warn((Object)ex.getMessage());
                    Logs.exhaust().error((Object)ex, (Throwable)ex);
                    db.rollback();
                }
            }
        }

        public List<NetworkGroup> getNetworkGroups() {
            return Lists.newArrayList(this.networkGroups.values());
        }

        public VmType getVmType() {
            return this.vmType;
        }

        public Partition getPartition() {
            return this.partition;
        }

        public void setBootableSet(Emis.BootableSet bootSet) {
            this.bootSet = bootSet;
        }

        public void setVmType(VmType vmType) {
            this.vmType = vmType;
        }

        public Subnet getSubnet() {
            return this.subnet;
        }

        public void setSubnet(Subnet subnet) {
            this.subnet = subnet;
        }

        public UserFullName getOwnerFullName() {
            return this.ownerFullName;
        }

        public List<ResourceToken> getAllocationTokens() {
            return this.allocationTokens;
        }

        public void setUserData(byte[] userData) {
            this.userData = userData;
        }

        public byte[] getUserData() {
            return this.userData;
        }

        public void setCredential(String credential) {
            this.credential = credential;
        }

        public String getCredential() {
            return this.credential;
        }

        public void setRootDirective() {
            if (!this.bootSet.isBlockStorage()) {
                try {
                    MachineImageInfo emi = Emis.LookupMachine.INSTANCE.apply(this.getRequest().getImageId());
                    this.rootDirective = emi.getRootDirective();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        public String getRootDirective() {
            return this.rootDirective;
        }

        public Long getReservationIndex() {
            return this.reservationIndex;
        }

        public String getReservationId() {
            return this.reservationId;
        }

        public Emis.BootableSet getBootSet() {
            return this.bootSet;
        }

        @Deprecated
        public Context getContext() {
            return this.context;
        }

        public void setPartition(Partition partition2) {
            this.partition = partition2;
        }

        public SshKeyPair getSshKeyPair() {
            return this.sshKeyPair;
        }

        public void setSshKeyPair(SshKeyPair sshKeyPair) {
            this.sshKeyPair = sshKeyPair;
        }

        public void setNetworkRules(Map<String, NetworkGroup> networkRuleGroups) {
            Map.Entry<String, NetworkGroup> ent = networkRuleGroups.entrySet().iterator().next();
            this.primaryNetwork = ent.getValue();
            this.networkGroups = networkRuleGroups;
        }

        public VmTypeInfo getVmTypeInfo(Partition partition, String reservationId) throws MetadataException {
            return this.bootSet.populateVirtualBootRecord(this.vmType, partition, reservationId);
        }

        @Nullable
        public String getIamInstanceProfileArn() {
            return this.iamInstanceProfileArn;
        }

        public void setInstanceProfileArn(String instanceProfileArn) {
            this.iamInstanceProfileArn = instanceProfileArn;
        }

        public String getIamInstanceProfileId() {
            return this.iamInstanceProfileId;
        }

        public void setIamInstanceProfileId(String iamInstanceProfileId) {
            this.iamInstanceProfileId = iamInstanceProfileId;
        }

        public String getIamRoleArn() {
            return this.iamRoleArn;
        }

        public void setIamRoleArn(String iamRoleArn) {
            this.iamRoleArn = iamRoleArn;
        }

        public int getMinCount() {
            return this.minCount;
        }

        public int getMaxCount() {
            return this.maxCount;
        }

        public boolean isUsePrivateAddressing() {
            return this.usePrivateAddressing;
        }

        public void setUsePrivateAddressing(boolean usePrivateAddressing) {
            this.usePrivateAddressing = usePrivateAddressing;
        }

        public final boolean isMonitoring() {
            return this.monitoring;
        }

        @Nullable
        public String getClientToken() {
            return this.clientToken;
        }

        @Nullable
        public String getUniqueClientToken(@Nonnull Integer launchIndex) {
            return this.clientToken == null ? null : String.format("%s:%d:%s", this.getOwnerFullName().getAccountNumber(), launchIndex, this.clientToken);
        }

        public Set<String> getInstanceIds() {
            return Sets.newHashSet(this.instanceIds.values());
        }

        public String getInstanceId(int index) {
            if (!this.instanceIds.containsKey(index)) {
                this.instanceIds.put(index, VmInstances.getId(this.getReservationIndex(), index));
            }
            return this.instanceIds.get(index);
        }

        public String getInstanceUuid(int index) {
            if (!this.instanceUuids.containsKey(index)) {
                this.instanceUuids.put(index, UUID.randomUUID().toString());
            }
            return this.instanceUuids.get(index);
        }

        public Date getExpiration() {
            return this.expiration;
        }

        public void setExpiration(Date expiration) {
            this.expiration = expiration;
        }

        public <T> T getAttribute(TypedKey<T> key) {
            return (T)this.allocationContext.get(key);
        }

        public <T> T setAttribute(TypedKey<T> key, T value) {
            return (T)this.allocationContext.put(key, value);
        }

        public <T> T removeAttribute(TypedKey<T> key) {
            return (T)this.allocationContext.remove(key);
        }

        public AuthContextSupplier getAuthContext() throws AuthException {
            return this.context != null ? this.context.getAuthContext() : Permissions.createAuthContextSupplier((User)Accounts.lookupUserById((String)this.getOwnerFullName().getUserId()), Collections.emptyMap());
        }
    }
}

