/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.cloud.run;

import com.eucalyptus.blockstorage.Storage;
import com.eucalyptus.cloud.ResourceToken;
import com.eucalyptus.cloud.VmInstanceLifecycleHelper;
import com.eucalyptus.cloud.VmInstanceLifecycleHelpers;
import com.eucalyptus.cloud.run.Allocations;
import com.eucalyptus.cloud.util.IllegalMetadataAccessException;
import com.eucalyptus.cloud.util.NotEnoughResourcesException;
import com.eucalyptus.cluster.Cluster;
import com.eucalyptus.cluster.Clusters;
import com.eucalyptus.cluster.ResourceState;
import com.eucalyptus.component.Partition;
import com.eucalyptus.component.Partitions;
import com.eucalyptus.component.ServiceConfiguration;
import com.eucalyptus.component.Topology;
import com.eucalyptus.component.id.ClusterController;
import com.eucalyptus.compute.common.CloudMetadata;
import com.eucalyptus.compute.common.network.DnsHostNamesFeature;
import com.eucalyptus.compute.common.network.NetworkFeature;
import com.eucalyptus.compute.common.network.NetworkResource;
import com.eucalyptus.compute.common.network.Networking;
import com.eucalyptus.compute.common.network.PrepareNetworkResourcesResultType;
import com.eucalyptus.compute.common.network.PrepareNetworkResourcesType;
import com.eucalyptus.context.ServiceStateException;
import com.eucalyptus.entities.Entities;
import com.eucalyptus.images.BlockStorageImageInfo;
import com.eucalyptus.network.NetworkGroup;
import com.eucalyptus.records.EventRecord;
import com.eucalyptus.records.EventType;
import com.eucalyptus.records.Logs;
import com.eucalyptus.scripting.ScriptExecutionFailedException;
import com.eucalyptus.util.EucalyptusCloudException;
import com.eucalyptus.util.Exceptions;
import com.eucalyptus.util.HasName;
import com.eucalyptus.util.LogUtil;
import com.eucalyptus.util.OwnerFullName;
import com.eucalyptus.util.RestrictedTypes;
import com.eucalyptus.vm.VmInstance;
import com.eucalyptus.vmtypes.VmTypes;
import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.TreeMultimap;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.persistence.EntityTransaction;
import org.apache.log4j.Logger;

public class AdmissionControl {
    private static Logger LOG = Logger.getLogger(AdmissionControl.class);
    private static final List<ResourceAllocator> allocators = ImmutableList.of((Object)NodeResourceAllocator.INSTANCE, (Object)NetworkingAllocator.INSTANCE);
    private static final List<ResourceAllocator> restorers = ImmutableList.of((Object)NetworkingAllocator.INSTANCE);

    public static Predicate<Allocations.Allocation> run() {
        return RunAdmissionControl.INSTANCE;
    }

    public static Predicate<Allocations.Allocation> restore() {
        return Restore.INSTANCE;
    }

    private static void rollbackAllocations(Allocations.Allocation allocInfo, List<ResourceAllocator> finished, Exception e) {
        for (ResourceAllocator rollback : Lists.reverse(finished)) {
            try {
                rollback.fail(allocInfo, e);
            }
            catch (Exception e1) {
                LOG.debug((Object)e1, (Throwable)e1);
            }
        }
    }

    private static void runAllocatorSafely(Allocations.Allocation allocInfo, ResourceAllocator allocator) throws Exception {
        try {
            allocator.allocate(allocInfo);
        }
        catch (ScriptExecutionFailedException e) {
            if (e.getCause() != null) {
                throw new EucalyptusCloudException(e.getCause().getMessage(), e.getCause());
            }
            throw new EucalyptusCloudException(e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            LOG.debug((Object)e, (Throwable)e);
            try {
                allocator.fail(allocInfo, e);
            }
            catch (Exception e1) {
                LOG.debug((Object)e1, (Throwable)e1);
            }
            throw e;
        }
    }

    static enum NetworkingAllocator implements ResourceAllocator
    {
        INSTANCE;


        @Override
        public void allocate(Allocations.Allocation allocInfo) throws Exception {
            try {
                VmInstanceLifecycleHelper helper = VmInstanceLifecycleHelpers.get();
                PrepareNetworkResourcesType request = new PrepareNetworkResourcesType();
                request.setAvailabilityZone(allocInfo.getPartition().getName());
                request.setFeatures(Lists.newArrayList((Object[])new NetworkFeature[]{new DnsHostNamesFeature()}));
                helper.prepareNetworkAllocation(allocInfo, request);
                PrepareNetworkResourcesResultType result = Networking.getInstance().prepare(request);
                for (ResourceToken token : allocInfo.getAllocationTokens()) {
                    for (NetworkResource networkResource : result.getResources()) {
                        if (!token.getInstanceId().equals(networkResource.getOwnerId())) continue;
                        token.getAttribute(VmInstanceLifecycleHelpers.NetworkResourceVmInstanceLifecycleHelper.NetworkResourcesKey).add(networkResource);
                    }
                }
            }
            catch (Exception e) {
                throw (Exception)Objects.firstNonNull((Object)Exceptions.findCause((Throwable)e, NotEnoughResourcesException.class), (Object)e);
            }
        }

        @Override
        public void fail(Allocations.Allocation allocInfo, Throwable t) {
            allocInfo.abort();
        }
    }

    static enum NodeResourceAllocator implements ResourceAllocator
    {
        INSTANCE;


        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private List<ResourceToken> requestResourceToken(final Allocations.Allocation allocInfo, int tryAmount, int maxAmount) throws Exception {
            ServiceConfiguration config = Topology.lookup(ClusterController.class, (Partition[])new Partition[]{allocInfo.getPartition()});
            Cluster cluster = Clusters.lookup(config);
            if (cluster.getGateLock().readLock().tryLock(60L, TimeUnit.SECONDS)) {
                try {
                    boolean forceResourceRefresh;
                    final ResourceState state = cluster.getNodeState();
                    boolean unorderedType = VmTypes.isUnorderedType(allocInfo.getVmType());
                    boolean bl = forceResourceRefresh = state.hasUnorderedTokens() || unorderedType;
                    if (forceResourceRefresh) {
                        cluster.refreshResources();
                    }
                    RestrictedTypes.BatchAllocator<ResourceToken> allocator = new RestrictedTypes.BatchAllocator<ResourceToken>(){

                        public List<ResourceToken> allocate(int min, int max) {
                            try {
                                List<ResourceToken> ret = state.requestResourceAllocation(allocInfo, min, max);
                                allocInfo.getAllocationTokens().addAll(ret);
                                return ret;
                            }
                            catch (NotEnoughResourcesException e) {
                                throw Exceptions.toUndeclared((Throwable)e);
                            }
                        }
                    };
                    RestrictedTypes.allocateUnitlessResources(CloudMetadata.VmInstanceMetadata.class, (int)tryAmount, (int)maxAmount, (RestrictedTypes.BatchAllocator)allocator);
                    List<ResourceToken> list = allocInfo.getAllocationTokens();
                    return list;
                }
                finally {
                    cluster.getGateLock().readLock().unlock();
                }
            }
            throw new ServiceStateException("Failed to allocate resources in the zone " + cluster.getPartition() + ", it is currently locked for maintenance.");
        }

        @Override
        public void allocate(Allocations.Allocation allocInfo) throws Exception {
            int maxAmount;
            Partition reqPartition = allocInfo.getPartition();
            String zoneName = reqPartition.getName();
            String vmTypeName = allocInfo.getVmType().getName();
            int minAmount = allocInfo.getMinCount();
            if (minAmount > (maxAmount = allocInfo.getMaxCount())) {
                throw new RuntimeException("Maximum instance count must not be smaller than minimum instance count");
            }
            List<Cluster> authorizedClusters = this.doPrivilegedLookup(zoneName, vmTypeName);
            int remaining = maxAmount;
            int allocated = 0;
            LOG.info((Object)("Found authorized clusters: " + Iterables.transform(authorizedClusters, (Function)HasName.GET_NAME)));
            int available = this.checkAvailability(vmTypeName, authorizedClusters);
            if (available < minAmount) {
                throw new NotEnoughResourcesException("Not enough resources (" + available + " in " + zoneName + " < " + minAmount + "): vm instances.");
            }
            for (Cluster cluster : authorizedClusters) {
                if (remaining <= 0) break;
                ResourceState state = cluster.getNodeState();
                Partition partition = cluster.getConfiguration().lookupPartition();
                if (allocInfo.getPartition().equals((Object)Partition.DEFAULT)) {
                    int zoneAvailable = this.checkZoneAvailability(vmTypeName, partition, authorizedClusters);
                    if (zoneAvailable < minAmount) continue;
                    allocInfo.setPartition(partition);
                } else if (!allocInfo.getPartition().equals((Object)partition)) continue;
                if (!RestrictedTypes.filterPrivileged().apply((Object)VmInstance.exampleResource((OwnerFullName)allocInfo.getOwnerFullName(), allocInfo.getPartition().getName(), allocInfo.getIamInstanceProfileArn(), allocInfo.getVmType().getName(), allocInfo.getBootSet().isBlockStorage()))) {
                    throw new IllegalMetadataAccessException("Instance resource denied.");
                }
                if (allocInfo.getBootSet().getMachine() instanceof BlockStorageImageInfo) {
                    try {
                        Topology.lookup(Storage.class, (Partition[])new Partition[]{partition});
                    }
                    catch (Exception ex) {
                        allocInfo.abort();
                        allocInfo.setPartition(reqPartition);
                        throw new NotEnoughResourcesException("Not enough resources: Cannot run EBS instances in partition w/o a storage controller: " + ex.getMessage(), ex);
                    }
                }
                try {
                    int tryAmount = remaining > state.getAvailability(vmTypeName).getAvailable() ? state.getAvailability(vmTypeName).getAvailable() : remaining;
                    List<ResourceToken> tokens = this.requestResourceToken(allocInfo, tryAmount, maxAmount);
                    remaining -= tokens.size();
                    allocated += tokens.size();
                }
                catch (Exception t) {
                    LOG.error((Object)t);
                    Logs.extreme().error((Object)t, (Throwable)t);
                    allocInfo.abort();
                    allocInfo.setPartition(reqPartition);
                    available = this.checkZoneAvailability(vmTypeName, partition, authorizedClusters);
                    if (available < remaining && remaining > 0) {
                        throw new NotEnoughResourcesException("Not enough resources (" + available + " in " + zoneName + " < " + minAmount + "): vm instances.", t);
                    }
                    throw new NotEnoughResourcesException(t.getMessage(), t);
                }
            }
            if (allocated < minAmount && remaining > 0) {
                allocInfo.abort();
                allocInfo.setPartition(reqPartition);
                if (reqPartition.equals((Object)Partition.DEFAULT)) {
                    throw new NotEnoughResourcesException("Not enough resources available in all zone for " + minAmount + "): vm instances.");
                }
                available = this.checkZoneAvailability(vmTypeName, reqPartition, authorizedClusters);
                throw new NotEnoughResourcesException("Not enough resources (" + available + " in " + zoneName + " < " + minAmount + "): vm instances.");
            }
        }

        private int checkAvailability(String vmTypeName, List<Cluster> authorizedClusters) throws NotEnoughResourcesException {
            int available = 0;
            for (Cluster authorizedCluster : authorizedClusters) {
                ResourceState.VmTypeAvailability vmAvailability = authorizedCluster.getNodeState().getAvailability(vmTypeName);
                available += vmAvailability.getAvailable();
                LOG.info((Object)("Availability: " + authorizedCluster.getName() + " -> " + vmAvailability.getAvailable()));
            }
            return available;
        }

        private int checkZoneAvailability(String vmTypeName, Partition partition, List<Cluster> authorizedClusters) throws NotEnoughResourcesException {
            int available = 0;
            for (Cluster authorizedCluster : authorizedClusters) {
                if (!authorizedCluster.getConfiguration().lookupPartition().equals((Object)partition)) continue;
                ResourceState.VmTypeAvailability vmAvailability = authorizedCluster.getNodeState().getAvailability(vmTypeName);
                available += vmAvailability.getAvailable();
                LOG.info((Object)("Availability: " + authorizedCluster.getName() + " -> " + vmAvailability.getAvailable()));
            }
            return available;
        }

        private List<Cluster> doPrivilegedLookup(String partitionName, String vmTypeName) throws NotEnoughResourcesException {
            if ("".equals(partitionName)) {
                Iterable authorizedClusters = Iterables.filter((Iterable)Clusters.getInstance().listValues(), (Predicate)RestrictedTypes.filterPrivilegedWithoutOwner());
                TreeMultimap sorted = TreeMultimap.create();
                for (Cluster c : authorizedClusters) {
                    sorted.put((Object)c.getNodeState().getAvailability(vmTypeName), (Object)c);
                }
                if (sorted.isEmpty()) {
                    throw new NotEnoughResourcesException("Not enough resources: no availability zone is available in which you have permissions to run instances.");
                }
                return Lists.newArrayList((Iterable)sorted.values());
            }
            ServiceConfiguration ccConfig = Topology.lookup(ClusterController.class, (Partition[])new Partition[]{Partitions.lookupByName((String)partitionName)});
            Cluster cluster = Clusters.lookup(ccConfig);
            if (cluster == null) {
                throw new NotEnoughResourcesException("Can't find cluster " + partitionName);
            }
            if (!RestrictedTypes.filterPrivilegedWithoutOwner().apply((Object)cluster)) {
                throw new NotEnoughResourcesException("Not authorized to use cluster " + partitionName);
            }
            return Lists.newArrayList((Object[])new Cluster[]{cluster});
        }

        @Override
        public void fail(Allocations.Allocation allocInfo, Throwable t) {
            allocInfo.abort();
        }
    }

    private static interface ResourceAllocator {
        public void allocate(Allocations.Allocation var1) throws Exception;

        public void fail(Allocations.Allocation var1, Throwable var2);
    }

    static enum Restore implements Predicate<Allocations.Allocation>
    {
        INSTANCE;


        public boolean apply(Allocations.Allocation allocInfo) {
            ArrayList finished = Lists.newArrayList();
            EntityTransaction db = Entities.get(NetworkGroup.class);
            try {
                for (ResourceAllocator allocator : restorers) {
                    AdmissionControl.runAllocatorSafely(allocInfo, allocator);
                    finished.add(allocator);
                }
                db.commit();
                return true;
            }
            catch (Exception ex) {
                Logs.exhaust().error((Object)ex, (Throwable)ex);
                AdmissionControl.rollbackAllocations(allocInfo, finished, ex);
                db.rollback();
                throw Exceptions.toUndeclared((Throwable)new NotEnoughResourcesException(ex.getMessage(), ex));
            }
        }
    }

    static enum RunAdmissionControl implements Predicate<Allocations.Allocation>
    {
        INSTANCE;


        public boolean apply(Allocations.Allocation allocInfo) {
            if (EventRecord.isTraceEnabled(AdmissionControl.class)) {
                EventRecord.here(AdmissionControl.class, (EventType)EventType.VM_RESERVED, (String[])new String[]{LogUtil.dumpObject((Object)allocInfo)}).trace();
            }
            ArrayList finished = Lists.newArrayList();
            EntityTransaction db = Entities.get(NetworkGroup.class);
            try {
                for (ResourceAllocator allocator : allocators) {
                    AdmissionControl.runAllocatorSafely(allocInfo, allocator);
                    finished.add(allocator);
                }
                db.commit();
                return true;
            }
            catch (Exception ex) {
                Logs.exhaust().error((Object)ex, (Throwable)ex);
                AdmissionControl.rollbackAllocations(allocInfo, finished, ex);
                db.rollback();
                throw Exceptions.toUndeclared((Throwable)new NotEnoughResourcesException(Exceptions.getCauseMessage((Throwable)ex), ex));
            }
        }
    }
}

