/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.cloud;

import com.eucalyptus.auth.principal.UserFullName;
import com.eucalyptus.network.NetworkGroup;
import com.eucalyptus.util.Parameters;
import edu.ucsb.eucalyptus.cloud.VmKeyInfo;
import edu.ucsb.eucalyptus.msgs.CloudClusterMessage;
import edu.ucsb.eucalyptus.msgs.VmTypeInfo;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import org.bouncycastle.util.encoders.Base64;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;

public class VmRunType
extends CloudClusterMessage {
    private static final long serialVersionUID = 1L;
    private String reservationId;
    @Nullable
    private String userData;
    @Nullable
    private String credential;
    @Nullable
    private String rootDirective;
    private String platform;
    private Integer maxCount = 1;
    private Integer minCount = 1;
    private Integer vlan = -1;
    private Integer launchIndex;
    private VmTypeInfo vmTypeInfo;
    @Nullable
    private VmKeyInfo keyInfo;
    private String instanceId;
    private String ownerId;
    private String accountId;
    private String uuid;
    private String macAddress = "";
    private List<String> networkNames = new ArrayList<String>();
    private Long networkIndex = -1L;
    private String privateAddress;

    public static Builder builder() {
        return new Builder();
    }

    VmRunType() {
    }

    private VmRunType(String reservationId, String userData, int amount, VmTypeInfo vmTypeInfo, VmKeyInfo keyInfo, String platform, List<String> instanceIds, int vlan, List<String> networkNames, List<String> networkIndexList, List<String> uuids) {
        this.reservationId = reservationId;
        this.userData = userData;
        this.vlan = vlan;
        this.vmTypeInfo = vmTypeInfo;
        this.keyInfo = keyInfo;
        this.networkNames = networkNames;
        this.platform = platform;
    }

    public String toString() {
        return String.format("VmRunType [instanceIds=%s, keyInfo=%s, launchIndex=%s, amount=%s, networkIndexList=%s, privateAddr=%s,networkNames=%s, reservationId=%s, userData=%s, vlan=%s, vmTypeInfo=%s, rootDirective=%s]", this.instanceId, this.keyInfo, this.launchIndex, this.minCount, this.networkIndex, this.privateAddress, this.networkNames, this.reservationId, this.userData, this.vlan, this.vmTypeInfo, this.rootDirective);
    }

    public String toSimpleString() {
        return String.format("%s %s networkIndex=%s vlan=%s", super.toSimpleString(), this.instanceId, this.networkIndex, this.vlan);
    }

    void setReservationId(String reservationId) {
        this.reservationId = reservationId;
    }

    void setUserData(String userData) {
        this.userData = userData == null ? new String(Base64.encode((byte[])new byte[0])) : userData;
    }

    void setPlatform(String platform) {
        this.platform = platform;
    }

    void setVlan(int vlan) {
        this.vlan = vlan;
    }

    void setLaunchIndex(int launchIndex) {
        this.launchIndex = launchIndex;
    }

    void setVmTypeInfo(VmTypeInfo vmTypeInfo) {
        this.vmTypeInfo = vmTypeInfo;
    }

    void setKeyInfo(VmKeyInfo keyInfo) {
        this.keyInfo = keyInfo;
    }

    void setNetworkNames(List<String> networkNames) {
        this.networkNames = networkNames;
    }

    void setInstanceId(String instanceId) {
        this.instanceId = instanceId;
    }

    public static long getSerialversionuid() {
        return 1L;
    }

    public String getReservationId() {
        return this.reservationId;
    }

    public String getUserData() {
        return this.userData;
    }

    public void setCredential(String credential) {
        this.credential = credential == null ? "" : credential;
    }

    public String getCredential() {
        return this.credential;
    }

    public void setRootDirective(String rootDirective) {
        this.rootDirective = rootDirective == null ? "" : rootDirective;
    }

    public String getRootDirective() {
        return this.rootDirective;
    }

    public String getPlatform() {
        return this.platform;
    }

    public Integer getAmount() {
        return this.minCount;
    }

    public Integer getVlan() {
        return this.vlan;
    }

    public int getLaunchIndex() {
        return this.launchIndex;
    }

    public VmTypeInfo getVmTypeInfo() {
        return this.vmTypeInfo;
    }

    public VmKeyInfo getKeyInfo() {
        return this.keyInfo;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public List<String> getNetworkNames() {
        return this.networkNames;
    }

    public Long getNetworkIndex() {
        return this.networkIndex;
    }

    public String getPrivateAddress() {
        return this.privateAddress;
    }

    void setVlan(Integer vlan) {
        this.vlan = vlan;
    }

    void setLaunchIndex(Integer launchIndex) {
        this.launchIndex = launchIndex;
    }

    void setUuid(String uuid) {
        this.uuid = uuid;
    }

    void setMacAddress(String macAddress) {
        this.macAddress = macAddress;
    }

    public String getUuid() {
        return this.uuid;
    }

    public String getMacAddress() {
        return this.macAddress;
    }

    void setNetworkIndex(Long networkIndex) {
        this.networkIndex = networkIndex;
    }

    void setPrivateAddress(String privateAddress) {
        this.privateAddress = privateAddress;
    }

    public String getOwnerId() {
        return this.ownerId;
    }

    public void setOwnerId(String ownerId) {
        this.ownerId = ownerId;
    }

    public String getAccountId() {
        return this.accountId;
    }

    public void setAccountId(String accountId) {
        this.accountId = accountId;
    }

    public static class Builder {
        private final VmRunType buildit = new VmRunType();

        Builder() {
        }

        public Builder vmTypeInfo(VmTypeInfo vmTypeInfo) {
            this.buildit.setVmTypeInfo(vmTypeInfo);
            return this;
        }

        public Builder keyInfo(VmKeyInfo keyInfo) {
            this.buildit.setKeyInfo(keyInfo);
            return this;
        }

        public Builder vlan(Integer vlan) {
            this.buildit.setVlan(vlan);
            return this;
        }

        public Builder networkIndex(Long networkIndex) {
            this.buildit.setNetworkIndex(networkIndex);
            return this;
        }

        public Builder privateAddress(String privateAddress) {
            this.buildit.setPrivateAddress(privateAddress);
            return this;
        }

        public Builder launchIndex(Integer launchIndex) {
            this.buildit.setLaunchIndex(launchIndex);
            return this;
        }

        public Builder reservationId(String rsvId) {
            this.buildit.setReservationId(rsvId);
            return this;
        }

        public Builder platform(String platform) {
            this.buildit.setPlatform(platform);
            return this;
        }

        public Builder userData(String userData) {
            this.buildit.setUserData(userData);
            return this;
        }

        public Builder credential(String credential) {
            this.buildit.setCredential(credential);
            return this;
        }

        public Builder rootDirective(String rootDirective) {
            this.buildit.setRootDirective(rootDirective);
            return this;
        }

        public Builder networkNames(List<NetworkGroup> list) {
            for (NetworkGroup g : list) {
                this.buildit.getNetworkNames().add(g.getClusterNetworkName());
            }
            return this;
        }

        public Builder naturalId(String naturalId) {
            this.buildit.setUuid(naturalId);
            return this;
        }

        public Builder instanceId(String instanceId) {
            this.buildit.setInstanceId(instanceId);
            return this;
        }

        public Builder macAddress(String mac) {
            this.buildit.setMacAddress(mac);
            return this;
        }

        public VmRunType create() {
            Parameters.checkParam((Object)this.buildit.getInstanceId(), (Matcher)Matchers.notNullValue());
            Parameters.checkParam((Object)this.buildit.getLaunchIndex(), (Matcher)Matchers.notNullValue());
            Parameters.checkParam((Object)this.buildit.getMacAddress(), (Matcher)Matchers.notNullValue());
            Parameters.checkParam((Object)this.buildit.getNetworkNames().isEmpty(), (Matcher)Matchers.is((Object)false));
            Parameters.checkParam((Object)this.buildit.getNetworkIndex(), (Matcher)Matchers.notNullValue());
            Parameters.checkParam((Object)this.buildit.getPlatform(), (Matcher)Matchers.notNullValue());
            Parameters.checkParam((Object)this.buildit.getReservationId(), (Matcher)Matchers.notNullValue());
            Parameters.checkParam((Object)this.buildit.getUuid(), (Matcher)Matchers.notNullValue());
            Parameters.checkParam((Object)this.buildit.getVlan(), (Matcher)Matchers.notNullValue());
            Parameters.checkParam((Object)this.buildit.getVmTypeInfo(), (Matcher)Matchers.notNullValue());
            return this.buildit;
        }

        public Builder owner(UserFullName ownerFullName) {
            this.buildit.setUserId(ownerFullName.getUserId());
            this.buildit.setOwnerId(ownerFullName.getUserId());
            this.buildit.setAccountId(ownerFullName.getAccountNumber());
            return this;
        }
    }
}

