/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.cloud;

import com.eucalyptus.blockstorage.Volume;
import com.eucalyptus.cloud.VmInstanceLifecycleHelpers;
import com.eucalyptus.cloud.run.Allocations;
import com.eucalyptus.cluster.Cluster;
import com.eucalyptus.cluster.Clusters;
import com.eucalyptus.cluster.ResourceState;
import com.eucalyptus.component.Partition;
import com.eucalyptus.component.ServiceConfiguration;
import com.eucalyptus.component.Topology;
import com.eucalyptus.component.id.ClusterController;
import com.eucalyptus.compute.common.CloudMetadata;
import com.eucalyptus.compute.common.CloudMetadatas;
import com.eucalyptus.compute.common.network.Networking;
import com.eucalyptus.compute.common.network.ReleaseNetworkResourcesType;
import com.eucalyptus.util.OwnerFullName;
import com.eucalyptus.util.TypedContext;
import com.eucalyptus.util.TypedKey;
import com.eucalyptus.vm.VmInstance;
import com.eucalyptus.vm.VmInstances;
import com.eucalyptus.vmtypes.VmTypes;
import com.google.common.collect.Maps;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.log4j.Logger;

public class ResourceToken
implements CloudMetadata.VmInstanceMetadata,
Comparable<ResourceToken> {
    private static Logger LOG = Logger.getLogger(ResourceToken.class);
    private final Allocations.Allocation allocation;
    private final Integer launchIndex;
    private final String instanceId;
    private final String instanceUuid;
    @Nullable
    private Volume rootVolume;
    @Nullable
    private Map<String, Volume> ebsVolumes;
    @Nullable
    private Map<String, String> ephemeralDisks;
    private final TypedContext resourceContext = TypedContext.newTypedContext();
    private final Date creationTime;
    @Nullable
    private VmInstance vmInst;
    private final Cluster cluster;
    private boolean aborted;
    private final boolean unorderedType;
    private boolean zombie;

    public ResourceToken(Allocations.Allocation allocInfo, int launchIndex) {
        this.allocation = allocInfo;
        this.launchIndex = launchIndex;
        this.instanceId = allocInfo.getInstanceId(launchIndex);
        this.instanceUuid = allocInfo.getInstanceUuid(launchIndex);
        if (this.instanceId == null || this.instanceUuid == null) {
            throw new IllegalArgumentException("Cannot create resource token with null instance id or uuid: " + allocInfo);
        }
        this.creationTime = Calendar.getInstance().getTime();
        ServiceConfiguration config = Topology.lookup(ClusterController.class, (Partition[])new Partition[]{this.getAllocationInfo().getPartition()});
        this.cluster = Clusters.lookup(config);
        this.unorderedType = VmTypes.isUnorderedType(allocInfo.getVmType());
    }

    public Allocations.Allocation getAllocationInfo() {
        return this.allocation;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public Integer getAmount() {
        return 1;
    }

    public Date getCreationTime() {
        return this.creationTime;
    }

    @Override
    public int compareTo(ResourceToken that) {
        return this.instanceId.compareTo(that.instanceId);
    }

    public String getInstanceUuid() {
        return this.instanceUuid;
    }

    public Integer getLaunchIndex() {
        return this.launchIndex;
    }

    public <T> T getAttribute(TypedKey<T> key) {
        return (T)this.resourceContext.get(key);
    }

    public <T> T setAttribute(TypedKey<T> key, T value) {
        return (T)this.resourceContext.put(key, value);
    }

    public <T> T removeAttribute(TypedKey<T> key) {
        return (T)this.resourceContext.remove(key);
    }

    public void abort() {
        if (this.aborted) {
            return;
        }
        this.aborted = true;
        LOG.debug((Object)this);
        if (this.isPending()) {
            try {
                this.release();
            }
            catch (Exception ex) {
                LOG.error((Object)ex, (Throwable)ex);
            }
            try {
                ReleaseNetworkResourcesType releaseNetworkResourcesType = new ReleaseNetworkResourcesType();
                releaseNetworkResourcesType.setVpc(this.allocation.getSubnet() == null ? null : (String)CloudMetadatas.toDisplayName().apply((Object)this.allocation.getSubnet().getVpc()));
                releaseNetworkResourcesType.getResources().addAll((Collection)this.getAttribute(VmInstanceLifecycleHelpers.NetworkResourceVmInstanceLifecycleHelper.NetworkResourcesKey));
                Networking.getInstance().release(releaseNetworkResourcesType);
            }
            catch (Exception ex) {
                LOG.error((Object)ex, (Throwable)ex);
            }
            if (this.vmInst != null) {
                try {
                    VmInstances.terminated(this.vmInst);
                }
                catch (Exception ex) {
                    LOG.error((Object)ex, (Throwable)ex);
                }
            }
        } else {
            try {
                this.redeem();
            }
            catch (Exception ex) {
                LOG.error((Object)ex, (Throwable)ex);
            }
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.instanceId.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ResourceToken other = (ResourceToken)obj;
        return this.instanceId.equals(other.instanceId);
    }

    static Logger getLOG() {
        return LOG;
    }

    Allocations.Allocation getAllocation() {
        return this.allocation;
    }

    public void submit() throws ResourceState.NoSuchTokenException {
        this.cluster.getNodeState().submitToken(this);
    }

    public void redeem() throws ResourceState.NoSuchTokenException {
        this.cluster.getNodeState().redeemToken(this);
    }

    public void release() throws ResourceState.NoSuchTokenException {
        this.cluster.getNodeState().releaseToken(this);
    }

    public boolean isPending() {
        return this.cluster.getNodeState().isPending(this);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("ResourceToken:");
        if (this.instanceId != null) {
            builder.append(this.instanceId).append(":");
        }
        builder.append("resources=").append(this.resourceContext);
        return builder.toString();
    }

    public void setVmInstance(VmInstance vmInst) {
        this.vmInst = vmInst;
    }

    public VmInstance getVmInstance() {
        return this.vmInst;
    }

    public String getDisplayName() {
        return this.getInstanceId();
    }

    public boolean isCommitted() {
        return this.allocation.isCommitted();
    }

    public OwnerFullName getOwner() {
        return this.allocation.getOwnerFullName();
    }

    public Volume getRootVolume() {
        return this.rootVolume;
    }

    public void setRootVolume(Volume rootVolume) {
        this.rootVolume = rootVolume;
    }

    public Map<String, Volume> getEbsVolumes() {
        if (this.ebsVolumes == null) {
            this.ebsVolumes = Maps.newHashMap();
        }
        return this.ebsVolumes;
    }

    public void setEbsVolumes(Map<String, Volume> ebsVolumes) {
        this.ebsVolumes = ebsVolumes;
    }

    public Map<String, String> getEphemeralDisks() {
        if (this.ephemeralDisks == null) {
            this.ephemeralDisks = Maps.newHashMap();
        }
        return this.ephemeralDisks;
    }

    public void setEphemeralDisks(Map<String, String> ephemeralDisks) {
        this.ephemeralDisks = ephemeralDisks;
    }

    public boolean isUnorderedType() {
        return this.unorderedType;
    }

    public Cluster getCluster() {
        return this.cluster;
    }

    public boolean isZombie() {
        return this.zombie;
    }

    public void setZombie(boolean zombie) {
        this.zombie = zombie;
    }
}

