/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.cloud;

import com.eucalyptus.bootstrap.BootstrapArgs;
import com.eucalyptus.bootstrap.Databases;
import com.eucalyptus.bootstrap.Handles;
import com.eucalyptus.bootstrap.Host;
import com.eucalyptus.bootstrap.Hosts;
import com.eucalyptus.cloud.EucalyptusConfiguration;
import com.eucalyptus.component.AbstractServiceBuilder;
import com.eucalyptus.component.ComponentId;
import com.eucalyptus.component.Faults;
import com.eucalyptus.component.ServiceConfiguration;
import com.eucalyptus.component.ServiceRegistrationException;
import com.eucalyptus.component.Topology;
import com.eucalyptus.component.annotation.ComponentPart;
import com.eucalyptus.component.id.Eucalyptus;
import com.eucalyptus.compute.common.config.DeregisterEucalyptusType;
import com.eucalyptus.compute.common.config.DescribeEucalyptusType;
import com.eucalyptus.compute.common.config.ModifyEucalyptusAttributeType;
import com.eucalyptus.compute.common.config.RegisterEucalyptusType;
import com.eucalyptus.records.EventRecord;
import com.eucalyptus.records.EventType;
import com.eucalyptus.util.Exceptions;
import com.eucalyptus.util.Internets;
import com.google.common.base.Predicate;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.apache.log4j.Logger;

@ComponentPart(value=Eucalyptus.class)
@Handles(value={RegisterEucalyptusType.class, DeregisterEucalyptusType.class, DescribeEucalyptusType.class, ModifyEucalyptusAttributeType.class})
public class EucalyptusBuilder
extends AbstractServiceBuilder<EucalyptusConfiguration> {
    static Logger LOG = Logger.getLogger(EucalyptusBuilder.class);

    public EucalyptusConfiguration newInstance() {
        return new EucalyptusConfiguration();
    }

    public EucalyptusConfiguration newInstance(String partition, String name, String host, Integer port) {
        try {
            InetAddress.getByName(host);
            return new EucalyptusConfiguration(host, host);
        }
        catch (UnknownHostException e) {
            return new EucalyptusConfiguration(Internets.localHostAddress(), Internets.localHostAddress());
        }
    }

    public ComponentId getComponentId() {
        return Eucalyptus.INSTANCE;
    }

    public void fireStart(ServiceConfiguration config) throws ServiceRegistrationException {
    }

    public void fireEnable(ServiceConfiguration config) throws ServiceRegistrationException {
        if (!config.isVmLocal().booleanValue()) {
            for (Host h : Hosts.list()) {
                if (!h.getHostAddresses().contains((Object)config.getInetAddress())) continue;
                EventRecord.here(EucalyptusBuilder.class, (EventType)EventType.COMPONENT_SERVICE_ENABLED, (String[])new String[]{config.toString()}).info();
                return;
            }
            throw Faults.failure((ServiceConfiguration)config, (Throwable[])new Throwable[]{Exceptions.error((String)("There is no host in the system (yet) for the given cloud controller configuration: " + config.getFullName() + ".\nHosts are: " + Hosts.list()))});
        }
        if (config.isVmLocal().booleanValue() && !Hosts.isCoordinator()) {
            throw Faults.failure((ServiceConfiguration)config, (Throwable[])new Throwable[]{Exceptions.error((String)("This cloud controller " + config.getFullName() + " is not currently the coordinator " + Hosts.list()))});
        }
        if (config.isVmLocal().booleanValue() && Hosts.isCoordinator()) {
            Databases.Locks.DISABLED.delete();
        }
    }

    public void fireDisable(ServiceConfiguration config) throws ServiceRegistrationException {
        if (!Hosts.isCoordinator()) {
            Databases.Locks.DISABLED.create();
        }
    }

    public void fireStop(ServiceConfiguration config) throws ServiceRegistrationException {
    }

    public void fireCheck(ServiceConfiguration config) throws ServiceRegistrationException {
        Host coordinator = Hosts.getCoordinator();
        if (coordinator == null) {
            throw Faults.failure((ServiceConfiguration)config, (Throwable[])new Throwable[]{Exceptions.error((String)(config.getFullName() + ":fireCheck(): failed to lookup coordinator (" + coordinator + ")."))});
        }
        if (coordinator.isLocalHost()) {
            Check.COORDINATOR.apply(config);
        } else if (!coordinator.isLocalHost()) {
            Check.SECONDARY.apply(config);
        }
    }

    static enum Check implements Predicate<ServiceConfiguration>
    {
        COORDINATOR{

            @Override
            public boolean apply(ServiceConfiguration config) {
                if (!Databases.isRunning()) {
                    LOG.fatal((Object)"config.getFullName( ) : does not have a running database. Restarting process to force re-synchronization.");
                    System.exit(123);
                }
                return true;
            }
        }
        ,
        SECONDARY{

            @Override
            public boolean apply(ServiceConfiguration config) {
                if (config.isVmLocal().booleanValue()) {
                    if (BootstrapArgs.isCloudController().booleanValue() && !Databases.isRunning()) {
                        LOG.fatal((Object)"config.getFullName( ) : does not have a running database. Restarting process to force re-synchronization.");
                        System.exit(123);
                    }
                    if (!Databases.isSynchronized().booleanValue()) {
                        throw Faults.failure((ServiceConfiguration)config, (Throwable[])new Throwable[]{Exceptions.error((String)(config.getFullName() + ":fireCheck(): eucalyptus service " + config.getFullName() + " is currently synchronizing: " + Hosts.getCoordinator()))});
                    }
                    if (Topology.isEnabledLocally(Eucalyptus.class)) {
                        throw Faults.failure((ServiceConfiguration)config, (Throwable[])new Throwable[]{Exceptions.error((String)(config.getFullName() + ":fireCheck(): eucalyptus service " + config.getFullName() + " cant be enabled when it is not the coordinator: " + Hosts.getCoordinator()))});
                    }
                    LOG.debug((Object)(config.getFullName() + ":fireCheck() completed with coordinator currently: " + Hosts.getCoordinator()));
                }
                return true;
            }
        };


        public abstract boolean apply(ServiceConfiguration var1);
    }
}

