/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.blockstorage;

import com.eucalyptus.auth.principal.UserFullName;
import com.eucalyptus.blockstorage.State;
import com.eucalyptus.blockstorage.Storage;
import com.eucalyptus.blockstorage.Volume;
import com.eucalyptus.blockstorage.VolumeTag;
import com.eucalyptus.blockstorage.msgs.CreateStorageVolumeResponseType;
import com.eucalyptus.blockstorage.msgs.CreateStorageVolumeType;
import com.eucalyptus.blockstorage.msgs.DescribeStorageVolumesResponseType;
import com.eucalyptus.blockstorage.msgs.DescribeStorageVolumesType;
import com.eucalyptus.blockstorage.msgs.StorageVolume;
import com.eucalyptus.component.Partition;
import com.eucalyptus.component.Partitions;
import com.eucalyptus.component.ServiceConfiguration;
import com.eucalyptus.component.Topology;
import com.eucalyptus.component.id.Eucalyptus;
import com.eucalyptus.compute.common.CloudMetadata;
import com.eucalyptus.compute.identifier.ResourceIdentifiers;
import com.eucalyptus.entities.Entities;
import com.eucalyptus.entities.TransactionException;
import com.eucalyptus.entities.TransactionResource;
import com.eucalyptus.entities.Transactions;
import com.eucalyptus.event.ClockTick;
import com.eucalyptus.event.Event;
import com.eucalyptus.event.EventListener;
import com.eucalyptus.event.ListenerRegistry;
import com.eucalyptus.event.Listeners;
import com.eucalyptus.records.Logs;
import com.eucalyptus.reporting.event.EventActionInfo;
import com.eucalyptus.reporting.event.VolumeEvent;
import com.eucalyptus.system.Threads;
import com.eucalyptus.tags.FilterSupport;
import com.eucalyptus.util.Callback;
import com.eucalyptus.util.EucalyptusCloudException;
import com.eucalyptus.util.Exceptions;
import com.eucalyptus.util.OwnerFullName;
import com.eucalyptus.util.RestrictedTypes;
import com.eucalyptus.util.async.AsyncRequests;
import com.eucalyptus.vm.VmInstance;
import com.eucalyptus.vm.VmInstances;
import com.eucalyptus.vm.VmVolumeAttachment;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import edu.ucsb.eucalyptus.msgs.BaseMessage;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.persistence.EntityTransaction;
import org.apache.log4j.Logger;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Example;

public class Volumes {
    public static String ID_PREFIX = "vol";
    private static Logger LOG = Logger.getLogger(Volumes.class);
    private static final long VOLUME_STATE_TIMEOUT = 0x6DDD00L;
    private static final long VOLUME_DELETE_TIMEOUT = 1800000L;

    public static Volume checkVolumeReady(final Volume vol) throws EucalyptusCloudException {
        if (vol.isReady()) {
            return vol;
        }
        final ServiceConfiguration sc = Topology.lookup(Storage.class, (Partition[])new Partition[]{Partitions.lookupByName((String)vol.getPartition())});
        final DescribeStorageVolumesType descVols = new DescribeStorageVolumesType(Lists.newArrayList((Object[])new String[]{vol.getDisplayName()}));
        try {
            Transactions.one((Object)((Object)Volume.named(null, vol.getDisplayName())), (Callback)new Callback<Volume>(){

                public void fire(Volume t) {
                    try {
                        DescribeStorageVolumesResponseType volState = (DescribeStorageVolumesResponseType)AsyncRequests.sendSync((ServiceConfiguration)sc, (BaseMessage)descVols);
                        if (!volState.getVolumeSet().isEmpty()) {
                            State newVolumeState = Volumes.transformStorageState((State)vol.getState(), ((StorageVolume)volState.getVolumeSet().get(0)).getStatus());
                            vol.setState(newVolumeState);
                        }
                    }
                    catch (Exception ex) {
                        LOG.error((Object)ex);
                        Logs.extreme().error((Object)ex, (Throwable)ex);
                        throw Exceptions.toUndeclared((String)("Failed to update the volume state " + vol.getDisplayName() + " not yet ready"), (Throwable[])new Exception[]{ex});
                    }
                }
            });
        }
        catch (ExecutionException ex) {
            throw new EucalyptusCloudException(ex.getCause());
        }
        if (!vol.isReady()) {
            throw new EucalyptusCloudException("Volume " + vol.getDisplayName() + " not yet ready");
        }
        return vol;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Volume lookup(OwnerFullName ownerFullName, String volumeId) {
        Throwable throwable = null;
        try (TransactionResource db = Entities.transactionFor(Volume.class);){
            Volume volume = (Volume)((Object)Entities.uniqueResult((Object)((Object)Volume.named(ownerFullName, volumeId))));
            db.commit();
            Volume volume2 = volume;
            return volume2;
        }
        catch (NoSuchElementException e) {
            try {
                throw e;
                catch (Exception ex) {
                    LOG.debug((Object)ex, (Throwable)ex);
                    throw Exceptions.toUndeclared((Throwable)ex);
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    public static Volume createStorageVolume(final ServiceConfiguration sc, UserFullName owner, final String snapId, Integer newSize, BaseMessage request) throws ExecutionException {
        String newId = ResourceIdentifiers.generateString(ID_PREFIX);
        LOG.debug((Object)"Creating volume");
        Volume newVol = (Volume)((Object)Transactions.save((Object)((Object)Volume.create(sc, owner, snapId, newSize, newId)), (Callback)new Callback<Volume>(){

            public void fire(Volume t) {
                t.setState(State.GENERATING);
                try {
                    CreateStorageVolumeType req = new CreateStorageVolumeType(t.getDisplayName(), t.getSize(), snapId, null);
                    CreateStorageVolumeResponseType ret = (CreateStorageVolumeResponseType)AsyncRequests.sendSync((ServiceConfiguration)sc, (BaseMessage)req);
                    LOG.debug((Object)"Volume created");
                    if (t.getSize() != null && t.getSize() > 0) {
                        Volumes.fireUsageEvent(t, (EventActionInfo<VolumeEvent.VolumeAction>)VolumeEvent.forVolumeCreate());
                    }
                }
                catch (Exception ex) {
                    LOG.error((Object)("Failed to create volume: " + (Object)((Object)t)), (Throwable)ex);
                    t.setState(State.FAIL);
                    throw Exceptions.toUndeclared((Throwable)ex);
                }
            }
        }));
        return newVol;
    }

    public static void annihilateStorageVolume(Volume volume) {
        volume.setState(State.ANNIHILATING);
        Volumes.fireUsageEvent(volume, (EventActionInfo<VolumeEvent.VolumeAction>)VolumeEvent.forVolumeDelete());
    }

    static State transformStorageState(State volumeState, String storageState) {
        if (State.GENERATING.equals((Object)volumeState)) {
            if ("failed".equals(storageState)) {
                return State.FAIL;
            }
            if ("error".equals(storageState)) {
                return State.ERROR;
            }
            if ("available".equals(storageState)) {
                return State.EXTANT;
            }
            return State.GENERATING;
        }
        if (State.ANNIHILATING.equals((Object)volumeState)) {
            if ("deleted".equals(storageState)) {
                return State.ANNIHILATED;
            }
            return State.ANNIHILATING;
        }
        if (!State.ANNIHILATING.equals((Object)volumeState) && !State.BUSY.equals((Object)volumeState)) {
            if ("failed".equals(storageState)) {
                return State.FAIL;
            }
            if ("creating".equals(storageState)) {
                return State.GENERATING;
            }
            if ("available".equals(storageState)) {
                return State.EXTANT;
            }
            if ("in-use".equals(storageState)) {
                return State.BUSY;
            }
            if ("error".equals(storageState)) {
                return State.ERROR;
            }
            return State.ANNIHILATED;
        }
        if (State.BUSY.equals((Object)volumeState)) {
            return State.BUSY;
        }
        if (State.ERROR.equals((Object)volumeState)) {
            if ("available".equals(storageState)) {
                return State.EXTANT;
            }
            if ("deleted".equals(storageState)) {
                return State.ANNIHILATED;
            }
            return State.ERROR;
        }
        if ("failed".equals(storageState)) {
            return State.FAIL;
        }
        if ("error".equals(storageState)) {
            return State.ERROR;
        }
        return State.ANNIHILATED;
    }

    static void fireUsageEvent(Volume volume, EventActionInfo<VolumeEvent.VolumeAction> actionInfo) {
        try {
            ListenerRegistry.getInstance().fireEvent((Event)VolumeEvent.with(actionInfo, (String)volume.getNaturalId(), (String)volume.getDisplayName(), (int)volume.getSize(), (OwnerFullName)volume.getOwner(), (String)volume.getPartition()));
        }
        catch (Throwable e) {
            LOG.error((Object)("Error creating/inserting reporting event " + (actionInfo == null ? "null" : ((VolumeEvent.VolumeAction)actionInfo.getAction()).toString()) + " for volume " + (volume == null ? "null" : volume.getDisplayName())), e);
        }
    }

    private static enum FilterBooleanFunctions implements Function<Volume, Boolean>
    {
        ATTACHMENT_DELETE_ON_TERMINATION{

            public Boolean apply(Volume vol) {
                try {
                    VmVolumeAttachment attachment = VmInstances.lookupVolumeAttachment(vol.getDisplayName());
                    return attachment.getDeleteOnTerminate();
                }
                catch (Throwable e) {
                    return false;
                }
            }
        };

    }

    private static enum FilterDateFunctions implements Function<Volume, Date>
    {
        ATTACHMENT_ATTACH_TIME{

            public Date apply(Volume vol) {
                try {
                    VmVolumeAttachment attachment = VmInstances.lookupVolumeAttachment(vol.getDisplayName());
                    return attachment.getAttachTime();
                }
                catch (Throwable e) {
                    return null;
                }
            }
        }
        ,
        CREATE_TIME{

            public Date apply(Volume vol) {
                return vol.getCreationTimestamp();
            }
        };

    }

    private static enum FilterStringFunctions implements Function<Volume, String>
    {
        ATTACHMENT_DEVICE{

            public String apply(Volume vol) {
                try {
                    VmVolumeAttachment attachment = VmInstances.lookupVolumeAttachment(vol.getDisplayName());
                    return attachment.getDevice();
                }
                catch (Throwable e) {
                    return null;
                }
            }
        }
        ,
        ATTACHMENT_INSTANCE_ID{

            public String apply(Volume vol) {
                try {
                    VmVolumeAttachment attachment = VmInstances.lookupVolumeAttachment(vol.getDisplayName());
                    return attachment.getVmInstance().getInstanceId();
                }
                catch (Throwable e) {
                    return null;
                }
            }
        }
        ,
        ATTACHMENT_STATUS{

            public String apply(Volume vol) {
                try {
                    VmVolumeAttachment attachment = VmInstances.lookupVolumeAttachment(vol.getDisplayName());
                    return attachment.getStatus();
                }
                catch (Throwable e) {
                    return null;
                }
            }
        }
        ,
        AVAILABILITY_ZONE{

            public String apply(Volume vol) {
                return vol.getPartition();
            }
        }
        ,
        SIZE{

            public String apply(Volume vol) {
                return vol.getSize().toString();
            }
        }
        ,
        SNAPSHOT_ID{

            public String apply(Volume vol) {
                return vol.getParentSnapshot();
            }
        }
        ,
        STATUS{

            public String apply(Volume vol) {
                return vol.mapState();
            }
        }
        ,
        VOLUME_ID{

            public String apply(Volume vol) {
                return vol.getDisplayName();
            }
        };

    }

    public static class VolumeFilterSupport
    extends FilterSupport<Volume> {
        public VolumeFilterSupport() {
            super(VolumeFilterSupport.builderFor(Volume.class).withTagFiltering(VolumeTag.class, "volume").withDateProperty("attachment.attach-time", FilterDateFunctions.ATTACHMENT_ATTACH_TIME).withBooleanProperty("attachment.delete-on-termination", FilterBooleanFunctions.ATTACHMENT_DELETE_ON_TERMINATION).withStringProperty("attachment.device", FilterStringFunctions.ATTACHMENT_DEVICE).withStringProperty("attachment.instance-id", FilterStringFunctions.ATTACHMENT_INSTANCE_ID).withStringProperty("attachment.status", FilterStringFunctions.ATTACHMENT_STATUS).withStringProperty("availability-zone", FilterStringFunctions.AVAILABILITY_ZONE).withDateProperty("create-time", FilterDateFunctions.CREATE_TIME).withStringProperty("size", FilterStringFunctions.SIZE).withStringProperty("snapshot-id", FilterStringFunctions.SNAPSHOT_ID).withStringProperty("status", FilterStringFunctions.STATUS).withStringProperty("volume-id", FilterStringFunctions.VOLUME_ID).withConstantProperty("volume-type", "standard").withPersistenceFilter("availability-zone", "partition").withPersistenceFilter("create-time", "creationTimestamp", FilterSupport.PersistenceFilter.Type.Date).withPersistenceFilter("size", "size", FilterSupport.PersistenceFilter.Type.Integer).withPersistenceFilter("snapshot-id", "parentSnapshot").withPersistenceFilter("volume-id", "displayName"));
        }
    }

    public static class VolumeUpdateEvent
    implements EventListener<ClockTick>,
    Callable<Boolean> {
        private static final AtomicBoolean ready = new AtomicBoolean(true);

        public static void register() {
            Listeners.register(ClockTick.class, (EventListener)new VolumeUpdateEvent());
        }

        public void fireEvent(ClockTick event) {
            if (Topology.isEnabledLocally(Eucalyptus.class) && ready.compareAndSet(true, false)) {
                try {
                    Threads.enqueue(Eucalyptus.class, Volumes.class, (Callable)this);
                }
                catch (Exception ex) {
                    ready.set(true);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Boolean call() throws Exception {
            try {
                VolumeUpdateEvent.update();
            }
            finally {
                ready.set(true);
            }
            return true;
        }

        static void update() {
            HashMultimap partitionVolumeMap = HashMultimap.create();
            EntityTransaction db = Entities.get(Volume.class);
            try {
                for (Volume v : Entities.query((Object)((Object)Volume.named(null, null)))) {
                    partitionVolumeMap.put((Object)v.getPartition(), (Object)v.getDisplayName());
                }
                db.rollback();
            }
            catch (Exception ex) {
                Logs.extreme().error((Object)ex, (Throwable)ex);
                db.rollback();
            }
            Logs.extreme().debug((Object)("Volume state update: " + Joiner.on((String)"\n").join((Iterable)partitionVolumeMap.entries())));
            EntityTransaction dbInstance = Entities.get(VmInstance.class);
            try {
                List vms = Entities.query((Object)((Object)VmInstance.create()));
                dbInstance.rollback();
                for (String partition : partitionVolumeMap.keySet()) {
                    try {
                        Map<String, StorageVolume> idStorageVolumeMap = VolumeUpdateEvent.updateVolumesInPartition(partition);
                        for (String v : partitionVolumeMap.get((Object)partition)) {
                            try {
                                StorageVolume storageVolume = idStorageVolumeMap.get(v);
                                VolumeUpdateEvent.volumeStateUpdate(v, storageVolume, vms);
                            }
                            catch (Exception ex) {
                                LOG.error((Object)ex);
                                Logs.extreme().error((Object)ex, (Throwable)ex);
                            }
                        }
                    }
                    catch (Exception ex) {
                        LOG.error((Object)ex);
                        Logs.extreme().error((Object)ex, (Throwable)ex);
                    }
                }
            }
            catch (Exception ex) {
                Logs.extreme().error((Object)ex, (Throwable)ex);
                throw ex;
            }
            finally {
                if (dbInstance.isActive()) {
                    dbInstance.rollback();
                }
            }
        }

        static void volumeStateUpdate(String volumeId, final StorageVolume storageVolume, final List<VmInstance> vms) {
            Function<String, Volume> updateVolume = new Function<String, Volume>(){

                public Volume apply(String input) {
                    StringBuilder buf = new StringBuilder();
                    try {
                        Volume v = (Volume)((Object)Entities.uniqueResult((Object)((Object)Volume.named(null, input))));
                        VmVolumeAttachment vmAttachedVol = null;
                        boolean maybeBusy = false;
                        String vmId = null;
                        try {
                            vmAttachedVol = VmInstances.lookupVolumeAttachment(v.getDisplayName(), vms);
                            maybeBusy = true;
                            vmId = vmAttachedVol.getVmInstance().getInstanceId();
                        }
                        catch (NoSuchElementException noSuchElementException) {
                            // empty catch block
                        }
                        State initialState = (State)v.getState();
                        if (!State.ANNIHILATING.equals((Object)initialState) && !State.ANNIHILATED.equals((Object)initialState) && maybeBusy) {
                            initialState = State.BUSY;
                        }
                        buf.append("VolumeStateUpdate: Current Volume Info: [").append("Partition: ").append(v.getPartition()).append(" ").append("Name: ").append(v.getDisplayName()).append(" ").append("CurrentState: ").append(v.getState()).append(" ").append("Created: ").append(v.getCreationTimestamp()).append(" ]");
                        if (vmAttachedVol != null) {
                            buf.append(" Attachment: [ ").append("InstanceId: ").append(vmId).append(" ").append("AttachmentState: ").append((Object)vmAttachedVol.getAttachmentState()).append(" ]");
                        }
                        String status = null;
                        Integer size = 0;
                        String actualDeviceName = "unknown";
                        State volumeState = initialState;
                        if (storageVolume != null) {
                            status = storageVolume.getStatus();
                            size = Integer.parseInt(storageVolume.getSize());
                            actualDeviceName = storageVolume.getActualDeviceName();
                            volumeState = State.ANNIHILATING.equals((Object)initialState) && State.ANNIHILATED.equals((Object)Volumes.transformStorageState((State)v.getState(), status)) ? State.ANNIHILATED : Volumes.transformStorageState((State)v.getState(), status);
                            buf.append(" Incoming state update: [").append("State: ").append(storageVolume.getStatus()).append("=>").append((Object)volumeState).append(" ").append("Size: ").append(storageVolume.getSize()).append("GB ").append("SourceSnapshotId: ").append(storageVolume.getSnapshotId()).append(" ").append("CreationTime: ").append(storageVolume.getCreateTime()).append(" ").append("DeviceName: ").append(storageVolume.getActualDeviceName()).append(" ] ");
                        } else if (State.ANNIHILATING.equals(v.getState())) {
                            volumeState = State.ANNIHILATED;
                        } else if (State.GENERATING.equals(v.getState()) && v.lastUpdateMillis() > 0x6DDD00L) {
                            volumeState = State.FAIL;
                        } else if (State.EXTANT.equals(v.getState()) && v.lastUpdateMillis() > 0x6DDD00L) {
                            volumeState = State.ERROR;
                        }
                        v.setState(volumeState);
                        try {
                            if (v.getSize() <= 0) {
                                v.setSize(size);
                                if (EnumSet.of(State.GENERATING, State.EXTANT, State.BUSY).contains((Object)volumeState)) {
                                    Volumes.fireUsageEvent(v, (EventActionInfo<VolumeEvent.VolumeAction>)VolumeEvent.forVolumeCreate());
                                }
                            }
                        }
                        catch (Exception ex) {
                            LOG.error((Object)ex);
                            Logs.extreme().error((Object)ex, (Throwable)ex);
                        }
                        buf.append(" Resulting new-state: [").append(v.getState()).append("]");
                        LOG.debug((Object)buf.toString());
                        return v;
                    }
                    catch (TransactionException ex) {
                        LOG.error((Object)(buf.toString() + " failed because of " + ex.getMessage()));
                        Logs.extreme().error((Object)(buf.toString() + " failed because of " + ex.getMessage()), (Throwable)ex);
                        throw Exceptions.toUndeclared((Throwable)ex);
                    }
                    catch (NoSuchElementException ex) {
                        LOG.error((Object)(buf.toString() + " failed because of " + ex.getMessage()));
                        Logs.extreme().error((Object)(buf.toString() + " failed because of " + ex.getMessage()), (Throwable)ex);
                        throw ex;
                    }
                }
            };
            Entities.asTransaction(Volume.class, (Function)updateVolume).apply((Object)volumeId);
        }

        static Map<String, StorageVolume> updateVolumesInPartition(String partition) {
            HashMap idStorageVolumeMap = Maps.newHashMap();
            ServiceConfiguration scConfig = Topology.lookup(Storage.class, (Partition[])new Partition[]{Partitions.lookupByName((String)partition)});
            try {
                DescribeStorageVolumesResponseType volState = (DescribeStorageVolumesResponseType)AsyncRequests.sendSync((ServiceConfiguration)scConfig, (BaseMessage)new DescribeStorageVolumesType());
                for (StorageVolume vol : volState.getVolumeSet()) {
                    LOG.trace((Object)("Volume states: " + vol.getVolumeId() + " " + vol.getStatus() + " " + vol.getActualDeviceName()));
                    idStorageVolumeMap.put(vol.getVolumeId(), vol);
                }
            }
            catch (Exception ex) {
                LOG.error((Object)ex);
                Logs.extreme().error((Object)ex, (Throwable)ex);
            }
            return idStorageVolumeMap;
        }
    }

    @RestrictedTypes.UsageMetricFunction(value=CloudMetadata.VolumeMetadata.class)
    public static enum MeasureVolumes implements Function<OwnerFullName, Long>
    {
        INSTANCE;


        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Long apply(OwnerFullName input) {
            Long size = 0L;
            EntityTransaction db = Entities.get(Volume.class);
            try {
                List vols = Entities.createCriteria(Volume.class).add((Criterion)Example.create((Object)((Object)Volume.named(input, null)))).setReadOnly(true).setCacheable(false).list();
                for (Volume v : vols) {
                    size = size + (long)v.getSize().intValue();
                }
            }
            finally {
                db.rollback();
            }
            return size;
        }
    }

    @RestrictedTypes.QuantityMetricFunction(value=CloudMetadata.VolumeMetadata.class)
    public static enum CountVolumes implements Function<OwnerFullName, Long>
    {
        INSTANCE;


        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Long apply(OwnerFullName input) {
            EntityTransaction db = Entities.get(Volume.class);
            try {
                Long l = Entities.count((Object)((Object)Volume.named(input, null)));
                return l;
            }
            finally {
                db.rollback();
            }
        }
    }
}

